/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.message.MessageDeletionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.engine.helpers.message.ReturnReceiptStatus;
import io.olvid.windows.messenger.engine.helpers.message.tasks.CreateReadMessageMetadata;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.AppSettingsHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ForceScheduleNextMessageExpirationTaskNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class InboundEphemeralUnboxTask
implements Runnable {
    private final Id<InboundMessage> messageId;
    private final long alreadyElapsedDelay;
    private final boolean unboxOnAnotherDevice;

    public InboundEphemeralUnboxTask(Id<InboundMessage> messageId, long alreadyElapsedDelay, boolean unboxOnAnotherDevice) {
        this.messageId = messageId;
        this.alreadyElapsedDelay = alreadyElapsedDelay;
        this.unboxOnAnotherDevice = unboxOnAnotherDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ViewControllerHelper.checkNotUIThread();
        AppLogger.d("InboundEphemeralUnboxTask::run");
        InboundMessage message = DbManager.getInstance().getInboundMessageDao().get(this.messageId);
        if (message == null) {
            AppLogger.e("Try to unbox a message that does not exists.");
            return;
        }
        Optional<InboundMessageEphemeralInfo> messageEphemeralInfoOpt = DbManager.getInstance().getInboundMessageDao().getEphemeralInfo(message);
        if (messageEphemeralInfoOpt.isEmpty()) {
            AppLogger.e("Try to unbox ephemeral message without MessageEphemeralInfo.");
            return;
        }
        InboundMessageEphemeralInfo messageEphemeralInfo = messageEphemeralInfoOpt.get();
        if (!messageEphemeralInfo.isReadOnce() && messageEphemeralInfo.getVisibilityDuration().isEmpty()) {
            AppLogger.e("Found ephemeral message with no visibility duration and no read once");
            return;
        }
        boolean expirationCreated = false;
        AppLogger.d("InboundEphemeralUnboxTask::run got expiration data");
        try {
            expirationCreated = TransactionWrapper.startQueryTransaction(() -> {
                if (!message.isBoxed()) {
                    return false;
                }
                if (!this.unboxOnAnotherDevice) {
                    message.setBoxed(false);
                }
                if (messageEphemeralInfo.isReadOnce()) {
                    if (this.unboxOnAnotherDevice) {
                        MessageDeletionHelper.deleteMessagesDbTask(List.of(message), false);
                        return false;
                    }
                    message.setWipeStatus(AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ);
                }
                AppLogger.d("InboundEphemeralUnboxTask::run message status updated in app db");
                DbManager.getInstance().getInboundMessageDao().update(message);
                AppLogger.d("InboundEphemeralUnboxTask:: mark as read message");
                new CreateReadMessageMetadata(message).run();
                boolean sendReadReceiptConfigured = AppSettingsHelper.needToSendReadReceiptsInDiscussionDbTask(message.getDiscussionId());
                if (sendReadReceiptConfigured) {
                    Api.getMessageApi().sendMessageReturnReceipt(message, ReturnReceiptStatus.READ);
                }
                if (messageEphemeralInfo.getVisibilityDuration().isPresent() && messageEphemeralInfo.getVisibilityTimestamp().isEmpty()) {
                    AppLogger.d("InboundEphemeralUnboxTask::add visibility expiration.");
                    long visibilityDuration = messageEphemeralInfo.getVisibilityDuration().get();
                    long visibilityTimestamp = System.currentTimeMillis() + visibilityDuration * 1000L - this.alreadyElapsedDelay;
                    DbManager.getInstance().getInboundMessageEphemeralInfoDao().updateVisibilityExpiration((Id<InboundMessageEphemeralInfo>)messageEphemeralInfo.getItemId(), visibilityTimestamp);
                    return true;
                }
                return false;
            });
        }
        catch (SQLException e) {
            AppLogger.e("InboundEphemeralUnboxTask:run something went wrong while executing transaction", e);
            return;
        }
        finally {
            if (expirationCreated) {
                NCRegistry.getUtilityNC().postNotification(new ForceScheduleNextMessageExpirationTaskNotification());
                AppLogger.d("InboundEphemeralUnboxTask::run message scheduled new expiration handler");
            }
        }
        if (!this.unboxOnAnotherDevice) {
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
            MessagePostHelper.postLimitedVisibilityMessageOpenedMessage(discussion, message);
        }
    }
}

