/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import java.util.NoSuchElementException;

public interface IMessageSender {
    public boolean isMe();

    public boolean isContact();

    public Contact getContact();

    public OwnedIdentity getMe();

    public byte[] getIdentityBytes();

    public IdentityRef getIdentityRef();

    public static IMessageSender makeOwnedMessageSender(OwnedIdentity ownedIdentity) {
        return new OwnedMessageSender(ownedIdentity);
    }

    public static IMessageSender makeContactMessageSender(Contact contact) {
        return new ContactMessageSender(contact);
    }

    public static class OwnedMessageSender
    implements IMessageSender {
        final OwnedIdentity sender;

        public OwnedMessageSender(OwnedIdentity identity) {
            this.sender = identity;
        }

        @Override
        public boolean isMe() {
            return true;
        }

        @Override
        public OwnedIdentity getMe() {
            return this.sender;
        }

        @Override
        public Contact getContact() {
            throw new NoSuchElementException("OwnedMessageSender::getContact : not a Contact");
        }

        @Override
        public boolean isContact() {
            return false;
        }

        @Override
        public byte[] getIdentityBytes() {
            return this.sender.getBytesOwnedIdentity();
        }

        @Override
        public IdentityRef getIdentityRef() {
            return DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef((Id<OwnedIdentity>)this.sender.getItemId());
        }
    }

    public static class ContactMessageSender
    implements IMessageSender {
        private final Contact sender;

        public ContactMessageSender(Contact contact) {
            this.sender = contact;
        }

        @Override
        public boolean isMe() {
            return false;
        }

        @Override
        public boolean isContact() {
            return true;
        }

        @Override
        public Contact getContact() {
            return this.sender;
        }

        @Override
        public OwnedIdentity getMe() {
            throw new NoSuchElementException("ContactMessageSender::getMe : not an Owned identity");
        }

        @Override
        public byte[] getIdentityBytes() {
            return this.sender.getBytesContactIdentity();
        }

        @Override
        public IdentityRef getIdentityRef() {
            ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(this.sender);
            return DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contactRef);
        }
    }
}

