/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.engine.Logger;
import io.olvid.windows.messenger.database.datatypes.json.JsonLocation;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.helpers.message.LinkPreviewInfo;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.tasks.PostMessageTask;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class ForwardMessageTask
implements BooleanSupplier {
    protected static final AppLogger logger = new AppLogger(ForwardMessageTask.class);
    private final AbstractUserMessageGenerated<?> message;
    private final List<Id<Discussion>> discussions;

    public ForwardMessageTask(AbstractUserMessageGenerated<?> message, List<Id<Discussion>> discussions) {
        this.message = message;
        this.discussions = discussions;
    }

    public static List<AbstractAttachmentGenerated<?>> getAttachmentsForMessage(AbstractUserMessageGenerated<?> message) {
        ArrayList attachments = new ArrayList();
        if (message instanceof InboundMessage) {
            InboundMessage inboundMessage = (InboundMessage)message;
            attachments.addAll(DbManager.getInstance().getInboundAttachmentDao().getAttachmentsForMessage(inboundMessage.getItemId()));
        } else if (message instanceof OwnedMessage) {
            OwnedMessage ownedMessage = (OwnedMessage)message;
            attachments.addAll(DbManager.getInstance().getOwnedAttachmentDao().getAttachmentsForMessage(ownedMessage.getItemId()));
        } else if (message instanceof OutboundMessage) {
            OutboundMessage outboundMessage = (OutboundMessage)message;
            attachments.addAll(DbManager.getInstance().getOutboundAttachmentDao().getAttachmentsForMessage(outboundMessage.getItemId()));
        } else {
            logger.error("Found unexpected kind of message");
        }
        return attachments;
    }

    public static boolean isAttachmentAvailable(AbstractAttachmentGenerated<?> attachment) {
        if ("olvid/link-preview".equals(attachment.getMimeType())) {
            return true;
        }
        if (attachment instanceof ReceivedAttachmentGenerated) {
            ReceivedAttachmentGenerated receivedAttachment = (ReceivedAttachmentGenerated)attachment;
            return receivedAttachment.getStatus() == ReceivedAttachmentGenerated.Status.COMPLETE;
        }
        if (attachment instanceof OutboundAttachment) {
            return true;
        }
        logger.error("Found unexpected kind of attachment");
        return false;
    }

    @Override
    public boolean getAsBoolean() {
        try {
            Location location;
            List<AbstractAttachmentGenerated<?>> attachments = ForwardMessageTask.getAttachmentsForMessage(this.message);
            if (!attachments.stream().allMatch(ForwardMessageTask::isAttachmentAvailable)) {
                logger.error("Try to forward a message with incomplete attachments");
                return false;
            }
            boolean isForwarded = this.message instanceof InboundMessage;
            if (this.message.getLocationId().isPresent()) {
                Location messageLocation = DbManager.getInstance().getLocationDao().get(this.message.getLocationId().get());
                JsonLocation jsonLocation = messageLocation.toJson();
                jsonLocation.setType(1);
                Optional<Location> locationCopy = Location.of(jsonLocation);
                location = locationCopy.orElse(null);
                DbManager.getInstance().getLocationDao().create(location);
            } else {
                location = null;
            }
            for (Id<Discussion> discussionId : this.discussions) {
                Optional outboundMessageId = TransactionWrapper.startQueryTransaction(() -> {
                    Discussion discussion = (Discussion)DbManager.getInstance().getDiscussionDao().get(discussionId);
                    if (discussion == null) {
                        Logger.e((String)"ForwardMessageTask::run discussion not found");
                        return Optional.empty();
                    }
                    discussion.setLastOutboundMessageSequenceNumber(discussion.getLastOutboundMessageSequenceNumber() + 1L);
                    if (discussion.isHidden()) {
                        discussion.setStatus(DiscussionGenerated.Status.NORMAL);
                        DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
                    }
                    DbManager.getInstance().getDiscussionDao().updateLastOutboundMessageSequenceNumber(discussion);
                    Optional<LinkPreviewInfo> linkPreviewInfo = LinkPreviewInfo.of(attachments);
                    OutboundMessage outboundMessage = MessageBuilder.createOutboundMessage(discussion, Optional.empty(), location, this.message.getBody(), isForwarded, Optional.empty(), this.message.getTotalAttachmentCount(), this.message.getImageCount(), linkPreviewInfo);
                    DbManager.getInstance().getOutboundMessageDao().create(outboundMessage);
                    for (AbstractAttachmentGenerated attachment : attachments) {
                        Fyle fyle = new Fyle(attachment.getFyleId().getId());
                        OwnedIdentity ownedIdentity = new OwnedIdentity(attachment.getOwnedIdentityId().getId());
                        OutboundAttachment outboundAttachment = new OutboundAttachment(fyle, ownedIdentity, discussion, outboundMessage, attachment.getFilename(), attachment.getMimeType(), attachment.getIdx());
                        outboundAttachment.setSize(attachment.getSize());
                        outboundAttachment.setStatus(OutboundAttachmentGenerated.Status.UNPROCESSED);
                        DbManager.getInstance().getOutboundAttachmentDao().create(outboundAttachment);
                    }
                    return Optional.of(outboundMessage.getItemId());
                });
                if (outboundMessageId.isPresent()) {
                    new PostMessageTask((Id)outboundMessageId.get()).run();
                    continue;
                }
                logger.error("ForwardMessageTask::run couldn't retrieve one of the forward discussion recipient");
            }
        }
        catch (Exception e) {
            logger.error("Cannot forward message", e);
            return false;
        }
        return true;
    }
}

