/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.attachment.tasks.CreateDraftAttachmentTask;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteDraftAttachmentsDbTask;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageDeletionHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.CancelDraftLoadingNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.DraftImportNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DraftsBackupTask
implements Runnable {
    private final Id<Discussion> discussionId;
    private final String text;
    private Optional<OutboundMessage> previousDraftMessage;
    public static final Map<Id<Discussion>, Optional<String>> draftPerDiscussion = new ConcurrentHashMap<Id<Discussion>, Optional<String>>();
    private final List<File> draftAttachmentFiles;
    private final Optional<DataInputStruct> dataInputStruct;
    private List<OutboundAttachment> knwonsDrafts;
    private final HashMap<File, OutboundAttachment> attachmentPerFile = new HashMap();
    private final AtomicBoolean cancelRequested = new AtomicBoolean(false);
    private final AtomicBoolean cancelAllRequested = new AtomicBoolean(false);
    private final NotificationListener<CancelDraftLoadingNotification> cancelNotificationListener = this::cancelNotificationReceived;

    public DraftsBackupTask(Id<Discussion> discussionId, String text, List<File> draftAttachmentFiles) {
        this.discussionId = discussionId;
        this.text = text;
        this.draftAttachmentFiles = draftAttachmentFiles == null ? Collections.emptyList() : draftAttachmentFiles;
        this.dataInputStruct = Optional.empty();
    }

    public DraftsBackupTask(Id<Discussion> discussionId, String text, DataInputStruct dataInputStruct) {
        this.discussionId = discussionId;
        this.text = text;
        this.draftAttachmentFiles = Collections.emptyList();
        this.dataInputStruct = Optional.of(dataInputStruct);
    }

    private boolean hasAttachments() {
        return !this.draftAttachmentFiles.isEmpty() || this.dataInputStruct.isPresent();
    }

    @Override
    public void run() {
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(this.discussionId);
        if (discussion == null) {
            return;
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                OutboundMessage draftMessage;
                this.previousDraftMessage = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage(this.discussionId);
                this.knwonsDrafts = DbManager.getInstance().getOutboundAttachmentDao().getDiscussionDraftAndCopyingAttachments(this.discussionId);
                Optional<OutboundMessage> draftMessageOpt = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage(this.discussionId);
                if (draftMessageOpt.isEmpty()) {
                    if ((this.text == null || this.text.isEmpty()) && !this.hasAttachments()) {
                        AppLogger.d("no draft exists, and we don't have any text to save -> nothing to do here!");
                        return null;
                    }
                    draftMessage = MessageBuilder.createEmptyDraft(discussion);
                    draftMessage = DbManager.getInstance().getOutboundMessageDao().createIfNotExists(draftMessage);
                    if (draftMessage == null) {
                        throw new IllegalStateException("DraftBakupTask::run Couldn't create draft message");
                    }
                    draftMessageOpt = Optional.of(draftMessage);
                    AppLogger.d("Saved draft id --> " + String.valueOf(draftMessage.getItemId()));
                } else if (this.previousDraftMessage.isEmpty() || !Objects.equals(this.previousDraftMessage, draftMessageOpt)) {
                    AppLogger.d("the draft message was updated in the background, we do not overwrite it with our text" + String.valueOf(draftMessageOpt.get().getItemId()));
                    return null;
                }
                draftMessage = draftMessageOpt.get();
                if (draftMessage.getBody().isPresent() && Objects.equals(draftMessage.getBody().get(), this.text)) {
                    AppLogger.d("the draft did not change, no need to do anything here on text message" + String.valueOf(draftMessage.getItemId()));
                    if (this.hasAttachments()) {
                        AppLogger.i("DraftsBackupTask::run nacking up drafts attachments for unchanged message");
                        this.createDraftAttachment(discussion, draftMessage);
                        return null;
                    }
                    return null;
                }
                if (draftMessage.getTotalAttachmentCount() == 0 && (this.text == null || this.text.isEmpty()) && draftMessage.getReplyToId().isEmpty() && !this.hasAttachments() && this.knwonsDrafts.isEmpty()) {
                    Optional<MessageRef> messageRef = DbManager.getInstance().getMessageRefDao().get((AbstractUserMessageGenerated<?>)draftMessage);
                    Optional<AbstractMessageGenerated<?>> lastMessageInDiscussion = DbManager.getInstance().getDiscussionDao().computeLastMessage(discussion, false);
                    if (lastMessageInDiscussion.isPresent()) {
                        DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, lastMessageInDiscussion.get(), true);
                    } else {
                        DbManager.getInstance().getDiscussionDao().clearLastMessage(discussion);
                    }
                    if (messageRef.isPresent()) {
                        DbManager.getInstance().getMessageRefDao().delete(messageRef.get());
                    }
                    MessageDeletionHelper.deleteMessagesDbTask(List.of(draftMessage), false);
                    draftPerDiscussion.remove(draftMessage.getDiscussionId(), draftMessage.getBody());
                    AppLogger.d("the draft was cleared --> delete it / message id" + String.valueOf(draftMessage.getItemId()));
                    return null;
                }
                AppLogger.d("calling update draft message --> message id" + String.valueOf(draftMessage.getItemId()));
                draftMessage.setBody(Optional.ofNullable(this.text));
                long timestamp = System.currentTimeMillis();
                draftMessage.setSortIndex(timestamp);
                draftMessage.setTimestamp(timestamp);
                DbManager.getInstance().getOutboundMessageDao().update(draftMessage);
                draftPerDiscussion.put(draftMessage.getDiscussionId(), draftMessage.getBody());
                DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, draftMessage, false);
                if (!this.hasAttachments()) {
                    AppLogger.e("DraftsBackupTask::run draftAttachmentFiles is null or empty, not handling draft attachment");
                    return null;
                }
                this.createDraftAttachment(discussion, draftMessage);
                return null;
            });
        }
        catch (SQLException e) {
            AppLogger.e("Something went wrong in SaveDraftTask db transaction", e);
        }
    }

    private void createDraftAttachment(Discussion discussion, OutboundMessage draftMessage) {
        Object draftAttachment;
        NCRegistry.getUtilityNC().subscribe(UtilityNC.UtilityNotificationEnumType.CANCEL_DRAFT_ATTACHMENT_LOADING, this.cancelNotificationListener);
        int idx = this.knwonsDrafts.isEmpty() ? 0 : this.knwonsDrafts.get(this.knwonsDrafts.size() - 1).getIdx() + 1;
        for (int i = 0; i < this.draftAttachmentFiles.size(); ++i) {
            File file = this.draftAttachmentFiles.get(i);
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                NCRegistry.getUIActionNC().postNotification(new DraftImportNotification(this.draftAttachmentFiles.size() - i, (Id<Discussion>)discussion.getItemId()));
                draftAttachment = new CreateDraftAttachmentTask(discussion, raf, raf.length(), file.getName(), AttachmentUtils.determineMimeType(file), draftMessage, idx, this.cancelRequested, this.cancelAllRequested, this::cancelAttachment).call();
                if (((Optional)draftAttachment).isEmpty()) continue;
                this.attachmentPerFile.put(file, (OutboundAttachment)((Optional)draftAttachment).get());
                ++idx;
                if (this.cancelRequested.get()) {
                    this.cancelAttachment((OutboundAttachment)((Optional)draftAttachment).get());
                    continue;
                }
                if (!this.cancelAllRequested.get() && (!this.cancelAllRequested.get() || !this.cancelRequested.get()) && !Thread.currentThread().isInterrupted()) continue;
                this.cancelAllDrafts();
                continue;
            }
            catch (Exception e) {
                AppLogger.e("CreateDraftAttachmentTask failed to handle draft creation for file : " + file.getName());
            }
        }
        if (this.dataInputStruct.isPresent()) {
            DataInputStruct input = this.dataInputStruct.get();
            ByteArrayInputStream bais = new ByteArrayInputStream(input.bytes);
            DataInputStream datainput = new DataInputStream(bais);
            draftAttachment = new CreateDraftAttachmentTask(discussion, datainput, input.bytes.length, UUID.randomUUID().toString(), input.mimeType, draftMessage, idx, this.cancelRequested, this.cancelAllRequested, this::cancelAttachment).call();
            if (this.cancelRequested.get() && ((Optional)draftAttachment).isPresent() && !Thread.currentThread().isInterrupted()) {
                this.cancelAttachment((OutboundAttachment)((Optional)draftAttachment).get());
            } else if (this.cancelAllRequested.get() || this.cancelAllRequested.get() && this.cancelRequested.get() || Thread.currentThread().isInterrupted()) {
                this.cancelAllDrafts();
            }
        }
        NCRegistry.getUIActionNC().postNotification(new DraftImportNotification(0, (Id<Discussion>)discussion.getItemId()));
        NCRegistry.getUtilityNC().unSubscribe(UtilityNC.UtilityNotificationEnumType.CANCEL_DRAFT_ATTACHMENT_LOADING, this.cancelNotificationListener);
    }

    private void cancelAllDrafts() {
        AppLogger.i("CreateDraftAttachmentTask was canceled");
        AsyncTaskExecutor.submitTask(() -> {
            for (File file : this.draftAttachmentFiles) {
                OutboundAttachment attachment = this.attachmentPerFile.get(file);
                if (file == null || attachment == null) continue;
                new DeleteDraftAttachmentsDbTask(attachment).run();
            }
            NCRegistry.getUtilityNC().unSubscribe(UtilityNC.UtilityNotificationEnumType.CANCEL_DRAFT_ATTACHMENT_LOADING, this.cancelNotificationListener);
        });
    }

    private void cancelAttachment(OutboundAttachment draftAttachment) {
        new DeleteDraftAttachmentsDbTask(draftAttachment).run();
        this.cancelRequested.set(false);
    }

    private void cancelNotificationReceived(NotificationType cancelNotification) {
        if (!(cancelNotification instanceof CancelDraftLoadingNotification)) {
            return;
        }
        CancelDraftLoadingNotification casted = (CancelDraftLoadingNotification)cancelNotification;
        if (casted.getIncomingValue() != null) {
            this.cancelRequested.set(true);
        } else {
            this.cancelAllRequested.set(true);
        }
    }

    public record DataInputStruct(byte[] bytes, String mimeType) {
    }
}

