/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message;

import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import java.util.Optional;

public class MessageInsertionHelper {
    public static boolean insertDiscussionSettingsUpdateMessageDbTask(Discussion discussion, JsonExpiration jsonExpiration, IdentityRef identityRef, long messageTimestamp, MessageBuilder.MessageSystemPosition position) {
        SystemMessage message = MessageBuilder.createDiscussionSettingsUpdateMessage(discussion, jsonExpiration, identityRef, messageTimestamp, position);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, message);
    }

    public static boolean insertContactDeletedMessage(Discussion discussion) {
        SystemMessage contactDeletedMessage = MessageBuilder.createContactDeletedMessage(discussion);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, contactDeletedMessage);
    }

    public static boolean insertLeftGroupMessage(Discussion discussion) {
        SystemMessage groupLeftMessage = MessageBuilder.createLeftGroupMessage(discussion);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, groupLeftMessage);
    }

    public static boolean insertMemberJoinedGroupMessage(Discussion discussion, ContactRef member) {
        SystemMessage memberJoinedMessage = MessageBuilder.createMemberJoinedGroupMessage(discussion, member);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, memberJoinedMessage);
    }

    public static boolean insertMemberLeftGroupMessage(Discussion discussion, ContactRef member) {
        SystemMessage memberLeftMessage = MessageBuilder.createMemberLeftGroupMessage(discussion, member);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, memberLeftMessage);
    }

    public static boolean insertDiscussionRemotelyDeletedMessage(Discussion discussion, IdentityRef remoteDeleter, long serverTimestamp) {
        SystemMessage discussionRemotelyDeleted = MessageBuilder.createDiscussionRemotelyDeletedMessage(discussion, remoteDeleter, serverTimestamp);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, discussionRemotelyDeleted);
    }

    public static boolean insertNewPublishedDetailsMessage(Discussion discussion, ContactRef contact) {
        SystemMessage newPublishedDetailsMessage = MessageBuilder.createNewPublishedDetailsMessage(discussion, Optional.of(contact));
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, newPublishedDetailsMessage);
    }

    public static boolean insertContactReAddedMessage(Discussion discussion, ContactRef contactRef) {
        SystemMessage newPublishedDetailsMessage = MessageBuilder.createContactReAddedMessage(discussion, contactRef);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, newPublishedDetailsMessage);
    }

    public static boolean insertGroupReJoinedMessage(Discussion discussion) {
        SystemMessage newPublishedDetailsMessage = MessageBuilder.createGroupReJoinedMessage(discussion);
        return MessageInsertionHelper.insertMessageInDbAndRefreshDiscussionLastMessage(discussion, newPublishedDetailsMessage);
    }

    private static boolean insertMessageInDbAndRefreshDiscussionLastMessage(Discussion discussion, SystemMessage message) {
        message = DbManager.getInstance().getSystemMessageDao().createIfNotExists(message);
        if (message == null) {
            return false;
        }
        if (discussion.isHidden()) {
            discussion.setStatus(DiscussionGenerated.Status.NORMAL);
            DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
        }
        DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, message, false);
        return true;
    }
}

