/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message;

import io.olvid.engine.engine.types.identities.ObvContactActiveOrInactiveReason;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessage;
import io.olvid.windows.messenger.database.datatypes.json.JsonReturnReceipt;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.SystemMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.engine.helpers.message.LinkPreviewInfo;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.UnmatchedEnumValue;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public class MessageBuilder {
    private MessageBuilder() {
    }

    public static OutboundMessage createOutboundMessage(Discussion discussion, Optional<MessageRef> replyTo, Location location, Optional<String> body, boolean isForwarded, Optional<PollMessage> pollMessage, int totalAttachmentCount, int imageCount, Optional<LinkPreviewInfo> linkPreviewInfo) {
        double sortIndex = OutboundMessage.computeSortIndex(discussion);
        AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind = linkPreviewInfo.map(LinkPreviewInfo::getLinkPreviewKind).orElse(AbstractUserMessageGenerated.LinkPreviewKind.NONE);
        return new OutboundMessage(0L, discussion, discussion.getLastOutboundMessageSequenceNumber(), sortIndex, System.currentTimeMillis(), body.orElse(null), replyTo.orElse(null), location, AbstractUserMessageGenerated.WipeStatus.NONE, discussion.getSenderThreadIdentifier(), totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewInfo.flatMap(LinkPreviewInfo::description).orElse(null), linkPreviewInfo.flatMap(LinkPreviewInfo::imageWidth).orElse(null), AbstractUserMessageGenerated.EditionStatus.NONE, isForwarded, pollMessage.orElse(null), null, OutboundMessageGenerated.Status.UNPROCESSED);
    }

    public static OutboundMessage createEmptyDraft(Discussion discussion) {
        return new OutboundMessage(0L, discussion, discussion.getLastOutboundMessageSequenceNumber() + 1L, System.currentTimeMillis(), System.currentTimeMillis(), null, null, null, AbstractUserMessageGenerated.WipeStatus.NONE, discussion.getSenderThreadIdentifier(), 0, 0, AbstractUserMessageGenerated.LinkPreviewKind.NONE, null, null, AbstractUserMessageGenerated.EditionStatus.NONE, false, null, null, OutboundMessageGenerated.Status.DRAFT);
    }

    public static OwnedMessage createOwnedMessage(Discussion discussion, JsonMessage jsonMessage, byte[] engineMessageIdentifier, JsonReturnReceipt jsonReturnReceipt, long messageServerTimestamp, int totalAttachmentCount, int imageCount, Optional<LinkPreviewInfo> linkPreviewInfo) throws SQLException {
        PollMessage pollMessage;
        Location location;
        MessageHelper.InsertionInfo insertionInfo = OwnedMessage.computeInsertionInfo(discussion, jsonMessage.senderThreadIdentifier, jsonMessage.senderSequenceNumber, messageServerTimestamp);
        MessageRef replyTo = jsonMessage.jsonReply != null ? DbManager.getInstance().getMessageRefDao().getOrCreate(discussion, jsonMessage.jsonReply) : null;
        if (jsonMessage.jsonLocation != null) {
            location = Location.of(jsonMessage.jsonLocation).orElse(null);
            location = DbManager.getInstance().getLocationDao().createIfNotExists(location);
        } else {
            location = null;
        }
        AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind = linkPreviewInfo.map(LinkPreviewInfo::getLinkPreviewKind).orElse(AbstractUserMessageGenerated.LinkPreviewKind.NONE);
        if (jsonMessage.jsonPoll != null) {
            pollMessage = PollMessage.of(jsonMessage.jsonPoll).orElse(null);
            pollMessage = DbManager.getInstance().getPollMessageDao().createIfNotExists(pollMessage);
            DbManager.getInstance().getPollMessageOptionDao().create(pollMessage.choices);
        } else {
            pollMessage = null;
        }
        return new OwnedMessage(0L, discussion, jsonMessage.senderSequenceNumber, insertionInfo.sortIndex(), insertionInfo.adjustedTimestamp(), jsonMessage.body, replyTo, location, AbstractUserMessageGenerated.WipeStatus.NONE, jsonMessage.senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewInfo.flatMap(LinkPreviewInfo::description).orElse(null), linkPreviewInfo.flatMap(LinkPreviewInfo::imageWidth).orElse(null), AbstractUserMessageGenerated.EditionStatus.NONE, jsonMessage.isForwarded(), pollMessage, jsonReturnReceipt.getNonce(), jsonReturnReceipt.getKey(), engineMessageIdentifier, insertionInfo.missingMessageCount(), null, OwnedMessageGenerated.Status.SENT);
    }

    public static InboundMessage createInboundMessage(Discussion discussion, Contact contact, JsonMessage jsonMessage, JsonReturnReceipt jsonReturnReceipt, byte[] engineMessageIdentifier, long messageServerTimestamp, int totalAttachmentCount, int imageCount, InboundMessageGenerated.Status status, boolean boxed, Optional<LinkPreviewInfo> linkPreviewInfo) throws SQLException {
        PollMessage pollMessage;
        Location location;
        MessageRef replyTo = jsonMessage.jsonReply != null ? DbManager.getInstance().getMessageRefDao().getOrCreate(discussion, jsonMessage.jsonReply) : null;
        if (jsonMessage.jsonLocation != null) {
            location = Location.of(jsonMessage.jsonLocation).orElse(null);
            location = DbManager.getInstance().getLocationDao().createIfNotExists(location);
        } else {
            location = null;
        }
        if (jsonMessage.jsonPoll != null) {
            pollMessage = PollMessage.of(jsonMessage.jsonPoll).orElse(null);
            pollMessage = DbManager.getInstance().getPollMessageDao().createIfNotExists(pollMessage);
            DbManager.getInstance().getPollMessageOptionDao().create(pollMessage.choices);
        } else {
            pollMessage = null;
        }
        ContactRef sender = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
        long senderSequenceNumber = jsonMessage.getSenderSequenceNumber();
        UUID senderThreadIdentifier = jsonMessage.getSenderThreadIdentifier();
        MessageHelper.InsertionInfo insertionInfo = InboundMessage.computeInsertionInfo(discussion, senderThreadIdentifier, sender, senderSequenceNumber, messageServerTimestamp);
        AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind = linkPreviewInfo.map(LinkPreviewInfo::getLinkPreviewKind).orElse(AbstractUserMessageGenerated.LinkPreviewKind.NONE);
        return new InboundMessage(0L, discussion, senderSequenceNumber, insertionInfo.sortIndex(), insertionInfo.adjustedTimestamp(), jsonMessage.getBody(), replyTo, location, AbstractUserMessageGenerated.WipeStatus.NONE, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewInfo.flatMap(LinkPreviewInfo::description).orElse(null), linkPreviewInfo.flatMap(LinkPreviewInfo::imageWidth).orElse(null), AbstractUserMessageGenerated.EditionStatus.NONE, jsonMessage.isForwarded(), pollMessage, jsonReturnReceipt.getNonce(), jsonReturnReceipt.getKey(), engineMessageIdentifier, insertionInfo.missingMessageCount(), null, sender, status, boxed);
    }

    public static SystemMessage createContactDeletedMessage(Discussion discussion) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.CONTACT_DELETED);
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(discussion.getOwnedIdentityId());
        builder.setIdentityRef(identityRef);
        return builder.build();
    }

    public static SystemMessage createLeftGroupMessage(Discussion discussion) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.LEFT_GROUP);
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(discussion.getOwnedIdentityId());
        builder.setIdentityRef(identityRef);
        return builder.build();
    }

    public static SystemMessage createMemberJoinedGroupMessage(Discussion discussion, ContactRef contact) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.GROUP_MEMBER_JOINED);
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contact);
        builder.setIdentityRef(identityRef);
        return builder.build();
    }

    public static SystemMessage createMemberLeftGroupMessage(Discussion discussion, ContactRef contact) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.GROUP_MEMBER_LEFT);
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contact);
        builder.setIdentityRef(identityRef);
        return builder.build();
    }

    public static SystemMessage createDiscussionSettingsUpdateMessage(Discussion discussion, JsonExpiration jsonExpiration, IdentityRef identityRef, long messageTimestamp, MessageSystemPosition position) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.DISCUSSION_SETTINGS_UPDATE);
        builder.setIdentityRef(identityRef);
        builder.setTimestamp(messageTimestamp);
        switch (position.ordinal()) {
            case 0: {
                builder.setSortIndex(0.0);
                break;
            }
            case 1: {
                builder.setSortIndex(Double.valueOf(messageTimestamp));
            }
        }
        if (jsonExpiration != null) {
            builder.setExpiration(jsonExpiration);
        }
        return builder.build();
    }

    public static SystemMessage createDiscussionRemotelyDeletedMessage(Discussion discussion, IdentityRef remoteDeleter, long serverTimestamp) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.DISCUSSION_REMOTELY_DELETED);
        builder.setIdentityRef(remoteDeleter);
        builder.setTimestamp(serverTimestamp);
        return builder.build();
    }

    public static SystemMessage createNewPublishedDetailsMessage(Discussion discussion, Optional<ContactRef> contactRef) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.NEW_PUBLISHED_DETAILS);
        if (contactRef.isPresent()) {
            IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contactRef.get());
            builder.setIdentityRef(identityRef);
        }
        return builder.build();
    }

    public static SystemMessage createContactReAddedMessage(Discussion discussion, ContactRef contact) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.CONTACT_RE_ADDED);
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contact);
        builder.setIdentityRef(identityRef);
        return builder.build();
    }

    public static SystemMessage createGroupReJoinedMessage(Discussion discussion) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.RE_JOINED_GROUP);
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(discussion.getOwnedIdentityId());
        builder.setIdentityRef(identityRef);
        return builder.build();
    }

    public static SystemMessage createGainedGroupAdminMessage(Discussion discussion) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.GAINED_GROUP_ADMIN);
        return builder.build();
    }

    public static SystemMessage createLostGroupAdminMessage(Discussion discussion) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.LOST_GROUP_ADMIN);
        return builder.build();
    }

    public static SystemMessage createGroupMembersJoinedMessage(Discussion discussion) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.GROUP_MEMBERS_JOINED);
        return builder.build();
    }

    public static SystemMessage createGroupMembersLeftMessage(Discussion discussion) {
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, SystemMessageGenerated.Category.GROUP_MEMBERS_LEFT);
        return builder.build();
    }

    public static SystemMessage createContactInactiveReasonMessage(Discussion discussion, ObvContactActiveOrInactiveReason reason) {
        SystemMessageGenerated.Category category = null;
        switch (reason) {
            case FORCEFULLY_UNBLOCKED: {
                category = SystemMessageGenerated.Category.CONTACT_FORCEFULLY_UNBLOCKED;
                break;
            }
            case REVOKED: {
                category = SystemMessageGenerated.Category.CONTACT_REVOKED;
            }
        }
        if (category == null) {
            throw new UnmatchedEnumValue((Enum<?>)reason);
        }
        SystemMessageBuilder builder = new SystemMessageBuilder(discussion, category);
        return builder.build();
    }

    private static class SystemMessageBuilder {
        private final Discussion discussion;
        private final SystemMessageGenerated.Category category;
        private Double sortIndex = null;
        private Long timestamp = null;
        private IdentityRef identityRef = null;
        private Boolean readOnce = null;
        private Long visibilityDuration = null;
        private Long existenceDuration = null;

        SystemMessageBuilder(Discussion discussion, SystemMessageGenerated.Category category) {
            this.discussion = discussion;
            this.category = category;
        }

        public SystemMessageBuilder setSortIndex(Double sortIndex) {
            if (this.sortIndex != null) {
                AppLogger.e("SystemMessageBuilder: SortIndex is already set");
            }
            this.sortIndex = sortIndex;
            return this;
        }

        public SystemMessageBuilder setTimestamp(Long timestamp) {
            if (this.timestamp != null) {
                AppLogger.e("SystemMessageBuilder: Timestamp is already set");
            }
            this.timestamp = timestamp;
            return this;
        }

        public SystemMessageBuilder setIdentityRef(IdentityRef identityRef) {
            if (this.identityRef != null) {
                AppLogger.e("SystemMessageBuilder: IdentityRef is already set");
            }
            this.identityRef = identityRef;
            return this;
        }

        public SystemMessageBuilder setExpiration(JsonExpiration expiration) {
            if (this.readOnce != null || this.visibilityDuration != null || this.existenceDuration != null) {
                AppLogger.e("SystemMessageBuilder: expiration is already set");
            }
            this.readOnce = expiration.getReadOnce();
            this.visibilityDuration = expiration.getVisibilityDuration();
            this.existenceDuration = expiration.getExistenceDuration();
            return this;
        }

        SystemMessage build() {
            double sortIndex = this.sortIndex == null ? (double)System.currentTimeMillis() : this.sortIndex;
            long timestamp = this.timestamp == null ? System.currentTimeMillis() : this.timestamp;
            return new SystemMessage(0L, this.discussion, 0L, sortIndex, timestamp, this.category, this.identityRef, this.readOnce, this.visibilityDuration, this.existenceDuration);
        }
    }

    public static enum MessageSystemPosition {
        FIRST_MESSAGE,
        MESSAGE_TIMESTAMP;

    }
}

