/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.invitations;

import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvDialog;
import io.olvid.engine.engine.types.identities.ObvUrlIdentity;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Collection;

public class InvitationApi {
    public static String getUrlRepresentation(OwnedIdentityInfo ownedIdentity) {
        if (ownedIdentity == null) {
            AppLogger.e("InvitationApi: getUrlRepresentation: invalid parameter given: null");
            return null;
        }
        ObvUrlIdentity obvUrlIdentity = new ObvUrlIdentity(ownedIdentity.bytesOwnedIdentity(), ownedIdentity.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY));
        return obvUrlIdentity.getUrlRepresentation(false);
    }

    public static String getUrlRepresentation(ContactInfo contact) {
        if (contact == null) {
            AppLogger.e("InvitationApi: getUrlRepresentation(contact): invalid parameter given: " + String.valueOf(contact));
            return null;
        }
        ObvUrlIdentity obvUrlIdentity = new ObvUrlIdentity(contact.bytesContactIdentity(), contact.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY));
        return obvUrlIdentity.getUrlRepresentation(false);
    }

    public static boolean sendInvitation(String invitationUrl, byte[] bytesOwnedIdentity) {
        ObvUrlIdentity obvUrlIdentity = ObvUrlIdentity.fromUrlRepresentation((String)invitationUrl);
        if (obvUrlIdentity == null) {
            AppLogger.i("InvitationApi: sendInvitation: cannot parse given url");
            return false;
        }
        try {
            EngineWrapper.getInstance().startTrustEstablishmentProtocol(obvUrlIdentity.getBytesIdentity(), obvUrlIdentity.displayName, bytesOwnedIdentity);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: sendInvitation: engine exception", e);
            return false;
        }
    }

    public static boolean answerInvitation(Invitation invitation, boolean accept, byte[] ownedIdentityBytes) {
        if (invitation == null) {
            AppLogger.e("InvitationApi: answerInvitation: invalid parameter given: " + String.valueOf(invitation));
            return false;
        }
        if (invitation.getState() != InvitationGenerated.State.INVITATION_WAIT_YOU_TO_ACCEPT) {
            AppLogger.e("InvitationApi: answerInvitation: invalid invitation state: " + String.valueOf(invitation.getState()));
            return false;
        }
        try {
            Encoded encodedData = new Encoded(invitation.getEncodedData());
            ObvDialog obvDialog = new ObvDialog(invitation.getDialogUuid(), encodedData, ownedIdentityBytes, new ObvDialog.Category(InvitationApi.getObvDialogCategoryId(invitation.getState()), null, null, null, null, null, null, null, null, null, null, null, null));
            obvDialog.setResponseToAcceptInvite(accept);
            EngineWrapper.getInstance().respondToDialog(obvDialog);
            if (!accept) {
                EngineWrapper.getInstance().deletePersistedDialog(invitation.getDialogUuid());
            }
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: answerInvitation: exception", e);
            return false;
        }
    }

    public static boolean submitSas(Invitation invitation, String sasCode, byte[] ownedIdentityBytes) {
        if (invitation == null) {
            AppLogger.e("InvitationApi: submitSas: invalid parameter given: " + String.valueOf(invitation));
            return false;
        }
        if (invitation.getState() != InvitationGenerated.State.INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE) {
            AppLogger.e("InvitationApi: submitSas: invalid invitation state: " + String.valueOf(invitation.getState()));
            return false;
        }
        if (!sasCode.matches("^\\d\\d\\d\\d$")) {
            AppLogger.e("InvitationApi: submitSas: Sas Code format is invalid");
            return false;
        }
        try {
            Encoded encodedData = new Encoded(invitation.getEncodedData());
            ObvDialog obvDialog = new ObvDialog(invitation.getDialogUuid(), encodedData, ownedIdentityBytes, new ObvDialog.Category(InvitationApi.getObvDialogCategoryId(invitation.getState()), null, null, null, null, null, null, null, null, null, null, null, null));
            obvDialog.setResponseToSasExchange(sasCode.getBytes());
            EngineWrapper.getInstance().respondToDialog(obvDialog);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: submitSas: exception", e);
            return false;
        }
    }

    public static boolean answerIntroduction(Invitation invitation, boolean accept, byte[] ownedIdentityBytes) {
        if (invitation == null) {
            AppLogger.e("InvitationApi: answerIntroduction: invalid parameter given: " + String.valueOf(invitation));
            return false;
        }
        if (invitation.getState() != InvitationGenerated.State.INTRODUCTION_WAIT_YOU_TO_ACCEPT) {
            AppLogger.e("InvitationApi: answerIntroduction: invalid invitation state: " + String.valueOf(invitation.getState()));
            return false;
        }
        try {
            Encoded encodedData = new Encoded(invitation.getEncodedData());
            ObvDialog obvDialog = new ObvDialog(invitation.getDialogUuid(), encodedData, ownedIdentityBytes, new ObvDialog.Category(InvitationApi.getObvDialogCategoryId(invitation.getState()), null, null, null, null, null, null, null, null, null, null, null, null));
            obvDialog.setResponseToAcceptMediatorInvite(accept);
            EngineWrapper.getInstance().respondToDialog(obvDialog);
            if (!accept) {
                EngineWrapper.getInstance().deletePersistedDialog(invitation.getDialogUuid());
            }
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: answerIntroduction: exception", e);
            return false;
        }
    }

    public static boolean answerGroupInvitation(Invitation invitation, boolean response) {
        if (invitation == null) {
            AppLogger.e("InvitationApi: answerGroupInvitation: invalid parameter given: " + String.valueOf(invitation));
            return false;
        }
        if (invitation.getState() != InvitationGenerated.State.GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT && invitation.getState() != InvitationGenerated.State.GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT) {
            AppLogger.e("InvitationApi: answerGroupInvitation: invalid invitation state: " + String.valueOf(invitation.getState()));
            return false;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(invitation.getOwnedIdentityId());
        try {
            Encoded extrasEncodedData = new Encoded(invitation.getEncodedData());
            ObvDialog obvDialog = new ObvDialog(invitation.getDialogUuid(), extrasEncodedData, ownedIdentity.getBytesOwnedIdentity(), new ObvDialog.Category(InvitationApi.getObvDialogCategoryId(invitation.getState()), null, null, null, null, null, null, null, null, null, null, null, null));
            obvDialog.setResponseToAcceptGroupInvite(response);
            if (invitation.getState() == InvitationGenerated.State.GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT && response) {
                invitation.setState(InvitationGenerated.State.GROUP_V2_INVITATION_ACCEPTED);
                DbManager.getInstance().getInvitationDao().update(invitation);
            }
            EngineWrapper.getInstance().respondToDialog(obvDialog);
            if (!response) {
                EngineWrapper.getInstance().deletePersistedDialog(invitation.getDialogUuid());
            }
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: answerGroupInvitation: exception", e);
            return false;
        }
    }

    public static boolean abortOneToOneInvitationSent(Invitation invitation, byte[] ownedIdentityBytes) {
        if (invitation == null) {
            AppLogger.e("InvitationApi: answerIntroduction: invalid parameter given: " + String.valueOf(invitation));
            return false;
        }
        if (invitation.getState() != InvitationGenerated.State.ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT) {
            AppLogger.e("InvitationApi: abortOneToOneInvitationSent: invalid invitation state: " + String.valueOf(invitation.getState()));
            return false;
        }
        try {
            Encoded encodedData = new Encoded(invitation.getEncodedData());
            ObvDialog obvDialog = new ObvDialog(invitation.getDialogUuid(), encodedData, ownedIdentityBytes, new ObvDialog.Category(InvitationApi.getObvDialogCategoryId(invitation.getState()), null, null, null, null, null, null, null, null, null, null, null, null));
            obvDialog.setAbortOneToOneInvitationSent(true);
            EngineWrapper.getInstance().respondToDialog(obvDialog);
            EngineWrapper.getInstance().deletePersistedDialog(invitation.getDialogUuid());
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: abortOneToOneInvitationSent: exception", e);
            return false;
        }
    }

    public static boolean answerOneToOneInvitation(Invitation invitation, boolean accept, byte[] bytesOwnedIdentity) {
        if (invitation == null) {
            AppLogger.e("InvitationApi: answerIntroduction: invalid parameter given: " + String.valueOf(invitation));
            return false;
        }
        if (invitation.getState() != InvitationGenerated.State.ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT) {
            AppLogger.e("InvitationApi: answerOneToOneInvitation: invalid invitation state: " + String.valueOf(invitation.getState()));
            return false;
        }
        try {
            Encoded encodedData = new Encoded(invitation.getEncodedData());
            ObvDialog obvDialog = new ObvDialog(invitation.getDialogUuid(), encodedData, bytesOwnedIdentity, new ObvDialog.Category(InvitationApi.getObvDialogCategoryId(invitation.getState()), null, null, null, null, null, null, null, null, null, null, null, null));
            obvDialog.setResponseToAcceptOneToOneInvitation(accept);
            EngineWrapper.getInstance().respondToDialog(obvDialog);
            if (!accept) {
                EngineWrapper.getInstance().deletePersistedDialog(invitation.getDialogUuid());
            }
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: answerIntroduction: exception", e);
            return false;
        }
    }

    public static void abortProtocol(Invitation invitation, byte[] bytesOwnedIdentity) {
        Encoded extrasEncodedData = new Encoded(invitation.getEncodedData());
        ObvDialog obvDialog = new ObvDialog(invitation.getDialogUuid(), extrasEncodedData, bytesOwnedIdentity, new ObvDialog.Category(InvitationApi.getObvDialogCategoryId(invitation.getState()), null, null, null, null, null, null, null, null, null, null, null, null));
        EngineWrapper.getInstance().abortProtocol(obvDialog);
        if (invitation.getDiscussion().isPreDiscussion()) {
            EngineWrapper.getInstance().deletePersistedDialog(invitation.getDialogUuid());
        }
    }

    public static boolean contactIntroduction(ContactInfo contactA, Collection<ContactInfo> contactList) {
        if (contactA == null || contactList == null || contactList.isEmpty()) {
            AppLogger.e("InvitationApi: answerGroupInvitation: invalid parameter given");
            return false;
        }
        byte[][] bytesContactBIdentities = new byte[contactList.size()][];
        int i = 0;
        for (ContactInfo contact : contactList) {
            bytesContactBIdentities[i] = contact.bytesContactIdentity();
            ++i;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(contactA.ownedIdentityId());
        try {
            EngineWrapper.getInstance().startContactMutualIntroductionProtocol(ownedIdentity.getBytesOwnedIdentity(), contactA.bytesContactIdentity(), bytesContactBIdentities);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("InvitationApi: answerGroupInvitation: engine exception", e);
            return false;
        }
    }

    private static int getObvDialogCategoryId(InvitationGenerated.State invitationState) {
        switch (invitationState) {
            case INVITATION_WAIT_IT_TO_ACCEPT: {
                return 0;
            }
            case INVITATION_WAIT_YOU_TO_ACCEPT: {
                return 1;
            }
            case INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE: {
                return 2;
            }
            case INVITATION_WAIT_IT_FOR_SAS_EXCHANGE: {
                return 3;
            }
            case INVITATION_STATUS_IN_PROGRESS: {
                return 5;
            }
            case INTRODUCTION_WAIT_YOU_TO_ACCEPT: {
                return 6;
            }
            case INTRODUCTION_WAIT_IT_TO_ACCEPT: {
                return 7;
            }
            case GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT: {
                return 8;
            }
            case ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT: {
                return 13;
            }
            case ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT: {
                return 14;
            }
            case GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT: 
            case GROUP_V2_INVITATION_ACCEPTED: {
                return 15;
            }
            case GROUP_V2_INVITATION_FROZEN: {
                return 16;
            }
        }
        AppLogger.e("InvitationApi: getObvDialogCategoryId: received unhandled invitation type: " + String.valueOf(invitationState));
        return -1;
    }
}

