/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.groups.tasks;

import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.ObvOutboundAttachment;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonSharedSettings;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionCreationHelper;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageInsertionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.engine.helpers.message.UnknownRecipientObvMessagesHelper;
import io.olvid.windows.messenger.engine.helpers.message.tasks.PostPendingMessageTask;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.Watches;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GroupV2UpsertNotificationHandler
implements Runnable {
    private final ObvGroupV2 obvGroupV2;
    private final boolean groupWasJustCreatedByMe;
    private final boolean updatedByMe;
    private final boolean synchronizeUpdateInProgressWithEngine;
    final List<Runnable> postTransactionActions = new ArrayList<Runnable>(3);
    private final boolean isAnInvitationUpdate;

    public GroupV2UpsertNotificationHandler(ObvGroupV2 obvGroupV2, boolean groupWasJustCreatedByMe, boolean updatedByMe, boolean synchronizeUpdateInProgressWithEngine, boolean isAnInvitationUpdate) {
        this.obvGroupV2 = obvGroupV2;
        this.groupWasJustCreatedByMe = groupWasJustCreatedByMe;
        this.updatedByMe = updatedByMe;
        this.synchronizeUpdateInProgressWithEngine = synchronizeUpdateInProgressWithEngine;
        this.isAnInvitationUpdate = isAnInvitationUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Watches.Watch watch = Watches.getInstance().start("GroupV2UpsertNotificationHandler");
        DbManager db = DbManager.getInstance();
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                JsonSharedSettings jsonSharedSettings;
                DiscussionCustomization discussionCustomization;
                JsonIdentityDetails jsonIdentityDetails;
                BytesKey key;
                ContactRef contactRef;
                Discussion discussion;
                boolean groupWasJoinedOrRejoined = false;
                boolean hasUntrustedDetails = false;
                boolean groupHasMembersWithChannels = false;
                boolean listOfUsersWithChangeSettingsPermissionChanged = false;
                ArrayList<byte[]> bytesIdentitiesOfUsersWithChangeSettingsPermission = new ArrayList<byte[]>();
                byte[] bytesGroupIdentifier = this.obvGroupV2.groupIdentifier.getBytes();
                String groupName = null;
                String groupDescription = null;
                JsonGroupDetails trustedGroupDetails = null;
                try {
                    trustedGroupDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(this.obvGroupV2.detailsAndPhotos.serializedGroupDetails, JsonGroupDetails.class);
                    groupName = trustedGroupDetails.getName();
                    groupDescription = trustedGroupDetails.getDescription();
                    if (this.obvGroupV2.detailsAndPhotos.serializedPublishedDetails != null) {
                        if (this.updatedByMe || GroupHelper.detailsCanBeAutoTrusted(this.obvGroupV2.detailsAndPhotos)) {
                            this.postTransactionActions.add(() -> {
                                try {
                                    EngineWrapper.getInstance().trustGroupV2PublishedDetails(this.obvGroupV2.bytesOwnedIdentity, this.obvGroupV2.groupIdentifier.getBytes());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            });
                        } else {
                            hasUntrustedDetails = GroupHelper.userShouldBeNotifiedOfNewPublishedDetails(this.obvGroupV2.detailsAndPhotos);
                        }
                    }
                }
                catch (Exception e) {
                    AppLogger.e("Error deserializing group details --> ignoring them", e);
                }
                boolean insertDetailsUpdatedMessage = false;
                boolean insertGainedAdminMessage = false;
                boolean insertLostAdminMessage = false;
                PreGroup preGroup = db.getPreGroupDao().get(this.obvGroupV2.bytesOwnedIdentity, bytesGroupIdentifier);
                OwnedIdentity associatedOwnedIdentity = db.getOwnedIdentityDao().get(this.obvGroupV2.bytesOwnedIdentity);
                Group group = db.getGroupDao().get(associatedOwnedIdentity, bytesGroupIdentifier);
                if (preGroup != null && !this.isAnInvitationUpdate) {
                    group = Group.makeGroupV2(associatedOwnedIdentity, bytesGroupIdentifier, trustedGroupDetails != null ? groupName : null, trustedGroupDetails != null ? trustedGroupDetails.getDescription() : null, this.obvGroupV2.groupIdentifier.category == 1, hasUntrustedDetails ? GroupGenerated.PublishedDetails.NEW_UNSEEN : GroupGenerated.PublishedDetails.NOTHING_NEW, this.obvGroupV2.detailsAndPhotos.getNullIfEmptyPhotoUrl());
                    group = DbManager.getInstance().getGroupDao().createIfNotExists(group);
                    if (group == null) {
                        throw new SQLException("Cannot insert group");
                    }
                    ownPermissions = db.getGroupMemberPermissionsDao().getOwnPermission(preGroup);
                    if (ownPermissions == null) {
                        throw new SQLException("Cannot find own permissions associated with pre group");
                    }
                    ownPermissions.setGroupOrPreGroup(Either.left(group));
                    if (DbManager.getInstance().getGroupMemberPermissionsDao().update(ownPermissions) != 1) {
                        throw new SQLException("Cannot update group member own permissions");
                    }
                    if (!ownPermissions.getPermissions().equals(this.obvGroupV2.ownPermissions)) {
                        if (ownPermissions.hasPermissionAdmin() && !this.obvGroupV2.ownPermissions.contains(GroupV2.Permission.GROUP_ADMIN)) {
                            insertLostAdminMessage = true;
                        } else if (!ownPermissions.hasPermissionAdmin() && this.obvGroupV2.ownPermissions.contains(GroupV2.Permission.GROUP_ADMIN)) {
                            insertGainedAdminMessage = true;
                        }
                        ownPermissions.updatePermissions(this.obvGroupV2.ownPermissions);
                    }
                    if (db.getGroupMemberPermissionsDao().update(ownPermissions) != 1) {
                        throw new SQLException("Cannot update associated group permission");
                    }
                    DbManager.getInstance().getPendingGroupMemberDao().upgradeFromPreGroupToGroup(preGroup, group);
                    if (db.getPreGroupDao().delete(preGroup) != 1) {
                        throw new SQLException("Cannot delete pre group");
                    }
                } else {
                    if (preGroup == null && this.isAnInvitationUpdate) {
                        AppLogger.e("The pre group should have been created in the createGroupInvitation method of InvitationNotificationListener but it doesn't appear in app db");
                        return null;
                    }
                    if (preGroup != null) {
                        AppLogger.i("GroupV2UpsertNotificationHandler Updating group with uuid : " + String.valueOf(this.obvGroupV2.groupIdentifier.groupUid));
                    } else if (group == null) {
                        group = Group.makeGroupV2(associatedOwnedIdentity, bytesGroupIdentifier, trustedGroupDetails != null ? trustedGroupDetails.getName() : null, trustedGroupDetails != null ? trustedGroupDetails.getDescription() : null, this.obvGroupV2.groupIdentifier.category == 1, hasUntrustedDetails ? GroupGenerated.PublishedDetails.NEW_UNSEEN : GroupGenerated.PublishedDetails.NOTHING_NEW, this.obvGroupV2.detailsAndPhotos.getNullIfEmptyPhotoUrl());
                        group = DbManager.getInstance().getGroupDao().createIfNotExists(group);
                        if (group == null) {
                            throw new SQLException("Cannot insert group");
                        }
                        ownPermissions = new GroupMemberPermissions(associatedOwnedIdentity, group, null, null, null, GroupHelper.getStringsFromObvPermissions(this.obvGroupV2.ownPermissions));
                        ownPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().createIfNotExists(ownPermissions);
                        if (ownPermissions == null) {
                            throw new SQLException("Cannot insert group");
                        }
                        if (!this.groupWasJustCreatedByMe && this.obvGroupV2.ownPermissions.contains(GroupV2.Permission.GROUP_ADMIN)) {
                            insertGainedAdminMessage = true;
                        }
                    } else {
                        GroupMemberPermissions groupMemberPermissions;
                        group.setName(Optional.ofNullable(groupName));
                        group.setDescription(Optional.ofNullable(groupDescription));
                        group.setPhotoUrl(Optional.ofNullable(this.obvGroupV2.detailsAndPhotos.getNullIfEmptyPhotoUrl()));
                        if (group.getNewPublishedDetails() == GroupGenerated.PublishedDetails.NOTHING_NEW == hasUntrustedDetails) {
                            group.setNewPublishedDetails(hasUntrustedDetails ? GroupGenerated.PublishedDetails.NEW_UNSEEN : GroupGenerated.PublishedDetails.NOTHING_NEW);
                            insertDetailsUpdatedMessage = hasUntrustedDetails;
                        }
                        if ((groupMemberPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().getOwnPermission((Id<Group>)group.getItemId())) == null) {
                            throw new SQLException("Cannot find associated group permission");
                        }
                        if (!groupMemberPermissions.getPermissions().equals(this.obvGroupV2.ownPermissions)) {
                            if (groupMemberPermissions.hasPermissionAdmin() && !this.obvGroupV2.ownPermissions.contains(GroupV2.Permission.GROUP_ADMIN)) {
                                insertLostAdminMessage = true;
                            } else if (!groupMemberPermissions.hasPermissionAdmin() && this.obvGroupV2.ownPermissions.contains(GroupV2.Permission.GROUP_ADMIN)) {
                                insertGainedAdminMessage = true;
                            }
                            groupMemberPermissions.updatePermissions(this.obvGroupV2.ownPermissions);
                            if (db.getGroupMemberPermissionsDao().update(groupMemberPermissions) != 1) {
                                throw new SQLException("Cannot update associated group permission");
                            }
                        }
                        db.getGroupDao().update(group);
                    }
                }
                Discussion discussion2 = discussion = this.isAnInvitationUpdate ? db.getDiscussionDao().get(preGroup) : db.getDiscussionDao().get(group);
                if (discussion == null || discussion.isLocked() || discussion.isPreDiscussion()) {
                    discussion = this.isAnInvitationUpdate ? DiscussionCreationHelper.createOrReusePreGroupDiscussionDbTask(preGroup) : DiscussionCreationHelper.createOrReuseGroupDiscussionDbTask(group);
                    groupWasJoinedOrRejoined = true;
                    Optional<Long> messageCount = MessageHelper.countUserMessagesInDiscussion(discussion);
                    if (messageCount.isPresent() && messageCount.get() > 0L) {
                        MessageInsertionHelper.insertGroupReJoinedMessage(discussion);
                    }
                }
                if (insertDetailsUpdatedMessage) {
                    SystemMessage newDetailsMessage = MessageBuilder.createNewPublishedDetailsMessage(discussion, Optional.empty());
                    db.getSystemMessageDao().insert(newDetailsMessage);
                    db.getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, newDetailsMessage, false);
                } else if (this.obvGroupV2.detailsAndPhotos.serializedPublishedDetails == null) {
                    db.getSystemMessageDao().deleteAllDiscussionNewPublishedDetailsMessages(discussion);
                }
                SystemMessage adminMessage = null;
                if (insertGainedAdminMessage) {
                    adminMessage = MessageBuilder.createGainedGroupAdminMessage(discussion);
                } else if (insertLostAdminMessage) {
                    adminMessage = MessageBuilder.createLostGroupAdminMessage(discussion);
                }
                if (adminMessage != null) {
                    db.getSystemMessageDao().insert(adminMessage);
                    db.getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, adminMessage, false);
                }
                if (this.synchronizeUpdateInProgressWithEngine && !this.isAnInvitationUpdate) {
                    boolean updateInProgress = EngineWrapper.getInstance().isGroupV2UpdateInProgress(this.obvGroupV2.bytesOwnedIdentity, this.obvGroupV2.groupIdentifier);
                    if (group.getUpdateInProgress() == GroupGenerated.Update.NONE == updateInProgress) {
                        group.setUpdateInProgress(updateInProgress ? GroupGenerated.Update.SYNCING : GroupGenerated.Update.NONE);
                        db.getGroupDao().updateUpdateInProgress(group.getOwnedIdentityId(), group.getBytesGroupIdentifier(), group.getUpdateInProgress());
                    }
                }
                HashMap<BytesKey, GroupMemberPermissions> initialMembersPermissions = new HashMap<BytesKey, GroupMemberPermissions>();
                HashMap<BytesKey, HashSet> membersToAdd = new HashMap<BytesKey, HashSet>();
                HashMap<BytesKey, PendingGroupMember> initialPendingMembers = new HashMap<BytesKey, PendingGroupMember>();
                HashMap<BytesKey, ObvGroupV2.ObvGroupV2PendingMember> pendingToAdd = new HashMap<BytesKey, ObvGroupV2.ObvGroupV2PendingMember>();
                HashMap<BytesKey, GroupMemberPermissions> pendingMembersPermissions = new HashMap<BytesKey, GroupMemberPermissions>();
                boolean membersWereAdded = false;
                if (!this.isAnInvitationUpdate) {
                    for (GroupMemberPermissions groupMemberPermissions : db.getGroupMemberPermissionsDao().getMemberPermissionsFromGroup(group)) {
                        Optional<Id<ContactGroupJoin>> contactGroupJoinIdOpt = groupMemberPermissions.getContactGroupJoinId();
                        if (contactGroupJoinIdOpt.isEmpty()) {
                            AppLogger.e("Unexpected: found a GroupMemberPermissions without ContactGroupJoin");
                            continue;
                        }
                        ContactGroupJoin contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().get(contactGroupJoinIdOpt.get());
                        Contact contact = DbManager.getInstance().getContactDao().get(contactGroupJoin.getContactId());
                        initialMembersPermissions.put(new BytesKey(contact.getBytesContactIdentity()), groupMemberPermissions);
                    }
                    for (GroupMemberPermissions groupMemberPermissions : db.getGroupMemberPermissionsDao().getAllPendingMembersPermissions(group)) {
                        Optional<Id<PendingGroupMember>> pendingGroupMemberIdOpt = groupMemberPermissions.getPendingGroupMemberId();
                        if (pendingGroupMemberIdOpt.isEmpty()) {
                            AppLogger.e("Unexpected: found a GroupMemberPermissions without ContactGroupJoin");
                            continue;
                        }
                        PendingGroupMember pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().get(pendingGroupMemberIdOpt.get());
                        ContactRef contactRef2 = DbManager.getInstance().getContactRefDao().get(pendingGroupMember.getContactRefId());
                        pendingMembersPermissions.put(new BytesKey(contactRef2.getBytesContactIdentity()), groupMemberPermissions);
                    }
                }
                if (this.isAnInvitationUpdate) {
                    groupMemberPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().getAllPendingMembersPermissions(preGroup);
                    Iterator<GroupMemberPermissions> iterator = groupMemberPermissions.iterator();
                    while (iterator.hasNext()) {
                        permission = iterator.next();
                        pendingGroupMemberIdOpt = permission.getPendingGroupMemberId();
                        if (pendingGroupMemberIdOpt.isEmpty()) {
                            AppLogger.e("Unexpected: found a GroupMemberPermissions without pending group member");
                            continue;
                        }
                        pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().get(pendingGroupMemberIdOpt.get());
                        contactRef = DbManager.getInstance().getContactRefDao().get(pendingGroupMember.getContactRefId());
                        pendingMembersPermissions.put(BytesKey.of(contactRef.getBytesContactIdentity()), permission);
                        initialPendingMembers.put(new BytesKey(contactRef.getBytesContactIdentity()), pendingGroupMember);
                    }
                } else {
                    groupMemberPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().getAllPendingMembersPermissions(group);
                    Iterator<GroupMemberPermissions> iterator = groupMemberPermissions.iterator();
                    while (iterator.hasNext()) {
                        permission = iterator.next();
                        pendingGroupMemberIdOpt = permission.getPendingGroupMemberId();
                        if (pendingGroupMemberIdOpt.isEmpty()) {
                            AppLogger.e("Unexpected: found a GroupMemberPermissions without pending group member");
                            continue;
                        }
                        pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().get(pendingGroupMemberIdOpt.get());
                        contactRef = DbManager.getInstance().getContactRefDao().get(pendingGroupMember.getContactRefId());
                        BytesKey bytesKey = BytesKey.of(contactRef.getBytesContactIdentity());
                        pendingMembersPermissions.put(bytesKey, permission);
                        initialPendingMembers.put(bytesKey, pendingGroupMember);
                    }
                }
                for (ObvGroupV2.ObvGroupV2Member obvGroupV2Member : this.obvGroupV2.otherGroupMembers) {
                    GroupMemberPermissions memberPermissions;
                    Contact contact;
                    if (this.groupWasJustCreatedByMe && !groupHasMembersWithChannels && (contact = db.getContactDao().get((Id<OwnedIdentity>)associatedOwnedIdentity.getItemId(), obvGroupV2Member.bytesIdentity)) != null && contact.getEstablishedChannelCount() > 0) {
                        groupHasMembersWithChannels = true;
                    }
                    if (obvGroupV2Member.permissions.contains(GroupV2.Permission.CHANGE_SETTINGS)) {
                        bytesIdentitiesOfUsersWithChangeSettingsPermission.add(obvGroupV2Member.bytesIdentity);
                    }
                    if ((memberPermissions = (GroupMemberPermissions)initialMembersPermissions.remove(key = new BytesKey(obvGroupV2Member.bytesIdentity))) == null) {
                        membersToAdd.put(key, obvGroupV2Member.permissions);
                        continue;
                    }
                    listOfUsersWithChangeSettingsPermissionChanged = memberPermissions.hasPermissionChangeSettings();
                    if (!memberPermissions.updatePermissionsIfNeeded(obvGroupV2Member.permissions)) continue;
                    DbManager.getInstance().getGroupMemberPermissionsDao().update(memberPermissions);
                    listOfUsersWithChangeSettingsPermissionChanged = listOfUsersWithChangeSettingsPermissionChanged != memberPermissions.hasPermissionChangeSettings();
                }
                for (ObvGroupV2.ObvGroupV2PendingMember obvGroupV2PendingMember : this.obvGroupV2.pendingGroupMembers) {
                    key = new BytesKey(obvGroupV2PendingMember.bytesIdentity);
                    PendingGroupMember existingPending = (PendingGroupMember)initialPendingMembers.remove(key);
                    if (existingPending == null) {
                        pendingToAdd.put(key, obvGroupV2PendingMember);
                        continue;
                    }
                    GroupMemberPermissions groupMemberPermissions = (GroupMemberPermissions)pendingMembersPermissions.get(BytesKey.of(obvGroupV2PendingMember.bytesIdentity));
                    if (groupMemberPermissions == null) {
                        AppLogger.w("GroupV2UpsertNotificationHandler::run Can't find permissions for pending member: " + String.valueOf(existingPending.getItemId()));
                        continue;
                    }
                    listOfUsersWithChangeSettingsPermissionChanged = groupMemberPermissions.hasPermissionChangeSettings();
                    boolean changed = groupMemberPermissions.updatePermissionsIfNeeded(obvGroupV2PendingMember.permissions);
                    ContactRef contactRef3 = DbManager.getInstance().getContactRefDao().get(existingPending.getContactRefId());
                    if (contactRef3.getContactId().isEmpty()) {
                        jsonIdentityDetails = (JsonIdentityDetails)EngineWrapper.getJsonObjectMapper().readValue(obvGroupV2PendingMember.serializedDetails, JsonIdentityDetails.class);
                        Id<IdentityDetails> identityDetailsId = existingPending.getIdentityDetailsId();
                        IdentityDetails identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(identityDetailsId);
                        if (!identityDetails.equalsTo(jsonIdentityDetails)) {
                            changed = DbManager.getInstance().getIdentityDetailsDao().updateDetails(identityDetailsId, jsonIdentityDetails);
                        }
                    }
                    if (!changed) continue;
                    listOfUsersWithChangeSettingsPermissionChanged = listOfUsersWithChangeSettingsPermissionChanged != groupMemberPermissions.hasPermissionChangeSettings();
                    DbManager.getInstance().getGroupMemberPermissionsDao().update(groupMemberPermissions);
                    db.getPendingGroupMemberDao().update(existingPending);
                }
                for (Map.Entry entry : initialMembersPermissions.entrySet()) {
                    key = (BytesKey)entry.getKey();
                    GroupMemberPermissions groupPermission = (GroupMemberPermissions)entry.getValue();
                    db.getGroupMemberPermissionsDao().delete(groupPermission);
                    Optional<Object> contactGroupJoin = Optional.empty();
                    if (groupPermission.getContactGroupJoinId().isPresent()) {
                        Id<ContactGroupJoin> contactGroupJoinId = groupPermission.getContactGroupJoinId().get();
                        contactGroupJoin = Optional.ofNullable(DbManager.getInstance().getContactGroupJoinDao().get(contactGroupJoinId));
                        db.getContactGroupJoinDao().deleteById(groupPermission.getContactGroupJoinId().get());
                    }
                    if (pendingToAdd.containsKey(key)) continue;
                    if (groupPermission.hasPermissionChangeSettings()) {
                        listOfUsersWithChangeSettingsPermissionChanged = true;
                    }
                    if (!contactGroupJoin.isPresent()) continue;
                    List<MessageRecipientInfo> messageRecipientInfoList = db.getMessageRecipientInfoDao().getUnsentForContactInDiscussion(discussion, ((ContactGroupJoin)contactGroupJoin.get()).getContactId());
                    for (MessageRecipientInfo messageRecipientInfo : messageRecipientInfoList) {
                        OutboundMessage associatedMessage = DbManager.getInstance().getOutboundMessageDao().get(messageRecipientInfo.getMessageId());
                        db.getMessageRecipientInfoDao().delete(messageRecipientInfo);
                        Api.getMessageApi().refreshOutboundStatus((Id<OutboundMessage>)associatedMessage.getItemId());
                    }
                }
                for (Map.Entry entry : membersToAdd.entrySet()) {
                    key = (BytesKey)entry.getKey();
                    HashSet permissions = (HashSet)entry.getValue();
                    Contact contact = db.getContactDao().get(this.obvGroupV2.bytesOwnedIdentity, key.bytes);
                    if (contact == null) {
                        AppLogger.w("Failed to add group2 member: contact does not exist");
                        continue;
                    }
                    ContactGroupJoin contactGroupJoin = db.getContactGroupJoinDao().get(group, contact);
                    if (contactGroupJoin != null) {
                        AppLogger.e(String.format("GroupV2UpsertNotificationHandler::run found  contactgroupjoin for contact %s and group %s", contact.getItemId(), group.getItemId()));
                    } else {
                        contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().createIfNotExists(new ContactGroupJoin(contact, associatedOwnedIdentity, group));
                        if (contactGroupJoin == null) {
                            AppLogger.e(String.format("GroupV2UpsertNotificationHandler::run couldn't insert contactgroupjoin for contact %s and group %s", contact.getItemId(), group.getItemId()));
                            throw new SQLException("couldn't insert contactgroupjoin");
                        }
                    }
                    GroupMemberPermissions group2Member = new GroupMemberPermissions(associatedOwnedIdentity, null, null, contactGroupJoin, null, GroupHelper.getStringsFromObvPermissions(permissions));
                    db.getGroupMemberPermissionsDao().insert(group2Member);
                    if (!initialPendingMembers.containsKey(key)) {
                        if (group2Member.hasPermissionChangeSettings()) {
                            listOfUsersWithChangeSettingsPermissionChanged = true;
                        }
                        membersWereAdded = true;
                    }
                    if (!contact.hasChannelOrPrekey()) continue;
                    List<PendingMessage> pendingMessages = db.getPendingMessageDao().getAllByDiscussionAndContact(discussion, contact.getBytesContactIdentity());
                    Object discussionId = discussion.getItemId();
                    Discussion finalDiscussion = discussion;
                    this.postTransactionActions.add(() -> this.lambda$run$1(db, (Id)discussionId, finalDiscussion, pendingMessages));
                }
                for (Map.Entry entry : initialPendingMembers.entrySet()) {
                    key = (BytesKey)entry.getKey();
                    PendingGroupMember group2PendingMember = (PendingGroupMember)entry.getValue();
                    GroupMemberPermissions groupMemberPermissions = (GroupMemberPermissions)pendingMembersPermissions.get(entry.getKey());
                    db.getPendingGroupMemberDao().delete(group2PendingMember);
                    if (membersToAdd.containsKey(key)) continue;
                    if (groupMemberPermissions.hasPermissionChangeSettings()) {
                        listOfUsersWithChangeSettingsPermissionChanged = true;
                    }
                    if (!(contactRef = DbManager.getInstance().getContactRefDao().get(group2PendingMember.getContactRefId())).getContactId().isPresent()) continue;
                    List<MessageRecipientInfo> messageRecipientInfoList = db.getMessageRecipientInfoDao().getUnsentForContactInDiscussion(discussion, contactRef.getContactId().get());
                    for (MessageRecipientInfo messageRecipientInfo : messageRecipientInfoList) {
                        db.getMessageRecipientInfoDao().delete(messageRecipientInfo);
                        OutboundMessage associatedMessage = DbManager.getInstance().getOutboundMessageDao().get(messageRecipientInfo.getMessageId());
                        Api.getMessageApi().refreshOutboundStatus((Id<OutboundMessage>)associatedMessage.getItemId());
                    }
                }
                for (Map.Entry entry : pendingToAdd.entrySet()) {
                    PendingGroupMember pendingGroupMember;
                    key = (BytesKey)entry.getKey();
                    ObvGroupV2.ObvGroupV2PendingMember obvGroupV2PendingMember = (ObvGroupV2.ObvGroupV2PendingMember)entry.getValue();
                    contactRef = db.getContactRefDao().getOrCreateContactRef(associatedOwnedIdentity, obvGroupV2PendingMember.bytesIdentity);
                    jsonIdentityDetails = (JsonIdentityDetails)EngineWrapper.getJsonObjectMapper().readValue(obvGroupV2PendingMember.serializedDetails, JsonIdentityDetails.class);
                    if (contactRef.getContactId().isEmpty()) {
                        IdentityDetails identityDetails = new IdentityDetails(jsonIdentityDetails);
                        identityDetails = db.getIdentityDetailsDao().createIfNotExists(identityDetails);
                        if (identityDetails == null) throw new SQLException("GroupV2UpsertNotificationHandler::run Couldn't create identity details");
                        pendingGroupMember = this.isAnInvitationUpdate ? new PendingGroupMember(preGroup, contactRef, identityDetails, identityDetails.computeSortDisplayName(Optional.empty())) : new PendingGroupMember(group, contactRef, identityDetails, identityDetails.computeSortDisplayName(Optional.empty()), false);
                    } else {
                        Contact contact = DbManager.getInstance().getContactDao().get(contactRef.getContactId().get());
                        IdentityDetails identityDetailsProxy = new IdentityDetails(contact.getIdentityDetailsId().getId());
                        pendingGroupMember = this.isAnInvitationUpdate ? new PendingGroupMember(preGroup, contactRef, identityDetailsProxy, contact.getSortDisplayName()) : new PendingGroupMember(group, contactRef, identityDetailsProxy, contact.getSortDisplayName(), false);
                    }
                    GroupMemberPermissions groupMemberPermissions = new GroupMemberPermissions(associatedOwnedIdentity, null, null, null, pendingGroupMember, GroupHelper.getStringsFromObvPermissions(obvGroupV2PendingMember.permissions));
                    db.getPendingGroupMemberDao().insert(pendingGroupMember);
                    db.getGroupMemberPermissionsDao().insert(groupMemberPermissions);
                    if (initialMembersPermissions.containsKey(key)) continue;
                    if (groupMemberPermissions.hasPermissionChangeSettings()) {
                        listOfUsersWithChangeSettingsPermissionChanged = true;
                    }
                    membersWereAdded = true;
                }
                if (membersWereAdded) {
                    this.postTransactionActions.add(() -> UnknownRecipientObvMessagesHelper.processAllGroupV2MessagesOnHold(associatedOwnedIdentity.getBytesOwnedIdentity(), bytesGroupIdentifier));
                }
                HashSet membersEffectivelyAdded = new HashSet();
                membersEffectivelyAdded.addAll(membersToAdd.keySet());
                membersEffectivelyAdded.addAll(pendingToAdd.keySet());
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.addAll(initialMembersPermissions.keySet());
                hashSet.addAll(initialPendingMembers.keySet());
                HashSet<BytesKey> intersection = new HashSet<BytesKey>();
                for (BytesKey key2 : membersEffectivelyAdded) {
                    if (!hashSet.contains(key2)) continue;
                    intersection.add(key2);
                }
                membersEffectivelyAdded.removeAll(intersection);
                hashSet.removeIf(intersection::contains);
                SystemMessage messageInserted = null;
                if (!groupWasJoinedOrRejoined && !membersEffectivelyAdded.isEmpty()) {
                    SystemMessage groupJoinedMessage = MessageBuilder.createGroupMembersJoinedMessage(discussion);
                    db.getSystemMessageDao().insert(groupJoinedMessage);
                    messageInserted = groupJoinedMessage;
                }
                if (!groupWasJoinedOrRejoined && !hashSet.isEmpty()) {
                    SystemMessage groupLeftMessage = MessageBuilder.createGroupMembersLeftMessage(discussion);
                    db.getSystemMessageDao().insert(groupLeftMessage);
                    messageInserted = groupLeftMessage;
                }
                if (messageInserted != null) {
                    db.getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, messageInserted, false);
                }
                if (this.groupWasJustCreatedByMe && groupHasMembersWithChannels && (discussionCustomization = db.getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId())) != null && (jsonSharedSettings = discussionCustomization.getSharedSettingsJson()) != null) {
                    long timestamp = System.currentTimeMillis();
                    IdentityRef ownedIdentityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef((Id<OwnedIdentity>)associatedOwnedIdentity.getItemId());
                    MessageInsertionHelper.insertDiscussionSettingsUpdateMessageDbTask(discussion, jsonSharedSettings.getJsonExpiration(), ownedIdentityRef, timestamp, MessageBuilder.MessageSystemPosition.MESSAGE_TIMESTAMP);
                }
                if (!this.updatedByMe && listOfUsersWithChangeSettingsPermissionChanged && !bytesIdentitiesOfUsersWithChangeSettingsPermission.isEmpty()) {
                    JsonExpiration jsonExpiration;
                    Integer jsonSharedSettingsVersion;
                    DiscussionCustomization discussionCustomization2 = db.getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId());
                    if (discussionCustomization2 != null) {
                        jsonSharedSettingsVersion = discussionCustomization2.getSharedSettingsVersion();
                        jsonExpiration = discussionCustomization2.getExpirationJson();
                    } else {
                        jsonSharedSettingsVersion = null;
                        jsonExpiration = null;
                    }
                    Discussion finalDiscussion = discussion;
                    this.postTransactionActions.add(() -> {
                        try {
                            EngineWrapper.getInstance().post(MessagePostHelper.buildJsonQuerySharedSettingsPayloadAsBytes(finalDiscussion, jsonSharedSettingsVersion, jsonExpiration), new ObvOutboundAttachment[0], bytesIdentitiesOfUsersWithChangeSettingsPermission, this.obvGroupV2.bytesOwnedIdentity, false, false);
                        }
                        catch (Exception e) {
                            AppLogger.e("GroupV2UpsertNotificationHandler::postTransactionActions engine post call failed....", e);
                        }
                    });
                }
                if (this.isAnInvitationUpdate) {
                    preGroup.setPreGroupMembersNames(Optional.of(GroupHelper.getGroupMembersNames(preGroup)));
                    db.getPreGroupDao().update(preGroup);
                    return null;
                }
                group.setGroupMembersNames(Optional.of(GroupHelper.getGroupMembersNames(group)));
                db.getGroupDao().update(group);
                return null;
            });
            for (Runnable runnable : this.postTransactionActions) {
                AsyncTaskExecutor.submitTask(runnable);
            }
        }
        catch (SQLException e) {
            AppLogger.e("GroupV2UpsertNotificationHandler::Transaction failed....", e);
        }
        finally {
            watch.stop();
        }
    }

    private /* synthetic */ void lambda$run$1(DbManager db, Id discussionId, Discussion finalDiscussion, List pendingMessages) {
        JsonSharedSettings sharedSettings;
        DiscussionCustomization discussionCustomization;
        if (this.obvGroupV2.ownPermissions.contains(GroupV2.Permission.CHANGE_SETTINGS) && (discussionCustomization = db.getDiscussionCustomizationDao().getDiscussionCustomization(discussionId)) != null && (sharedSettings = discussionCustomization.getSharedSettingsJson()) != null) {
            MessagePostHelper.postDiscussionSettingsUpdatedMessageDbTask(finalDiscussion, sharedSettings);
        }
        for (PendingMessage pendingMessage : pendingMessages) {
            new PostPendingMessageTask(pendingMessage).run();
        }
    }
}

