/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.groups;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupType;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.ContactGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.atom.tasks.AtomTasks;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupCreationFlowModel;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupType;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.io.IOUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupHelper {
    public static boolean detailsCanBeAutoTrusted(ObvGroupV2.ObvGroupV2DetailsAndPhotos detailsAndPhotos) {
        if (detailsAndPhotos == null) {
            return false;
        }
        if (detailsAndPhotos.serializedPublishedDetails != null) {
            try {
                JsonGroupDetails publishedDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(detailsAndPhotos.serializedPublishedDetails, JsonGroupDetails.class);
                JsonGroupDetails trustedDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(detailsAndPhotos.serializedGroupDetails, JsonGroupDetails.class);
                if (Objects.equals(publishedDetails, trustedDetails)) {
                    if (detailsAndPhotos.photoUrl == null) {
                        return true;
                    }
                    if (!detailsAndPhotos.photoUrl.isEmpty()) {
                        if (Objects.equals(detailsAndPhotos.photoUrl, detailsAndPhotos.publishedPhotoUrl)) {
                            return true;
                        }
                        if (detailsAndPhotos.publishedPhotoUrl != null && !detailsAndPhotos.publishedPhotoUrl.isEmpty()) {
                            return IOUtils.areSameFiles(new SecureFile(FileApi.absolutePathFromRelative(detailsAndPhotos.photoUrl)), new SecureFile(FileApi.absolutePathFromRelative(detailsAndPhotos.publishedPhotoUrl)));
                        }
                    }
                }
            }
            catch (JsonProcessingException e) {
                AppLogger.e("GroupHelper::detailsCanBeAutoTrusted: Error processing json", (Exception)((Object)e));
            }
        }
        return true;
    }

    public static boolean userShouldBeNotifiedOfNewPublishedDetails(ObvGroupV2.ObvGroupV2DetailsAndPhotos detailsAndPhotos) {
        if (detailsAndPhotos == null) {
            return false;
        }
        if (detailsAndPhotos.serializedPublishedDetails != null) {
            try {
                JsonGroupDetails publishedDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(detailsAndPhotos.serializedPublishedDetails, JsonGroupDetails.class);
                JsonGroupDetails trustedDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(detailsAndPhotos.serializedGroupDetails, JsonGroupDetails.class);
                if (!Objects.equals(publishedDetails, trustedDetails)) {
                    return true;
                }
                if (detailsAndPhotos.photoUrl == null) {
                    return false;
                }
                if (detailsAndPhotos.publishedPhotoUrl == null) {
                    return !detailsAndPhotos.photoUrl.isEmpty();
                }
                if (detailsAndPhotos.publishedPhotoUrl.isEmpty()) {
                    return false;
                }
                if (detailsAndPhotos.photoUrl.isEmpty()) {
                    return true;
                }
                return IOUtils.areSameFiles(new SecureFile(FileApi.absolutePathFromRelative(detailsAndPhotos.photoUrl)), new SecureFile(FileApi.absolutePathFromRelative(detailsAndPhotos.publishedPhotoUrl)));
            }
            catch (JsonProcessingException e) {
                AppLogger.e("GroupHelper::userShouldBeNotifiedOfNewPublishedDetails: Error processing json", (Exception)((Object)e));
            }
        }
        return false;
    }

    public static Set<String> getDefaultAdminPermissionsAsString() {
        HashSet<String> permissionsAsString = new HashSet<String>(GroupV2.Permission.DEFAULT_ADMIN_PERMISSIONS.length);
        for (GroupV2.Permission permission : GroupV2.Permission.DEFAULT_ADMIN_PERMISSIONS) {
            permissionsAsString.add(permission.getString());
        }
        return permissionsAsString;
    }

    public static Map<BytesKey, Set<String>> buildDefaultPermissionsPerMemberBytesFromContacts(List<ContactInfo> contacts) {
        if (contacts == null) {
            AppLogger.e("GroupHelper::buildDefaultPermissionsPerMemberBytesFromContacts Contact List is null");
            return Collections.emptyMap();
        }
        HashMap<BytesKey, Set<String>> toRet = new HashMap<BytesKey, Set<String>>();
        for (ContactInfo contact : contacts) {
            toRet.put(BytesKey.of(contact.bytesContactIdentity()), GroupHelper.getDefaultMemberPermissionsAsString());
        }
        return toRet;
    }

    public static Set<String> getDefaultMemberPermissionsAsString() {
        HashSet<String> permissionsAsString = new HashSet<String>(GroupV2.Permission.DEFAULT_MEMBER_PERMISSIONS.length);
        for (GroupV2.Permission permission : GroupV2.Permission.DEFAULT_MEMBER_PERMISSIONS) {
            permissionsAsString.add(permission.getString());
        }
        return permissionsAsString;
    }

    public static GroupMemberPermissions getV1OwnGroupPermissions(OwnedIdentity ownedIdentity, Group group, boolean amIAdmin) {
        if (group == null) {
            return null;
        }
        HashSet<GroupV2.Permission> permissions = new HashSet<GroupV2.Permission>(amIAdmin ? Arrays.asList(GroupV2.Permission.DEFAULT_ADMIN_PERMISSIONS) : Arrays.asList(GroupV2.Permission.DEFAULT_MEMBER_PERMISSIONS));
        return new GroupMemberPermissions(ownedIdentity, group, null, null, null, GroupHelper.getStringsFromObvPermissions(permissions));
    }

    public static GroupMemberPermissions getV1OwnGroupPermissions(OwnedIdentity ownedIdentity, PreGroup preGroup, byte[] bytesGroupOwnerIdentity) {
        if (preGroup == null) {
            return null;
        }
        HashSet<GroupV2.Permission> permissions = new HashSet<GroupV2.Permission>(bytesGroupOwnerIdentity == null ? Arrays.asList(GroupV2.Permission.DEFAULT_ADMIN_PERMISSIONS) : Arrays.asList(GroupV2.Permission.DEFAULT_MEMBER_PERMISSIONS));
        return new GroupMemberPermissions(ownedIdentity, null, preGroup, null, null, GroupHelper.getStringsFromObvPermissions(permissions));
    }

    public static Set<BytesKey> getContactIdentitiesBytesFromContactList(List<ContactInfo> contacts) {
        HashSet<BytesKey> contactsBytes = new HashSet<BytesKey>(contacts.size());
        for (ContactInfo contact : contacts) {
            contactsBytes.add(BytesKey.of(contact.bytesContactIdentity()));
        }
        return contactsBytes;
    }

    public static Set<String> getStringsFromObvPermissions(GroupMemberPermissions groupMemberPermissions) {
        HashSet<String> permissionsAsStrings = new HashSet<String>();
        if (groupMemberPermissions.hasPermissionChangeSettings()) {
            permissionsAsStrings.add(GroupV2.Permission.CHANGE_SETTINGS.getString());
        }
        if (groupMemberPermissions.hasPermissionRemoteDeleteAnything()) {
            permissionsAsStrings.add(GroupV2.Permission.REMOTE_DELETE_ANYTHING.getString());
        }
        if (groupMemberPermissions.hasPermissionEditOrRemoteDeleteOwnMessages()) {
            permissionsAsStrings.add(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES.getString());
        }
        if (groupMemberPermissions.hasPermissionAdmin()) {
            permissionsAsStrings.add(GroupV2.Permission.GROUP_ADMIN.getString());
        }
        if (groupMemberPermissions.hasPermissionSendMessage()) {
            permissionsAsStrings.add(GroupV2.Permission.SEND_MESSAGE.getString());
        }
        return permissionsAsStrings;
    }

    public static Set<String> getStringsFromObvPermissions(HashSet<GroupV2.Permission> ownPermissions) {
        HashSet<String> permissionsAsStrings = new HashSet<String>();
        for (GroupV2.Permission permission : ownPermissions) {
            permissionsAsStrings.add(permission.getString());
        }
        return permissionsAsStrings;
    }

    public static Map<BytesKey, Set<String>> buildPermissionsChangePerIdentityBytes(List<GroupMemberPermissions> knownPermissions, List<ContactInfo> selectedContacts, List<PendingGroupMember> selectedPendingMember) {
        if (knownPermissions == null) {
            return Collections.emptyMap();
        }
        HashMap<BytesKey, Set<String>> permissionChanges = new HashMap<BytesKey, Set<String>>();
        for (GroupMemberPermissions memberPermission : knownPermissions) {
            boolean adminRequested;
            Optional<Id<ContactGroupJoin>> contactGroupJoinIdOpt = memberPermission.getContactGroupJoinId();
            Optional<Id<PendingGroupMember>> pendingGroupMemberIdOpt = memberPermission.getPendingGroupMemberId();
            boolean alreadyAdmin = memberPermission.hasPermissionAdmin();
            if (contactGroupJoinIdOpt.isPresent()) {
                Contact contact;
                Id<ContactGroupJoin> contactGroupJoinId = contactGroupJoinIdOpt.get();
                ContactGroupJoin contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().get(contactGroupJoinId);
                adminRequested = selectedContacts.stream().map(ContactInfo::genId).collect(Collectors.toSet()).contains(contactGroupJoin.getContactId());
                if (adminRequested && !alreadyAdmin) {
                    contact = DbManager.getInstance().getContactDao().get(contactGroupJoin.getContactId());
                    permissionChanges.put(BytesKey.of(contact.getBytesContactIdentity()), GroupHelper.getDefaultAdminPermissionsAsString());
                    continue;
                }
                if (adminRequested || !alreadyAdmin) continue;
                contact = DbManager.getInstance().getContactDao().get(contactGroupJoin.getContactId());
                permissionChanges.put(BytesKey.of(contact.getBytesContactIdentity()), GroupHelper.getDefaultMemberPermissionsAsString());
                continue;
            }
            if (!pendingGroupMemberIdOpt.isPresent()) continue;
            Id<PendingGroupMember> pendingGroupMemberId = pendingGroupMemberIdOpt.get();
            PendingGroupMember pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().get(pendingGroupMemberId);
            adminRequested = selectedPendingMember.contains(pendingGroupMember);
            ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(pendingGroupMember.getContactRefId());
            if (adminRequested && !alreadyAdmin) {
                permissionChanges.put(BytesKey.of(contactRef.getBytesContactIdentity()), GroupHelper.getDefaultAdminPermissionsAsString());
                continue;
            }
            if (adminRequested || !alreadyAdmin) continue;
            permissionChanges.put(BytesKey.of(contactRef.getBytesContactIdentity()), GroupHelper.getDefaultMemberPermissionsAsString());
        }
        return permissionChanges;
    }

    public static void updatePersonalNoteInDB(Group group, Optional<String> text) {
        if (group == null) {
            return;
        }
        AtomTasks.updateGroupPersonalNote(group, text, true);
    }

    public static boolean updateCustomGroupPhoto(Id<Group> group, Optional<String> photoUrl) {
        if (group != null) {
            return DbManager.getInstance().getGroupDao().updateCustomPhotoUrl(group, photoUrl.orElse(null)) != 0;
        }
        return false;
    }

    public static void updateGroupCustomName(Group group, Optional<String> customName) {
        if (group == null) {
            return;
        }
        Optional<String> filteredCustomName = customName.filter(s -> !s.isBlank());
        AtomTasks.updateGroupCustomName(group, filteredCustomName, true);
    }

    public static boolean isGroupNameCompliant(Group group, Optional<String> groupNameToTest) {
        if (group != null) {
            if (group.isV2()) {
                return true;
            }
            return groupNameToTest.isPresent() && !groupNameToTest.get().isEmpty();
        }
        return false;
    }

    public static boolean isGroupNameCompliant(boolean isV2, Optional<String> groupNameToTest) {
        if (isV2) {
            return true;
        }
        return groupNameToTest.isPresent() && !groupNameToTest.get().trim().isEmpty();
    }

    public static Optional<String> computeV2GroupDetailsChanges(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Optional<String> newGroupName, Optional<String> newGroupDescription) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupHelper::getV2GroupSerializedDetailsChange bad parameters");
            return Optional.empty();
        }
        try {
            if (newGroupName.isPresent() || newGroupDescription.isPresent()) {
                JsonGroupDetails jsonGroupDetails = new JsonGroupDetails();
                ObvGroupV2.ObvGroupV2DetailsAndPhotos groupDetailsAndPhoto = EngineWrapper.getInstance().getGroupV2DetailsAndPhotos(bytesOwnedIdentity, groupIdentifier);
                if (groupDetailsAndPhoto == null) {
                    return Optional.empty();
                }
                JsonGroupDetails publishedGroupDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(groupDetailsAndPhoto.serializedGroupDetails, JsonGroupDetails.class);
                if (publishedGroupDetails == null) {
                    return Optional.empty();
                }
                jsonGroupDetails.setDescription(newGroupDescription.orElse(publishedGroupDetails.getDescription()));
                jsonGroupDetails.setName(newGroupName.orElse(publishedGroupDetails.getName()));
                return Optional.of(EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)jsonGroupDetails));
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            AppLogger.e("GroupHelper::getV2GroupSerializedDetailsChange couldn't process group json details... ", (Exception)((Object)jsonProcessingException));
        }
        catch (Exception e) {
            AppLogger.e("GroupHelper::getV2GroupSerializedDetailsChange Exception occurred during engine getGroupV2DetailsAndPhotos call...", e);
        }
        return Optional.empty();
    }

    public static boolean isOwnedIdentityAdmin(Id<Group> groupId) {
        GroupMemberPermissions groupMemberPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().getOwnPermission(groupId);
        if (groupMemberPermissions != null) {
            return groupMemberPermissions.hasPermissionAdmin();
        }
        AppLogger.e("GroupHelper::isOwnedIdentityAdmin couldn't find own permissions, this is very bad... ");
        return false;
    }

    public static Set<String> getReadOnlyAdminPermissionsAsString() {
        return Stream.of(GroupV2.Permission.GROUP_ADMIN, GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES, GroupV2.Permission.CHANGE_SETTINGS, GroupV2.Permission.SEND_MESSAGE).map(GroupV2.Permission::getString).collect(Collectors.toSet());
    }

    public static boolean containsPermission(Id<Group> groupId, Either<Id<OwnedIdentity>, Id<Contact>> ownedOrContact, Collection<GroupV2.Permission> permissions) {
        GroupMemberPermissions groupPermissions;
        if (ownedOrContact.isLeft()) {
            return true;
        }
        Contact contact = DbManager.getInstance().getContactDao().get(ownedOrContact.getRight());
        GroupMemberPermissions contactMemberPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().getMemberPermissions(contact.getOwnedIdentityId(), ownedOrContact.getRight(), groupId);
        if (contactMemberPermissions != null) {
            groupPermissions = contactMemberPermissions;
        } else {
            ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
            GroupMemberPermissions pendingMemberPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().getPendingMemberPermissions(contact.getOwnedIdentityId(), contactRef, groupId);
            if (pendingMemberPermissions != null) {
                groupPermissions = pendingMemberPermissions;
            } else {
                return false;
            }
        }
        return groupPermissions.getPermissions().containsAll(permissions);
    }

    public static String getGroupMembersNames(Group group) {
        DbManager db = DbManager.getInstance();
        ArrayList<String> membersNames = new ArrayList<String>(GroupHelper.namesFromGroupPendingMembers(group));
        Map<Boolean, List<Contact>> contacts = db.getContactDao().get(db.getContactGroupJoinDao().getGroupMembersContactIds((Id<Group>)group.getItemId())).stream().collect(Collectors.partitioningBy(contact -> contact.getCustomDisplayName().isPresent()));
        membersNames.addAll(contacts.get(true).stream().map(contact -> contact.getCustomDisplayName().orElse("")).toList());
        db.getIdentityDetailsDao().get(contacts.get(false).stream().map(ContactGenerated::getIdentityDetailsId).collect(Collectors.toList())).forEach(identityDetails -> membersNames.add(OptionalUtils.join(" ", List.of(identityDetails.getFirstName(), identityDetails.getLastName())).orElse("")));
        Collections.sort(membersNames);
        return String.join((CharSequence)", ", membersNames);
    }

    public static String getGroupMembersNames(PreGroup preGroup) {
        DbManager db = DbManager.getInstance();
        List<PendingGroupMember> pendingMembers = db.getPendingGroupMemberDao().getPendingMembers(preGroup);
        ArrayList<String> membersNames = new ArrayList<String>(GroupHelper.nameFromPendingMembers(pendingMembers));
        Collections.sort(membersNames);
        return String.join((CharSequence)", ", membersNames);
    }

    private static List<String> namesFromGroupPendingMembers(Group group) {
        DbManager db = DbManager.getInstance();
        List<PendingGroupMember> pendingMembers = db.getPendingGroupMemberDao().getPendingMembers(group);
        return GroupHelper.nameFromPendingMembers(pendingMembers);
    }

    private static List<String> nameFromPendingMembers(List<PendingGroupMember> pendingMembers) {
        return pendingMembers.stream().map(GroupHelper::nameFromPendingMember).toList();
    }

    private static String nameFromPendingMember(PendingGroupMember pendingGroupMember) {
        Id<ContactRef> contactRefId = pendingGroupMember.getContactRefId();
        ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(contactRefId);
        if (contactRef.getContactId().isPresent()) {
            Contact contact = DbManager.getInstance().getContactDao().get(contactRef.getContactId().get());
            if (contact.getCustomDisplayName().isPresent()) {
                return contact.getCustomDisplayName().get();
            }
            IdentityDetails identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(contact.getIdentityDetailsId());
            ContactInfo contactInfo = new ContactInfo(contact, identityDetails);
            return contactInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
        }
        Id<IdentityDetails> identityDetailsId = pendingGroupMember.getIdentityDetailsId();
        IdentityDetails identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(identityDetailsId);
        return new IdentityDetailsInfo(identityDetails).getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
    }

    public static void updateGroupMembersNamesForIdentity(OwnedIdentity ownedIdentity) {
        List<Group> groupsAssociatedToIdentity = DbManager.getInstance().getGroupDao().getGroupsAssociatedToIdentity((Id<OwnedIdentity>)ownedIdentity.getItemId());
        for (Group group : groupsAssociatedToIdentity) {
            String memberNames = GroupHelper.getGroupMembersNames(group);
            DbManager.getInstance().getGroupDao().updateGroupMembersNames(ownedIdentity, group.getBytesGroupIdentifier(), memberNames);
        }
    }

    public static Optional<String> getObvSerializedGroupType(GroupType groupType, boolean readOnly, GroupCreationFlowModel.DeletePermission deletePermission) {
        JsonGroupType obvJsonGroupType = null;
        switch (groupType) {
            case STANDARD: {
                obvJsonGroupType = JsonGroupType.createSimple();
                break;
            }
            case CONTROLLED: {
                obvJsonGroupType = JsonGroupType.createPrivate();
                break;
            }
            case READ_ONLY: {
                obvJsonGroupType = JsonGroupType.createReadOnly();
                break;
            }
            case CUSTOM: {
                switch (deletePermission) {
                    case ADMIN_ONLY: {
                        obvJsonGroupType = JsonGroupType.createCustom((boolean)readOnly, (String)"admins");
                        break;
                    }
                    case NO_ONE: {
                        obvJsonGroupType = JsonGroupType.createCustom((boolean)readOnly, (String)"nobody");
                        break;
                    }
                    case EVERY_ONE: {
                        obvJsonGroupType = JsonGroupType.createCustom((boolean)readOnly, (String)"everyone");
                    }
                }
                break;
            }
            case NONE: {
                return Optional.empty();
            }
        }
        try {
            return Optional.ofNullable(EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)obvJsonGroupType));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }
}

