/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.files;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ImageUtils;
import java.io.IOException;

public class ThumbnailHelper {
    static final int THUMBNAIL_HEIGHT = 25;
    static final int THUMBNAIL_WIDTH = 25;

    static String getDefaultThumbnailByMime(String mimeType) {
        return ImageUtils.getDefaultImage(mimeType);
    }

    static boolean isDefaultThumbnail(String thumbnailPath) {
        return thumbnailPath.startsWith("/images/");
    }

    static void deleteThumbnailFile(String thumbnailPath) {
        if (ThumbnailHelper.isDefaultThumbnail(thumbnailPath)) {
            return;
        }
        SecureFile thumbnailSecureFile = new SecureFile(FileApi.absolutePathFromRelative(thumbnailPath));
        if (thumbnailSecureFile.exists()) {
            try {
                thumbnailSecureFile.delete();
            }
            catch (IOException ioException) {
                AppLogger.e("ImageHelper: deleteThumbnailFile: unable to delete thumbnail");
            }
        } else {
            AppLogger.i("ThumbnailService: deleteThumbnailFile: file not found");
        }
    }
}

