/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.files;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.io.IOException;

class FyleHelper {
    FyleHelper() {
    }

    static void deleteFyleIfOrphanTask(Id<Fyle> fyleId) {
        long attachmentForThisFyleCount = DbManager.getInstance().getInboundAttachmentDao().countAttachmentsForFyle(fyleId);
        attachmentForThisFyleCount += DbManager.getInstance().getOwnedAttachmentDao().countAttachmentsForFyle(fyleId);
        if ((attachmentForThisFyleCount += DbManager.getInstance().getOutboundAttachmentDao().countAttachmentsForFyle(fyleId)) == 0L) {
            FyleHelper.deleteFyleTask(fyleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteFyleTask(Id<Fyle> fyleId) {
        if (fyleId == null) {
            AppLogger.e("FyleService: deleteFyle: invalid params " + String.valueOf(fyleId));
            return;
        }
        Fyle dbFyle = DbManager.getInstance().getFyleDao().get(fyleId);
        if (dbFyle.getFilePath() == null) {
            DbManager.getInstance().getFyleDao().customDelete(dbFyle);
        } else {
            FileApi._acquireLock(dbFyle.getFilePath());
            try {
                boolean deletedInDb;
                boolean bl = deletedInDb = DbManager.getInstance().getFyleDao().deleteWithRet(dbFyle) == 1;
                if (!deletedInDb) {
                    return;
                }
                SecureFile secureFile = new SecureFile(FileApi.absolutePathFromRelative(dbFyle.getFilePath()));
                secureFile.delete();
            }
            catch (IOException e) {
                AppLogger.e("FyleService: deleteFyle: couldn't delete fyle : " + String.valueOf(fyleId), e);
            }
            finally {
                FileApi._releaseLock(dbFyle.getFilePath());
            }
        }
    }
}

