/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.files;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.files.SizeAndSha256;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.UUID;

class FileHelper {
    static final String BASE_DIRECTORY = AppRuntimeHelper.OLVID_DATA_DIR_ABSOLUTE_PATH;
    static final String TMP_DIRECTORY = "tmp";
    static final String FYLE_DIRECTORY = "fyles";
    static final String THUMBNAIL_DIRECTORY = "thumbnails";

    FileHelper() {
    }

    static String getRandomTemporaryRelativePath() {
        UUID uuid = UUID.randomUUID();
        return TMP_DIRECTORY + File.separator + String.valueOf(uuid);
    }

    static String absolutePathFromRelative(String relativePath) {
        if (System.getProperty("user.dir") != null) {
            return new File(new File(BASE_DIRECTORY), relativePath).getAbsolutePath();
        }
        return new File(relativePath).getAbsolutePath();
    }

    static void _moveFile(String newRelativePath, String oldRelativePath) throws IOException {
        File newFile;
        SecureFile oldFile = new SecureFile(FileHelper.absolutePathFromRelative(oldRelativePath));
        if (!oldFile.renameTo((newFile = new File(FileHelper.absolutePathFromRelative(newRelativePath))).getParent(), newFile.getName())) {
            SecureFile newSecureFile = new SecureFile(FileHelper.absolutePathFromRelative(newRelativePath));
            try (SecureFileInputStream fileInputStream = new SecureFileInputStream(oldFile);
                 SecureFileOutputStream fileOutputStream = new SecureFileOutputStream(newSecureFile);){
                int c;
                byte[] buffer = new byte[262144];
                while ((c = fileInputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, c);
                }
            }
            oldFile.delete();
        }
    }

    static SizeAndSha256 _computeSHA256FromUnencryptedFile(String absoluteFilePath) {
        SizeAndSha256 sizeAndSha256;
        FileInputStream is = new FileInputStream(absoluteFilePath);
        try {
            sizeAndSha256 = FileHelper._computeSHA256FromInputStream(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        is.close();
        return sizeAndSha256;
    }

    static SizeAndSha256 _computeSHA256FromEncryptedFile(String relativeFilePath) {
        SizeAndSha256 sizeAndSha256;
        SecureFileInputStream is = new SecureFileInputStream(new SecureFile(FileApi.absolutePathFromRelative(relativeFilePath)));
        try {
            sizeAndSha256 = FileHelper._computeSHA256FromInputStream((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        is.close();
        return sizeAndSha256;
    }

    static SizeAndSha256 _computeSHA256FromInputStream(InputStream is) {
        try {
            int c;
            MessageDigest h = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[262144];
            long fileSize = 0L;
            while ((c = is.read(buffer)) != -1) {
                h.update(buffer, 0, c);
                fileSize += (long)c;
            }
            return new SizeAndSha256(fileSize, h.digest());
        }
        catch (Exception e) {
            return null;
        }
    }
}

