/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.discussion;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;

public class DiscussionDeletionHelper {
    private DiscussionDeletionHelper() {
    }

    public static boolean deleteDiscussionLocallyDbTask(Id<Discussion> discussionId) {
        if (discussionId == null) {
            AppLogger.e("DiscussionDeletionHelper: deleteDiscussionLocallyDbTask: discussion passed is null");
            return false;
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionId);
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                List systemMessages = DbManager.getInstance().getSystemMessageDao().getAllMessagesForDiscussion(discussion);
                List inboundMessages = DbManager.getInstance().getInboundMessageDao().getAllMessagesForDiscussion(discussion);
                List outboundMessages = DbManager.getInstance().getOutboundMessageDao().getAllMessagesForDiscussion(discussion);
                List ownedMessages = DbManager.getInstance().getOwnedMessageDao().getAllMessagesForDiscussion(discussion);
                if (!Api.getMessageApi().deleteMessagesLocallyDbTask(systemMessages)) {
                    throw new SQLException("Cannot empty discussion");
                }
                if (!Api.getMessageApi().deleteMessagesLocallyDbTask(inboundMessages)) {
                    throw new SQLException("Cannot empty discussion");
                }
                if (!Api.getMessageApi().deleteMessagesLocallyDbTask(outboundMessages)) {
                    throw new SQLException("Cannot empty discussion");
                }
                if (!Api.getMessageApi().deleteMessagesLocallyDbTask(ownedMessages)) {
                    throw new SQLException("Cannot empty discussion");
                }
                DbManager.getInstance().getInboundMessageSequenceIntervalDao().deleteAllIntervalsForDiscussion((Id<Discussion>)discussion.getItemId());
                DbManager.getInstance().getOwnedMessageSequenceIntervalDao().deleteAllIntervalsForDiscussion((Id<Discussion>)discussion.getItemId());
                if (discussion.isPreDiscussion() || discussion.isLocked()) {
                    if (discussion.isPreDiscussion()) {
                        if (discussion.getPreContactId().isPresent()) {
                            DbManager.getInstance().getPreContactDao().deleteWithIdentityDetails(discussion.getPreContactId().get());
                        } else if (discussion.getPreGroupId().isPresent()) {
                            DbManager.getInstance().getPreGroupDao().deleteById(discussion.getPreGroupId().get());
                        }
                    }
                    DbManager.getInstance().getDiscussionDao().delete(discussion);
                } else {
                    discussion.setStatus(DiscussionGenerated.Status.HIDDEN);
                    DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
                }
                return null;
            });
            return true;
        }
        catch (SQLException e) {
            AppLogger.e("DiscussionDeletionHelper: deleteDiscussionLocallyDbTask: sql exception in transaction", e);
            return false;
        }
    }
}

