/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.discussion;

import io.olvid.engine.Logger;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.engine.helpers.message.ReturnReceiptStatus;
import io.olvid.windows.messenger.engine.helpers.message.tasks.CreateReadMessageMetadata;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.AppSettingsHelper;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.ContactApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class DiscussionApi {
    private static final AppLogger logger = new AppLogger(DiscussionApi.class);

    public static void unHideDiscussionIfHiddenDbTask(Discussion discussion) {
        if (discussion == null) {
            AppLogger.w("DiscussionApi: unHideDiscussionIfHiddenDbTask: passed null discussion");
            return;
        }
        if (discussion.isHidden()) {
            discussion.setStatus(DiscussionGenerated.Status.NORMAL);
            DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
            DbManager.getInstance().getDiscussionDao().updateLastMessageTimestamp(discussion, discussion.getSortTimestamp());
        }
    }

    public static void markDiscussionMessagesAsReadUpTo(Id<Discussion> discussionId, Optional<Long> lastReadTimeStamp) {
        if (discussionId == null) {
            return;
        }
        AsyncTaskExecutor.submitTask(() -> {
            try {
                TransactionWrapper.startStatementTransaction(() -> {
                    long lastReadTimestampMessage;
                    Discussion discussion = (Discussion)DbManager.getInstance().getDiscussionDao().get(discussionId);
                    boolean sendReadReceiptConfigured = AppSettingsHelper.needToSendReadReceiptsInDiscussionDbTask(discussionId);
                    List<InboundMessage> messages = DbManager.getInstance().getInboundMessageDao().getAllUnreadDiscussionMessagesUpTo(discussionId, lastReadTimeStamp);
                    if (messages.isEmpty()) {
                        return null;
                    }
                    for (InboundMessage message : messages) {
                        if (message.isBoxed()) continue;
                        new CreateReadMessageMetadata(message).run();
                        if (!sendReadReceiptConfigured) continue;
                        Api.getMessageApi().sendMessageReturnReceipt(message, ReturnReceiptStatus.READ);
                    }
                    UnreadMessageCountCache.getInstance().decrementUnreadCount(discussion.getOwnedIdentityId(), discussionId, messages.size());
                    DbManager.getInstance().getInboundMessageDao().markDiscussionMessagesReadUpTo(discussionId, lastReadTimeStamp);
                    if (lastReadTimeStamp.isPresent()) {
                        lastReadTimestampMessage = (Long)lastReadTimeStamp.get();
                    } else {
                        Optional<Long> lastReadMessageTimestamp = DbManager.getInstance().getInboundMessageDao().getLastReadMessageTimestamp(discussionId);
                        if (lastReadMessageTimestamp.isEmpty()) {
                            return null;
                        }
                        lastReadTimestampMessage = lastReadMessageTimestamp.get();
                    }
                    MessagePostHelper.postDiscussionReadMessageDbTask(discussion, lastReadTimestampMessage);
                    return null;
                });
            }
            catch (SQLException e) {
                logger.error("DiscussionApi: markDiscussionMessagesAsRead: trying to un-hide a non hidden discussion: " + String.valueOf(discussionId));
                throw new RuntimeException(e);
            }
        });
    }

    public static String computeTitle(Discussion discussion) {
        ViewControllerHelper.checkNotUIThread();
        return switch (discussion.getKind()) {
            default -> throw new MatchException(null, null);
            case Discussion.Kind.CONTACT -> {
                Id<Contact> contact = discussion.getContactId().orElseThrow(IllegalStateException::new);
                yield ContactApi.getDisplayName(contact, IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY);
            }
            case Discussion.Kind.PRE_CONTACT -> {
                Id<PreContact> preContactId = discussion.getPreContactId().orElseThrow(IllegalStateException::new);
                PreContact preContact = DbManager.getInstance().getPreContactDao().get(preContactId);
                ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(preContact.getContactRefId());
                Optional<Id<Contact>> contactRefId = contactRef.getContactId();
                if (contactRefId.isPresent()) {
                    yield ContactApi.getDisplayName(contactRefId.get(), IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY);
                }
                IdentityDetails identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(preContact.getIdentityDetailsId());
                IdentityDetailsInfo identityDetailsInfo = new IdentityDetailsInfo(identityDetails);
                yield identityDetailsInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
            }
            case Discussion.Kind.GROUP -> {
                Id<Group> groupId = discussion.getGroupId().orElseThrow(IllegalStateException::new);
                Group group = DbManager.getInstance().getGroupDao().get(groupId);
                yield group.getDisplayName().orElse("");
            }
            case Discussion.Kind.PRE_GROUP -> {
                Id<PreGroup> preGroupId = discussion.getPreGroupId().orElseThrow(IllegalStateException::new);
                PreGroup preGroup = DbManager.getInstance().getPreGroupDao().get(preGroupId);
                yield preGroup.getDisplayName().orElse("");
            }
            case Discussion.Kind.LOCKED -> discussion.getLockedTitle().orElse("");
        };
    }

    public static void lockDiscussion(Discussion discussion) {
        ViewControllerHelper.checkNotUIThread();
        String title = DiscussionApi.computeTitle(discussion);
        switch (discussion.getKind()) {
            case CONTACT: {
                discussion.setContact(Optional.empty());
                discussion.setLockedTitle(Optional.of(title));
                break;
            }
            case PRE_CONTACT: {
                discussion.setPreContact(Optional.empty());
                discussion.setLockedTitle(Optional.of(title));
                break;
            }
            case GROUP: {
                discussion.setGroup(Optional.empty());
                discussion.setLockedTitle(Optional.of(title));
                break;
            }
            case PRE_GROUP: {
                discussion.setPreGroup(Optional.empty());
                discussion.setLockedTitle(Optional.of(title));
                break;
            }
            case LOCKED: {
                logger.warning("Try to lock a locked discussion.");
                return;
            }
        }
        discussion.setStatus(DiscussionGenerated.Status.LOCKED);
    }

    public static void updateDraftReplyTo(Id<Discussion> discussionId, Optional<MessageRef> replyTo) {
        Optional<OutboundMessage> draftOpt = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage(discussionId);
        if (draftOpt.isEmpty()) {
            if (replyTo.isEmpty()) {
                return;
            }
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionId);
            OutboundMessage draft = MessageBuilder.createEmptyDraft(discussion);
            draft.setReplyTo(replyTo);
            draft = DbManager.getInstance().getOutboundMessageDao().createIfNotExists(draft);
            if (draft == null) {
                Logger.e((String)"DiscussionApi.updateDraftReplyTo: unable to insert message in database");
                return;
            }
        } else {
            DbManager.getInstance().getOutboundMessageDao().updateDraftReplyTo((Id<OutboundMessage>)draftOpt.get().getItemId(), replyTo);
        }
    }
}

