/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.attachment;

import io.olvid.windows.messenger.database.datatypes.fyle.JsonMetadata;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLConnection;
import java.util.List;
import java.util.Objects;

public final class AttachmentUtils {
    public static final AppLogger logger = new AppLogger(AttachmentUtils.class);
    public static final String HomeDownloadsFolder = "Downloads";

    private AttachmentUtils() {
    }

    public static boolean refreshStatus(OutboundAttachment attachment) {
        List<AttachmentRecipientInfo> attachmentRecipientInfos = DbManager.getInstance().getAttachmentRecipientInfoDao().getAllForAttachment((Id<OutboundAttachment>)attachment.getItemId());
        return AttachmentUtils.refreshStatus(attachment, attachmentRecipientInfos);
    }

    public static boolean refreshStatus(OutboundAttachment attachment, List<AttachmentRecipientInfo> infos) {
        if (infos.isEmpty()) {
            return false;
        }
        switch (attachment.getStatus()) {
            case CANCELLED: 
            case FAILED: 
            case NO_CONTACT_RECIPIENTS: 
            case COPYING: 
            case DRAFT_READY: {
                return false;
            }
        }
        OutboundAttachmentGenerated.Status newStatus = infos.stream().allMatch(info -> AttachmentRecipientInfo.Status.READ.isLessOrEqualTo(info.status())) ? OutboundAttachmentGenerated.Status.READ : (infos.stream().allMatch(info -> AttachmentRecipientInfo.Status.DELIVERED.isLessOrEqualTo(info.status())) ? OutboundAttachmentGenerated.Status.DELIVERED : (infos.stream().allMatch(info -> AttachmentRecipientInfo.Status.SENT.isLessOrEqualTo(info.status())) ? OutboundAttachmentGenerated.Status.SENT : (infos.stream().allMatch(info -> AttachmentRecipientInfo.Status.UPLOADING.isLessOrEqualTo(info.status())) ? OutboundAttachmentGenerated.Status.UPLOADING : OutboundAttachmentGenerated.Status.UNPROCESSED)));
        if (attachment.getStatus() == newStatus) {
            return false;
        }
        attachment.setStatus(newStatus);
        return true;
    }

    public static String getNonNullMimeType(AbstractAttachmentGenerated<?> attachment) {
        String mimeType = attachment.getMimeType();
        String filename = attachment.getFilename();
        if (mimeType == null || !mimeType.contains("/")) {
            String type = URLConnection.getFileNameMap().getContentTypeFor(filename);
            return Objects.requireNonNullElse(type, "application/octet-stream");
        }
        return mimeType;
    }

    public static String determineMimeType(File file) {
        String mime = URLConnection.getFileNameMap().getContentTypeFor(file.getName());
        if (mime == null || mime.isEmpty()) {
            mime = "application/octet-stream";
        }
        return mime;
    }

    public static byte[] getMetadata(AbstractAttachmentGenerated<?> attachment, Fyle fyle) throws Exception {
        JsonMetadata jsonMetadata = new JsonMetadata(AttachmentUtils.getNonNullMimeType(attachment), attachment.getFilename(), fyle.getSha256().orElse(null));
        return EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonMetadata);
    }

    public static String getFileExtension(String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            return filename.substring(lastDot + 1);
        }
        return null;
    }

    public static void createZoneIdentifier(String filePath) throws IOException {
        if (!AppRuntimeHelper.isWindows()) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + filePath);
        }
        File zoneIdentifierFile = new File(filePath + ":Zone.Identifier");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(zoneIdentifierFile));){
            writer.write("[ZoneTransfer]\n");
            writer.write("ZoneId=3\n");
        }
    }
}

