/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.atom.tasks;

import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.atom.tasks.AtomTasks;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.UUID;

public class ApplySyncAtomTask
implements Runnable {
    private final UUID uuid;
    private final OwnedIdentity ownedIdentity;
    private final ObvSyncAtom atom;
    private final AppLogger logger = new AppLogger(ApplySyncAtomTask.class);

    public ApplySyncAtomTask(UUID uuid, OwnedIdentity ownedIdentity, ObvSyncAtom atom) {
        this.uuid = uuid;
        this.ownedIdentity = ownedIdentity;
        this.atom = atom;
    }

    private void run0() throws Exception {
        switch (this.atom.syncType) {
            case 0: {
                Contact contact = DbManager.getInstance().getContactDao().get((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), this.atom.getBytesContactIdentity());
                if (contact == null) break;
                AtomTasks.updateContactCustomName(contact, OptionalUtils.noneIfEmpty(this.atom.getStringValue()), false);
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                Group group = DbManager.getInstance().getGroupDao().get(this.ownedIdentity, this.atom.getBytesGroupOwnerAndUid());
                if (group == null) break;
                AtomTasks.updateGroupCustomName(group, OptionalUtils.noneIfEmpty(this.atom.getStringValue()), false);
                break;
            }
            case 2: {
                Group group = DbManager.getInstance().getGroupDao().get(this.ownedIdentity, this.atom.getBytesGroupIdentifier());
                if (group == null) break;
                AtomTasks.updateGroupCustomName(group, OptionalUtils.noneIfEmpty(this.atom.getStringValue()), false);
                break;
            }
            case 4: {
                Group group = DbManager.getInstance().getGroupDao().get(this.ownedIdentity, this.atom.getBytesGroupOwnerAndUid());
                if (group == null) break;
                AtomTasks.updateGroupPersonalNote(group, OptionalUtils.noneIfEmpty(this.atom.getStringValue()), false);
                break;
            }
            case 5: {
                Group group = DbManager.getInstance().getGroupDao().get(this.ownedIdentity, this.atom.getBytesGroupIdentifier());
                if (group == null) break;
                AtomTasks.updateGroupPersonalNote(group, OptionalUtils.noneIfEmpty(this.atom.getStringValue()), false);
                break;
            }
            case 6: {
                AtomTasks.updateOwnedIdentityNickname((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), OptionalUtils.noneIfEmpty(this.atom.getStringValue()), false);
                break;
            }
            case 8: {
                Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), this.atom.getBytesContactIdentity());
                if (discussion == null) break;
                AtomTasks.updateSendReadReceiptContactSetting(discussion, this.atom.getBooleanValue(), false);
                break;
            }
            case 9: {
                Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionFromGroupIdentifier(this.atom.getBytesGroupOwnerAndUid(), (Id<OwnedIdentity>)this.ownedIdentity.getItemId());
                if (discussion == null) break;
                AtomTasks.updateSendReadReceiptContactSetting(discussion, this.atom.getBooleanValue(), false);
                break;
            }
            case 10: {
                Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionFromGroupIdentifier(this.atom.getBytesGroupIdentifier(), (Id<OwnedIdentity>)this.ownedIdentity.getItemId());
                if (discussion == null) break;
                AtomTasks.updateSendReadReceiptContactSetting(discussion, this.atom.getBooleanValue(), false);
                break;
            }
            case 7: {
                break;
            }
            case 11: {
                break;
            }
            case 15: {
                Optional<String> value = Optional.ofNullable(this.atom.getBooleanValue()).map(Object::toString);
                AtomTasks.updateApplicationSetting(ApplicationSetting.GlobalAppSettings.SEND_READ_RECEIPT_SETTING_KEY, value, false);
                break;
            }
            case 16: {
                break;
            }
            default: {
                this.logger.debug("ApplySyncAtomTask:: Unknown sync atom task");
                EngineWrapper.getInstance().deletePersistedDialog(this.uuid);
            }
        }
    }

    @Override
    public void run() {
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                this.run0();
                EngineWrapper.getInstance().deletePersistedDialog(this.uuid);
                return null;
            });
        }
        catch (Exception e) {
            AppLogger.e("ApplySyncAtomTask:: An error occurred while applying a syncItem. Aborting transaction", e);
        }
    }
}

