/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.ObvDialog;
import io.olvid.engine.engine.types.ObvTransferStep;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.SimpleAuthState;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.UUID;

class TransferApiImpl
implements TransferApi {
    final AppLogger appLogger = new AppLogger(TransferApiImpl.class);

    TransferApiImpl() {
    }

    @Override
    public void initiateOwnedIdentityTransferProtocolOnTargetDevice(String deviceName) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            engine.initiateOwnedIdentityTransferProtocolOnTargetDevice(deviceName);
        }
        catch (Exception e) {
            AppLogger.e("Failed to initiate owned identity transfer protocol on target device", e);
        }
    }

    @Override
    public void initiateOwnedIdentityTransferProtocolOnSourceDevice(OwnedIdentityInfo ownedIdentity) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            engine.initiateOwnedIdentityTransferProtocolOnSourceDevice(ownedIdentity.bytesOwnedIdentity());
        }
        catch (Exception e) {
            AppLogger.e("Failed to initiate owned identity transfer protocol on source device", e);
        }
    }

    @Override
    public boolean setTransferSessionNumber(long sessionNumber, TransferApi.Step step, UUID dialogUUID, byte[] bytesOwnedIdentity, Encoded encodedElements) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        ObvTransferStep obvTransferStep = step.toObvTransferStep();
        ObvDialog dialog = new ObvDialog(dialogUUID, encodedElements, bytesOwnedIdentity, new ObvDialog.Category(18, null, null, null, null, null, null, null, null, null, null, null, obvTransferStep));
        try {
            dialog.setTransferSessionNumber(sessionNumber);
            engine.respondToDialog(dialog);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setTransferSasAndDeviceUid(String sas, Optional<byte[]> deviceUidToKeepActive, TransferApi.Step step, UUID dialogUUID, byte[] bytesOwnedIdentity, Encoded encodedElements) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        ObvTransferStep obvTransferStep = step.toObvTransferStep();
        ObvDialog dialog = new ObvDialog(dialogUUID, encodedElements, bytesOwnedIdentity, new ObvDialog.Category(18, null, null, null, null, null, null, null, null, null, null, null, obvTransferStep));
        try {
            dialog.setTransferSasAndDeviceUid(sas, (byte[])deviceUidToKeepActive.orElse(null));
            engine.respondToDialog(dialog);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setTransferAuthenticationProof(byte[] bytesOwnedIdentity, TransferApi.Step step, UUID dialogUUID, Encoded encodedElements, String signature, SimpleAuthState simpleAuthState) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        ObvTransferStep obvTransferStep = step.toObvTransferStep();
        ObvDialog dialog = new ObvDialog(dialogUUID, encodedElements, bytesOwnedIdentity, new ObvDialog.Category(18, null, null, null, null, null, null, null, null, null, null, null, obvTransferStep));
        try {
            String SerializedAuthState = KeycloakUtils.getJsonObjectMapper().writeValueAsString((Object)simpleAuthState);
            dialog.setTransferAuthenticationProof(signature, SerializedAuthState);
            engine.respondToDialog(dialog);
        }
        catch (JsonProcessingException e) {
            this.appLogger.error("TransferApi::setTransferAuthenticationProof couldn't serialize auth state");
            return false;
        }
        catch (Exception e) {
            this.appLogger.error("TransferApi::setTransferAuthenticationProof couldn't set Transfer Authentication Proof in dialog");
            return false;
        }
        return true;
    }

    @Override
    public boolean abortTransfer(TransferApi.Step step, UUID dialogUUID, byte[] bytesOwnedIdentity, Encoded encodedElements) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        ObvTransferStep obvTransferStep = step.toObvTransferStep();
        ObvDialog dialog = new ObvDialog(dialogUUID, encodedElements, bytesOwnedIdentity, new ObvDialog.Category(18, null, null, null, null, null, null, null, null, null, null, null, obvTransferStep));
        try {
            dialog.setAbortTransfer();
            engine.respondToDialog(dialog);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

