/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.SyncAtomApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.concurrent.Callable;

class SyncAtomApiImpl
implements SyncAtomApi {
    SyncAtomApiImpl() {
    }

    @Override
    public void propagateAppSyncAtomToOtherDevicesIfNeeded(Id<OwnedIdentity> ownedIdentityId, Callable<ObvSyncAtom> obvSyncAtom) {
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(ownedIdentityId);
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            engine.propagateAppSyncAtomToOtherDevicesIfNeeded(ownedIdentity.getBytesOwnedIdentity(), obvSyncAtom.call());
        }
        catch (Exception e) {
            AppLogger.e("Failed to propagate app sync atom to other devices", e);
        }
    }

    @Override
    public void propagateAppSyncAtomToAllOwnedIdentitiesOtherDevicesIfNeeded(Callable<ObvSyncAtom> obvSyncAtom) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            engine.propagateAppSyncAtomToAllOwnedIdentitiesOtherDevicesIfNeeded(obvSyncAtom.call());
        }
        catch (Exception e) {
            AppLogger.e("Failed to propagate app sync atom to all owned identities other devices", e);
        }
    }
}

