/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.dao.attachment.ReceivedAttachmentDao;
import io.olvid.windows.messenger.database.dao.message.ReceivedMessageDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OutboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OwnedMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.MessageApi;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.helpers.message.LinkPreviewInfo;
import io.olvid.windows.messenger.engine.helpers.message.MessageDeletionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.engine.helpers.message.ReturnReceiptStatus;
import io.olvid.windows.messenger.engine.helpers.message.tasks.CreateUnprocessedMessage;
import io.olvid.windows.messenger.engine.helpers.message.tasks.ExpiringOutboundMessageSentTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.ForwardMessageTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.PostMessageTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.UpdateReactionsTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.VoteToPollTask;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Watches;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class MessageApiImpl
implements MessageApi {
    private static final AppLogger logger = new AppLogger(MessageApiImpl.class);

    MessageApiImpl() {
    }

    @Override
    public void sendMessageDbTask(Optional<String> body, Id<Discussion> discussionId, Optional<MessageRef> repliedMessageRef) {
        OutboundMessage messageToSend = new CreateUnprocessedMessage(body, discussionId, Optional.empty(), repliedMessageRef).get();
        if (messageToSend == null) {
            return;
        }
        new PostMessageTask((Id<OutboundMessage>)messageToSend.getItemId()).run();
    }

    @Override
    public boolean updateOwnedMessageBodyDbTask(Id<OwnedMessage> messageId, String newBody) {
        OwnedMessage message = DbManager.getInstance().getOwnedMessageDao().get(messageId);
        if (message == null) {
            AppLogger.e("MessageApi.editMessageBodyDbTask: cannot find message in db");
            return false;
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
        if (discussion == null) {
            AppLogger.e("MessageApi.editMessageBodyDbTask: cannot find message or discussion in db");
            return false;
        }
        if (newBody.trim().isEmpty()) {
            AppLogger.e("MessageApi.editMessageBodyDbTask: message new body is blank");
            return false;
        }
        message.setBody(Optional.of(newBody.trim()));
        if (!MessagePostHelper.postUpdateMessageMessageDbTask(message, discussion)) {
            return false;
        }
        DbManager.getInstance().getOwnedMessageDao().updateBodyAndMarkAsEdited(messageId, message.getBody());
        DbManager.getInstance().getOwnedMessageMetadataDao().insert(new OwnedMessageMetadata(message, OwnedMessageMetadataGenerated.Kind.EDITED, System.currentTimeMillis()));
        return true;
    }

    @Override
    public boolean updateMessageBodyDbTask(Id<OutboundMessage> messageId, String newBody) {
        OutboundMessage message = DbManager.getInstance().getOutboundMessageDao().get(messageId);
        if (message == null) {
            AppLogger.e("MessageApi.editMessageBodyDbTask: cannot find message in db");
            return false;
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
        if (discussion == null) {
            AppLogger.e("MessageApi.editMessageBodyDbTask: cannot find message or discussion in db");
            return false;
        }
        if (newBody.trim().isEmpty()) {
            AppLogger.e("MessageApi.editMessageBodyDbTask: message new body is blank");
            return false;
        }
        message.setBody(Optional.of(newBody.trim()));
        if (!MessagePostHelper.postUpdateMessageMessageDbTask(message, discussion)) {
            return false;
        }
        Watches.Watch watch = Watches.getInstance().start("updateBodyAndMarkAsEdited");
        DbManager.getInstance().getOutboundMessageDao().updateBodyAndMarkAsEdited(messageId, message.getBody());
        watch.stop();
        Watches.getInstance().print();
        DbManager.getInstance().getOutboundMessageMetadataDao().insert(new OutboundMessageMetadata(message, OutboundMessageMetadataGenerated.Kind.EDITED, System.currentTimeMillis()));
        return true;
    }

    @Override
    public boolean reactToMessageDbTask(AbstractUserMessageGenerated<?> message, Optional<String> emoji) {
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
        if (discussion == null) {
            AppLogger.e("MessageApi.updateMessageBodyDbTask: cannot find discussion in db");
            return false;
        }
        IdentityRef ownedIdentityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(discussion.getOwnedIdentityId());
        if (ownedIdentityRef == null) {
            AppLogger.e("MessageApi.updateMessageBodyDbTask: cannot find ownedIdentityRef in db");
            return false;
        }
        UpdateReactionsTask task = new UpdateReactionsTask(message, discussion, emoji, (Id<IdentityRef>)ownedIdentityRef.getItemId(), System.currentTimeMillis(), true);
        try {
            return task.call();
        }
        catch (Exception e) {
            AppLogger.e("MessageApi::reactToDbTask failed", e);
            return false;
        }
    }

    @Override
    public void voteToPollMessageDbTask(AbstractUserMessageGenerated<?> message, PollMessage pollMessage, PollMessageChoice choice) {
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
        if (discussion == null) {
            AppLogger.e("MessageApi.voteToPollMessageDbTask: cannot find discussion in db");
            return;
        }
        IdentityRef ownedIdentityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(discussion.getOwnedIdentityId());
        if (ownedIdentityRef == null) {
            AppLogger.e("MessageApi.voteToPollMessageDbTask: cannot find ownedIdentityRef in db");
            return;
        }
        VoteToPollTask task = new VoteToPollTask(message, discussion, ownedIdentityRef, choice, System.currentTimeMillis(), true);
        try {
            task.call();
        }
        catch (Exception e) {
            AppLogger.e("MessageApi::VoteToPollTask failed", e);
        }
    }

    @Override
    public <Message extends AbstractMessageGenerated<Message>> boolean deleteMessagesLocallyDbTask(List<Message> messageList) {
        return MessageDeletionHelper.deleteMessagesDbTask(messageList, false);
    }

    @Override
    public <Message extends ReceivedMessageGenerated<Message>, MessageDao extends ReceivedMessageDao<Message, ?, ?>, Attachment extends ReceivedAttachmentGenerated<Attachment>, AttachmentDao extends ReceivedAttachmentDao<Message, Attachment>> void updateAttachmentCountsAndLinkPreviewInfo(Message message, MessageDao messageDao, AttachmentDao attachmentDao) {
        int totalCount = 0;
        int imageCount = 0;
        Optional<LinkPreviewInfo> linkPreviewInfo = Optional.empty();
        for (ReceivedAttachmentGenerated attachment : attachmentDao.getAttachmentsForMessage(message.getItemId())) {
            String type = AttachmentUtils.getNonNullMimeType(attachment);
            if (ImageUtils.isImage(type)) {
                ++imageCount;
            }
            if (ImageUtils.isLink(type)) {
                linkPreviewInfo = LinkPreviewInfo.of(List.of(attachment));
            }
            ++totalCount;
        }
        messageDao.updateAttachmentCount(message, totalCount, imageCount);
        messageDao.updateLinkPreviewInfo(message.getItemId(), linkPreviewInfo);
    }

    @Override
    public void refreshOutboundStatus(Id<OutboundMessage> messageId) {
        OutboundMessage message = DbManager.getInstance().getOutboundMessageDao().get(messageId);
        if (message == null) {
            logger.error("MessageApi: refreshStatus: message not found " + String.valueOf(messageId));
            return;
        }
        switch (message.getStatus()) {
            case FAILED: 
            case UNDELIVERED: 
            case NO_CONTACT_RECIPIENTS: 
            case DRAFT: {
                return;
            }
        }
        List<MessageRecipientInfo> messageRecipientInfos = DbManager.getInstance().getMessageRecipientInfoDao().getAllByMessage(messageId);
        if (messageRecipientInfos.isEmpty()) {
            return;
        }
        OutboundMessageGenerated.Status newStatus = this.computeMessageStatus(messageRecipientInfos);
        if (message.getStatus() == newStatus) {
            return;
        }
        DbManager.getInstance().getOutboundMessageDao().updateStatus(messageId, newStatus);
        message.setStatus(newStatus);
        if (newStatus.isLessOrEqualTo(OutboundMessageGenerated.Status.PROCESSING)) {
            return;
        }
        Optional<Id<OutboundMessageEphemeralInfo>> outboundMessageEphemeralInfoId = message.getOutboundMessageEphemeralInfoId();
        if (outboundMessageEphemeralInfoId.isEmpty()) {
            return;
        }
        OutboundMessageEphemeralInfo ephemeralInfo = DbManager.getInstance().getOutboundMessageEphemeralInfoDao().get(outboundMessageEphemeralInfoId.get());
        boolean shouldScheduleVisibilityExpiration = ephemeralInfo.getVisibilityDuration().isPresent() && ephemeralInfo.getVisibilityTimestamp().isEmpty();
        boolean shouldScheduleExistenceExpiration = ephemeralInfo.getExistenceDuration().isPresent() && ephemeralInfo.getExistenceTimestamp().isEmpty();
        boolean isReadOnce = ephemeralInfo.isReadOnce();
        if (shouldScheduleVisibilityExpiration || shouldScheduleExistenceExpiration || isReadOnce) {
            AsyncTaskExecutor.submitTask(new ExpiringOutboundMessageSentTask(message));
        }
    }

    private OutboundMessageGenerated.Status computeMessageStatus(List<MessageRecipientInfo> infos) {
        int recipientCount = 0;
        int sentCount = 0;
        int deliveredCount = 0;
        int readCount = 0;
        Set<Id<IdentityRef>> ownedIdentityRefs = DbManager.getInstance().getIdentityRefDao().getAllOwnedIdentityRefs();
        for (MessageRecipientInfo info : infos) {
            if (infos.size() > 1 && ownedIdentityRefs.contains(info.getRecipientRefId())) continue;
            ++recipientCount;
            if (info.getTimestamp(MessageRecipientInfo.Status.SENT).isPresent()) {
                ++sentCount;
            }
            if (info.getTimestamp(MessageRecipientInfo.Status.DELIVERED).isPresent()) {
                ++deliveredCount;
            }
            if (!info.getTimestamp(MessageRecipientInfo.Status.READ).isPresent()) continue;
            ++readCount;
        }
        if (sentCount < recipientCount) {
            return OutboundMessageGenerated.Status.PROCESSING;
        }
        if (deliveredCount == 0) {
            return OutboundMessageGenerated.Status.SENT;
        }
        if (deliveredCount < recipientCount) {
            assert (recipientCount > 0);
            if (readCount == 0) {
                return OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_NOT_READ;
            }
            assert (readCount < recipientCount);
            return OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_PARTIALLY_READ;
        }
        assert (deliveredCount == recipientCount);
        if (readCount == 0) {
            if (recipientCount == 1) {
                return OutboundMessageGenerated.Status.DELIVERED;
            }
            return OutboundMessageGenerated.Status.FULLY_DELIVERED_NOT_READ;
        }
        if (readCount < recipientCount) {
            assert (recipientCount > 0);
            return OutboundMessageGenerated.Status.FULLY_DELIVERED_PARTIALLY_READ;
        }
        assert (readCount == recipientCount);
        if (recipientCount == 1) {
            return OutboundMessageGenerated.Status.DELIVERED_AND_READ;
        }
        return OutboundMessageGenerated.Status.FULLY_DELIVERED_FULLY_READ;
    }

    @Override
    public boolean forwardMessage(AbstractUserMessageGenerated<?> message, List<Id<Discussion>> discussions) {
        return new ForwardMessageTask(message, discussions).getAsBoolean();
    }

    private void sendMessageReturnReceipt(ReceivedMessageGenerated<?> message, ReturnReceiptStatus status, Optional<Integer> attachmentIndex) {
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
        byte[] senderIdentifier = message instanceof InboundMessage ? DbManager.getInstance().getInboundMessageDao().getSenderIdentifier((InboundMessage)message) : ownedIdentity.getBytesOwnedIdentity();
        EngineWrapper.getInstance().sendReturnReceipt(ownedIdentity.getBytesOwnedIdentity(), senderIdentifier, status, message.getReturnReceiptNonce(), message.getReturnReceiptKey(), attachmentIndex.orElse(null));
    }

    @Override
    public void sendMessageReturnReceipt(ReceivedMessageGenerated<?> message, ReturnReceiptStatus status) {
        AsyncTaskExecutor.submitTask(() -> this.sendMessageReturnReceipt(message, status, Optional.empty()));
    }

    @Override
    public void sendAttachmentReturnReceipt(ReceivedMessageGenerated<?> message, ReturnReceiptStatus status, int attachmentNumber) {
        AsyncTaskExecutor.submitTask(() -> this.sendMessageReturnReceipt(message, status, Optional.of(attachmentNumber)));
    }

    @Override
    public void markMessageForDeletion(ObvMessage message) {
        AsyncTaskExecutor.submitTask(() -> EngineWrapper.getInstance().markMessageForDeletion(message.getBytesToIdentity(), message.getIdentifier()));
    }
}

