/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.GroupApi;
import io.olvid.windows.messenger.engine.api.GroupCreationInterface;
import io.olvid.windows.messenger.engine.api.GroupUpdateInput;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class GroupV1ApiImpl
implements GroupApi,
GroupCreationInterface {
    GroupV1ApiImpl() {
    }

    @Override
    public boolean createGroup(byte[] bytesOwnedIdentity, Optional<String> groupName, Optional<String> groupDescription, Optional<String> groupAbsolutePhotoUrl, Set<String> ownPermissionsAsStrings, Map<BytesKey, Set<String>> otherGroupMembers, String serializedGroupType) {
        byte[][] bytesContactIdentities;
        if (bytesOwnedIdentity == null) {
            AppLogger.e("GroupManagementService: createGroup: invalid parameter given: bytesOwnedIdentity");
            return false;
        }
        if (!GroupHelper.isGroupNameCompliant(false, groupName)) {
            AppLogger.e("GroupManagementService: createGroup: invalid parameter given: name not compliant");
            return false;
        }
        JsonGroupDetails jsonGroupDetails = new JsonGroupDetails();
        groupName.ifPresent(s -> jsonGroupDetails.setName(s.trim()));
        groupDescription.ifPresent(s -> jsonGroupDetails.setDescription(s.trim()));
        JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto = new JsonGroupDetailsWithVersionAndPhoto();
        jsonGroupDetailsWithVersionAndPhoto.setVersion(0);
        jsonGroupDetailsWithVersionAndPhoto.setGroupDetails(jsonGroupDetails);
        if (otherGroupMembers == null) {
            bytesContactIdentities = new byte[][]{};
        } else {
            bytesContactIdentities = new byte[otherGroupMembers.size()][];
            int i = 0;
            for (BytesKey contactsBytes : otherGroupMembers.keySet()) {
                bytesContactIdentities[i] = contactsBytes.bytes;
                ++i;
            }
        }
        try {
            String serializedGroupDetailsWithVersionAndPhoto = EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)jsonGroupDetailsWithVersionAndPhoto);
            EngineWrapper.getInstance().startGroupCreationProtocol(serializedGroupDetailsWithVersionAndPhoto, groupAbsolutePhotoUrl.orElse(null), bytesOwnedIdentity, bytesContactIdentities);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupManagementService: createGroup: exception", e);
            return false;
        }
    }

    @Override
    public boolean updateGroup(GroupUpdateInput groupUpdateInput) {
        if (groupUpdateInput == null) {
            AppLogger.e("GroupManagementService: updateGroup failed : null input");
            return false;
        }
        boolean syncRet = false;
        if (!(groupUpdateInput.identitiesToRemove().isEmpty() && groupUpdateInput.permissionChanges().isEmpty() && groupUpdateInput.permissionsPerNewMembers().isEmpty())) {
            syncRet = this.updateGroupMembers(groupUpdateInput.ownedIdentityBytes(), groupUpdateInput.groupIdentifier(), groupUpdateInput.identitiesToRemove(), groupUpdateInput.permissionChanges(), groupUpdateInput.permissionsPerNewMembers());
            AppLogger.d("GroupManagementService: updateGroupMembers call done");
        }
        AppLogger.d("GroupManagementService: updateGroupDetails call done");
        return syncRet |= this.updateGroupDetails(groupUpdateInput.ownedIdentityBytes(), groupUpdateInput.groupIdentifier(), groupUpdateInput.name(), groupUpdateInput.description(), groupUpdateInput.absolutePhotoUrl());
    }

    @Override
    public boolean updateGroupMembers(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Set<BytesKey> identitiesToRemove, Map<BytesKey, Set<String>> permissionChanges, Map<BytesKey, Set<String>> permissionsPerNewMembers) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV1ApiImpl: updateGroupMembers: invalid parameter given: ");
            return false;
        }
        if (!identitiesToRemove.isEmpty()) {
            this.removeMembers(bytesOwnedIdentity, groupIdentifier, identitiesToRemove);
        }
        if (permissionsPerNewMembers != null && !permissionsPerNewMembers.isEmpty()) {
            HashSet<BytesKey> bytesMembersToAdd = new HashSet<BytesKey>(permissionsPerNewMembers.size());
            bytesMembersToAdd.addAll(permissionsPerNewMembers.keySet());
            this.addMembers(bytesOwnedIdentity, groupIdentifier, bytesMembersToAdd);
        }
        return false;
    }

    @Override
    public boolean updateGroupDetails(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Optional<String> groupName, Optional<String> description, Optional<String> photoUrl) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV1ApiImpl: updateGroupDetails: invalid parameter given: ");
            return false;
        }
        if (!GroupHelper.isGroupNameCompliant(false, groupName)) {
            AppLogger.e("GroupV1ApiImpl: updateGroupDetails: invalid name for groupV1");
            return false;
        }
        try {
            if (groupName.isPresent() || description.isPresent()) {
                JsonGroupDetails jsonGroupDetails = new JsonGroupDetails();
                JsonGroupDetailsWithVersionAndPhoto[] jsonGroupDetailsWithVersionAndPhotosArray = EngineWrapper.getInstance().getGroupPublishedAndLatestOrTrustedDetails(bytesOwnedIdentity, groupIdentifier);
                if (jsonGroupDetailsWithVersionAndPhotosArray == null) {
                    return false;
                }
                JsonGroupDetailsWithVersionAndPhoto publishedJsonGroupDetailsWithVersionAndPhoto = jsonGroupDetailsWithVersionAndPhotosArray[0];
                JsonGroupDetails publishedGroupDetails = publishedJsonGroupDetailsWithVersionAndPhoto.getGroupDetails();
                jsonGroupDetails.setDescription(description.orElse(publishedGroupDetails.getDescription()));
                jsonGroupDetails.setName(groupName.orElse(publishedGroupDetails.getName()));
                EngineWrapper.getInstance().updateLatestGroupDetails(bytesOwnedIdentity, groupIdentifier, jsonGroupDetails);
            }
            if (photoUrl.isPresent()) {
                EngineWrapper.getInstance().updateOwnedGroupPhoto(bytesOwnedIdentity, groupIdentifier, photoUrl.get());
            }
            EngineWrapper.getInstance().publishLatestGroupDetails(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (JsonProcessingException e) {
            AppLogger.e("GroupV1ApiImpl: updateGroupDetails: couldn't deserialize json group details", (Exception)((Object)e));
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: updateGroupDetails: engine exception", e);
        }
        return false;
    }

    @Override
    public boolean updateGroupPhoto(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Optional<String> photoUrl) {
        if (bytesOwnedIdentity == null || groupIdentifier == null || photoUrl.isPresent() && photoUrl.get().isEmpty()) {
            AppLogger.e("GroupV1ApiImpl: updateGroupPhoto: invalid parameter given: ");
            return false;
        }
        try {
            EngineWrapper.getInstance().updateOwnedGroupPhoto(bytesOwnedIdentity, groupIdentifier, photoUrl.orElse(null));
            EngineWrapper.getInstance().publishLatestGroupDetails(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: updateGroupPhoto: engine exception", e);
            return false;
        }
    }

    @Override
    public boolean trustDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) {
        if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
            AppLogger.e("GroupV1ApiImpl: disbandGroup: invalid parameter");
            return false;
        }
        try {
            EngineWrapper.getInstance().trustPublishedGroupDetails(bytesOwnedIdentity, bytesGroupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: disbandGroup: engine exception", e);
            return false;
        }
    }

    @Override
    public boolean disbandGroup(byte[] bytesOwnedIdentity, byte[] groupIdentifier) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV1ApiImpl: disbandGroup: invalid parameter");
            return false;
        }
        try {
            EngineWrapper.getInstance().disbandGroup(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: disbandGroup: engine exception", e);
            return false;
        }
    }

    @Override
    public boolean leaveGroup(byte[] bytesOwnedIdentity, byte[] groupIdentifier) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV1ApiImpl: leaveGroup: invalid parameter");
            return false;
        }
        try {
            EngineWrapper.getInstance().leaveGroup(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: leaveGroup: engine exception", e);
            return false;
        }
    }

    @Override
    public boolean refreshGroup(byte[] bytesOwnedIdentity, byte[] groupIdentifier) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV1ApiImpl: leaveGroup: invalid parameter given");
            return false;
        }
        try {
            EngineWrapper.getInstance().getGroupPublishedAndLatestOrTrustedDetails(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: leaveGroup: engine exception", e);
            return false;
        }
    }

    public static boolean removeGroupPhoto(Id<Group> groupId) {
        if (groupId == null) {
            AppLogger.e("GroupV1ApiImpl: removeGroupPhoto: invalid parameter given: ");
            return false;
        }
        if (GroupHelper.isOwnedIdentityAdmin(groupId)) {
            try {
                Group group = DbManager.getInstance().getGroupDao().get(groupId);
                OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(group.getOwnedIdentityId());
                EngineWrapper.getInstance().updateOwnedGroupPhoto(ownedIdentity.getBytesOwnedIdentity(), group.getBytesGroupIdentifier(), null);
                EngineWrapper.getInstance().publishLatestGroupDetails(ownedIdentity.getBytesOwnedIdentity(), group.getBytesGroupIdentifier());
                return true;
            }
            catch (Exception e) {
                AppLogger.e("GroupV1ApiImpl: removeGroupPhoto: engine exception", e);
                return false;
            }
        }
        AsyncTaskExecutor.submitTask(() -> DbManager.getInstance().getGroupDao().updateCustomPhotoUrl(groupId, null));
        return true;
    }

    private boolean addMembers(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Set<BytesKey> contactsToAdd) {
        if (contactsToAdd == null) {
            AppLogger.e("GroupV1ApiImpl: addMember: invalid parameter given");
            return false;
        }
        if (contactsToAdd.isEmpty()) {
            AppLogger.d("GroupV1ApiImpl: removeMember: contactsToAdd collection is empty");
        }
        byte[][] bytesContactsToAdd = new byte[contactsToAdd.size()][];
        int i = 0;
        for (BytesKey bytesContact : contactsToAdd) {
            bytesContactsToAdd[i] = bytesContact.bytes;
            ++i;
        }
        try {
            EngineWrapper.getInstance().inviteContactsToGroup(bytesOwnedIdentity, groupIdentifier, bytesContactsToAdd);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: addMember: engine exception", e);
            return false;
        }
    }

    private boolean removeMembers(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Set<BytesKey> contactsToDelete) {
        if (contactsToDelete == null) {
            AppLogger.e("GroupV1ApiImpl: removeMember: invalid parameter given");
            return false;
        }
        if (contactsToDelete.isEmpty()) {
            AppLogger.d("GroupV1ApiImpl: removeMember: contactsToDelete collection is empty");
        }
        byte[][] bytesContactsToDelete = new byte[contactsToDelete.size()][];
        int i = 0;
        for (BytesKey contactBytes : contactsToDelete) {
            bytesContactsToDelete[i] = contactBytes.bytes;
            ++i;
        }
        try {
            EngineWrapper.getInstance().removeContactsFromGroup(bytesOwnedIdentity, groupIdentifier, bytesContactsToDelete);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV1ApiImpl: removeMember: engine exception", e);
            return false;
        }
    }
}

