/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.ObvDeviceList;
import io.olvid.engine.engine.types.ObvDeviceManagementRequest;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.DeviceApi;
import io.olvid.windows.messenger.logger.AppLogger;

public class DeviceApiImpl
implements DeviceApi {
    @Override
    public boolean hasMultiDevice(byte[] bytesOwnedIdentity) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            ObvDeviceList obvDeviceList = engine.queryRegisteredOwnedDevicesFromServer(bytesOwnedIdentity);
            return obvDeviceList != null && obvDeviceList.multiDevice != false;
        }
        catch (Exception e) {
            AppLogger.e("Failed to check if a owned identity has multi device", e);
            return false;
        }
    }

    @Override
    public void recreateOwnedDeviceChannel(byte[] bytesOwnedIdentity, byte[] bytesOwnedDeviceUuid, boolean isCurrentDevice) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        if (isCurrentDevice) {
            AppLogger.e("DeviceApiImpl::recreateOwnedDeviceChannel cannot recreate channel for current device");
            return;
        }
        try {
            engine.recreateOwnedDeviceChannel(bytesOwnedIdentity, bytesOwnedDeviceUuid);
        }
        catch (Exception e) {
            AppLogger.e("Failed to recreate owned device channel", e);
        }
    }

    @Override
    public void renameOwnedDevice(byte[] bytesOwnedIdentity, byte[] bytesOwnedDeviceUuid, String nickname) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            ObvDeviceManagementRequest obv = ObvDeviceManagementRequest.createSetNicknameRequest((byte[])bytesOwnedDeviceUuid, (String)nickname);
            engine.processDeviceManagementRequest(bytesOwnedIdentity, obv);
        }
        catch (Exception e) {
            AppLogger.e("Failed to process device management request", e);
        }
    }

    @Override
    public void deactivateOwnedDevice(byte[] bytesOwnedIdentity, byte[] bytesOwnedDeviceUuid) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            ObvDeviceManagementRequest obv = ObvDeviceManagementRequest.createDeactivateDeviceRequest((byte[])bytesOwnedDeviceUuid);
            engine.processDeviceManagementRequest(bytesOwnedIdentity, obv);
        }
        catch (Exception e) {
            AppLogger.e("Failed to process device management request", e);
        }
    }

    @Override
    public void setUnexpiringOwnedDevice(byte[] bytesOwnedIdentity, byte[] bytesOwnedDeviceUuid) {
        Engine engine = EngineWrapper.getInstance().getEngineInstance();
        try {
            ObvDeviceManagementRequest obv = ObvDeviceManagementRequest.createSetUnexpiringDeviceRequest((byte[])bytesOwnedDeviceUuid);
            engine.processDeviceManagementRequest(bytesOwnedIdentity, obv);
        }
        catch (Exception e) {
            AppLogger.e("Failed to process device management request", e);
        }
    }
}

