/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.ContactApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.List;
import java.util.Objects;

public class ContactApiImpl
implements ContactApi {
    @Override
    public boolean downgradeOneToOneContact(Contact contact) {
        Objects.requireNonNull(contact);
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(contact.getOwnedIdentityId());
        Capabilities capabilities = DbManager.getInstance().getCapabilitiesDao().get(contact.getCapabilitiesId());
        if (ownedIdentity == null) {
            AppLogger.e("ContactService::downgradeOneToOneContact: cannot find OwnedIdentity ");
            return false;
        }
        if (capabilities != null && contact.isOneToOne() && capabilities.isOneToOneContacts()) {
            try {
                EngineWrapper.getInstance().downgradeOneToOneContact(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
                return true;
            }
            catch (Exception e) {
                AppLogger.e("ContactApi::downgradeOneToOneContact engine exception", e);
            }
        } else {
            return this.deleteContact(contact);
        }
        return false;
    }

    @Override
    public boolean deleteContact(Contact contact) {
        boolean isMemberOfGroup;
        Objects.requireNonNull(contact);
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(contact.getOwnedIdentityId());
        if (ownedIdentity == null) {
            AppLogger.e("ContactApi::deleteContact cannot find Capabilities");
            return false;
        }
        List<Group> groupsV1WithContact = DbManager.getInstance().getGroupDao().getAllGroupsWithSpecificContact((Id<Contact>)contact.getItemId(), false).stream().filter(g -> g.getVersion() == GroupGenerated.Version.VERSION_1).toList();
        List<Group> groupsV2WithContact = DbManager.getInstance().getGroupDao().getAllGroupsWithSpecificContact((Id<Contact>)contact.getItemId(), true).stream().filter(g -> g.getVersion() == GroupGenerated.Version.VERSION_2).toList();
        boolean bl = isMemberOfGroup = !groupsV1WithContact.isEmpty() || !groupsV2WithContact.isEmpty();
        if (isMemberOfGroup) {
            AppLogger.w("ContactApi::deleteContact: Unable to delete contact, still in some groups");
            return false;
        }
        try {
            EngineWrapper.getInstance().deleteContact(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
            return true;
        }
        catch (Exception e) {
            AppLogger.e("ContactApi::deleteContact engine exception", e);
            return false;
        }
    }
}

