/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.engine.engine.types.ObvBackupKeyInformation;
import io.olvid.engine.engine.types.ObvBackupKeyVerificationOutput;
import io.olvid.engine.engine.types.ObvDeviceBackupForRestore;
import io.olvid.engine.engine.types.ObvProfileBackupsForRestore;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshot;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.BackupApi;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ByteArray;
import java.util.Objects;
import java.util.Optional;

public class BackupApiImpl
implements BackupApi {
    AppLogger logger = new AppLogger(BackupApiImpl.class);

    @Override
    public void initiateBackup(boolean forExport) {
        EngineWrapper.getInstance().getEngineInstance().initiateBackup(forExport);
    }

    @Override
    public Optional<String> generateDeviceBackupSeed(String server) {
        Objects.requireNonNull(server);
        return Optional.ofNullable(EngineWrapper.getInstance().getEngineInstance().generateDeviceBackupSeed(server));
    }

    @Override
    public Optional<String> getDeviceBackupSeed() {
        Optional<String> seedOpt = Optional.empty();
        try {
            seedOpt = Optional.ofNullable(EngineWrapper.getInstance().getEngineInstance().getDeviceBackupSeed());
        }
        catch (Exception e) {
            this.logger.error("BackupApiImpl::getDeviceBackupSeed Couldn't get backup seed");
        }
        return seedOpt;
    }

    @Override
    public void deleteDeviceBackupSeed(String deviceBackupSeed) {
        Objects.requireNonNull(deviceBackupSeed);
        EngineWrapper.getInstance().getEngineInstance().deleteDeviceBackupSeed(deviceBackupSeed);
    }

    @Override
    public boolean backupDeviceAndProfilesNow() {
        return EngineWrapper.getInstance().getEngineInstance().backupDeviceAndProfilesNow();
    }

    @Override
    public void deviceBackupNeeded() {
        EngineWrapper.getInstance().getEngineInstance().deviceBackupNeeded();
    }

    @Override
    public void profileBackupNeeded(byte[] bytesOwnedIdentity) {
        Objects.requireNonNull(bytesOwnedIdentity);
        EngineWrapper.getInstance().getEngineInstance().profileBackupNeeded(bytesOwnedIdentity);
    }

    @Override
    public ObvDeviceBackupForRestore fetchDeviceBackup(String server, String deviceBackupSeed) {
        Objects.requireNonNull(server, deviceBackupSeed);
        return EngineWrapper.getInstance().getEngineInstance().fetchDeviceBackup(server, deviceBackupSeed);
    }

    @Override
    public ObvProfileBackupsForRestore fetchProfileBackups(byte[] bytesIdentity, String profileBackupSeed) {
        Objects.requireNonNull(bytesIdentity);
        Objects.requireNonNull(profileBackupSeed);
        return EngineWrapper.getInstance().getEngineInstance().fetchProfileBackups(bytesIdentity, profileBackupSeed);
    }

    @Override
    public boolean deleteProfileBackupSnapshot(byte[] bytesIdentity, String profileBackupSeed, byte[] threadId, long version) {
        Objects.requireNonNull(bytesIdentity);
        Objects.requireNonNull(profileBackupSeed);
        Objects.requireNonNull(threadId);
        return EngineWrapper.getInstance().getEngineInstance().deleteProfileBackupSnapshot(bytesIdentity, profileBackupSeed, threadId, version);
    }

    @Override
    public ByteArray downloadProfilePicture(byte[] bytesIdentity, byte[] photoLabel, byte[] photoKey) throws Exception {
        Objects.requireNonNull(bytesIdentity);
        Objects.requireNonNull(photoLabel);
        Objects.requireNonNull(photoKey);
        return new ByteArray(EngineWrapper.getInstance().getEngineInstance().downloadProfilePicture(bytesIdentity, photoLabel, photoKey));
    }

    @Override
    public boolean restoreProfile(ObvSyncSnapshot snapshot, String deviceName, Optional<String> serializedKeycloakAuthState) {
        Objects.requireNonNull(snapshot);
        Objects.requireNonNull(deviceName);
        return EngineWrapper.getInstance().getEngineInstance().restoreProfile(snapshot, deviceName, (String)serializedKeycloakAuthState.orElse(null));
    }

    @Override
    public Optional<ObvBackupKeyInformation> getBackupKeyInformation() {
        try {
            return Optional.ofNullable(EngineWrapper.getInstance().getEngineInstance().getBackupKeyInformation());
        }
        catch (Exception e) {
            this.logger.error("BackupApiImpl::getBackupKeyInformation Couldn't get back key information", e);
            return Optional.empty();
        }
    }

    @Override
    public void stopLegacyBackups() {
        EngineWrapper.getInstance().getEngineInstance().stopLegacyBackups();
    }

    @Override
    public void setAutoBackupEnabled(boolean enabled, boolean initiateBackupNowIfNeeded) {
        EngineWrapper.getInstance().getEngineInstance().setAutoBackupEnabled(enabled, initiateBackupNowIfNeeded);
    }

    @Override
    public void markBackupExported(byte[] backupKeyUid, int version) {
        Objects.requireNonNull(backupKeyUid);
        EngineWrapper.getInstance().getEngineInstance().markBackupExported(backupKeyUid, version);
    }

    @Override
    public void markBackupUploaded(byte[] backupKeyUid, int version) {
        Objects.requireNonNull(backupKeyUid);
        EngineWrapper.getInstance().getEngineInstance().markBackupUploaded(backupKeyUid, version);
    }

    @Override
    public void discardBackup(byte[] backupKeyUid, int version) {
        Objects.requireNonNull(backupKeyUid);
        EngineWrapper.getInstance().getEngineInstance().discardBackup(backupKeyUid, version);
    }

    @Override
    public Optional<ObvBackupKeyVerificationOutput> validateBackupSeed(String backupSeed, byte[] backupContent) {
        Objects.requireNonNull(backupSeed);
        return Optional.ofNullable(EngineWrapper.getInstance().getEngineInstance().validateBackupSeed(backupSeed, backupContent));
    }

    @Override
    public Optional<ObvIdentity[]> restoreOwnedIdentitiesFromBackup(String backupSeed, byte[] backupContent, String deviceDisplayName) {
        Objects.requireNonNull(backupSeed);
        Objects.requireNonNull(backupContent);
        Objects.requireNonNull(deviceDisplayName);
        return Optional.ofNullable(EngineWrapper.getInstance().getEngineInstance().restoreOwnedIdentitiesFromBackup(backupSeed, backupContent, deviceDisplayName));
    }

    @Override
    public void restoreContactsAndGroupsFromBackup(String backupSeed, byte[] backupContent, ObvIdentity[] restoredOwnedIdentities) {
        Objects.requireNonNull(backupSeed);
        Objects.requireNonNull(backupContent);
        Objects.requireNonNull(restoredOwnedIdentities);
        EngineWrapper.getInstance().getEngineInstance().restoreContactsAndGroupsFromBackup(backupSeed, backupContent, restoredOwnedIdentities);
    }

    @Override
    public Optional<String> decryptAppDataBackup(String backupSeed, byte[] backupContent) {
        Objects.requireNonNull(backupSeed);
        Objects.requireNonNull(backupContent);
        return Optional.ofNullable(EngineWrapper.getInstance().getEngineInstance().decryptAppDataBackup(backupSeed, backupContent));
    }

    @Override
    public void appBackupSuccess(byte[] bytesBackupKeyUid, int version, String appBackupContent) {
        Objects.requireNonNull(bytesBackupKeyUid);
        Objects.requireNonNull(appBackupContent);
        EngineWrapper.getInstance().getEngineInstance().appBackupSuccess(bytesBackupKeyUid, version, appBackupContent);
    }

    @Override
    public void appBackupFailed(byte[] bytesBackupKeyUid, int version) {
        Objects.requireNonNull(bytesBackupKeyUid);
        EngineWrapper.getInstance().getEngineInstance().appBackupFailed(bytesBackupKeyUid, version);
    }
}

