/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.engine.engine.types.ObvAttachment;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.dao.attachment.ReceivedAttachmentDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.AttachmentApi;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteDraftAttachmentsDbTask;
import io.olvid.windows.messenger.logger.AppLogger;

class AttachmentApiImpl
implements AttachmentApi {
    AttachmentApiImpl() {
    }

    @Override
    public <Attachment extends ReceivedAttachmentGenerated<Attachment>> boolean downloadLargeAttachment(byte[] bytesOwnedIdentity, Id<Attachment> attachmentId, byte[] engineMessageIdentifier, int engineNumber) {
        if (engineMessageIdentifier == null) {
            return false;
        }
        EngineWrapper.getInstance().downloadLargeAttachment(bytesOwnedIdentity, engineMessageIdentifier, engineNumber);
        AppLogger.d("AttachmentApi: downloadLargeAttachment: requested engine downloadLargeAttachment()");
        ReceivedAttachmentDao receivedAttachmentDao = DbManager.getInstance().getReceivedAttachmentDao(attachmentId);
        if (receivedAttachmentDao.updateAttachmentStatus(attachmentId, ReceivedAttachmentGenerated.Status.DOWNLOADING)) {
            AppLogger.d("AttachmentApi: downloadLargeAttachment: updated attachment in db app");
            return true;
        }
        AppLogger.d("AttachmentApi: downloadLargeAttachment: couldn't update attachment in db app...sync needed");
        AppLogger.e("AttachmentApi: downloadLargeAttachment: Something went wrong requesting large attachment download...");
        return false;
    }

    @Override
    public boolean deleteDraftOrCopyingAttachmentDbTask(Id<OutboundAttachment> draftAttachmentId) {
        OutboundAttachment draftAttachment = DbManager.getInstance().getOutboundAttachmentDao().get(draftAttachmentId);
        if (draftAttachment != null) {
            new DeleteDraftAttachmentsDbTask(draftAttachment).run();
            AppLogger.i("AttachmentApi: deleteDraftOrCopyingAttachmentDbTask: request taken into account");
            return true;
        }
        AppLogger.e("AttachmentApi: deleteDraftOrCopyingAttachmentDbTask: Couldn't get attach\u00f9ent to delete...");
        return false;
    }

    @Override
    public void markAttachmentForDeletion(ObvAttachment attachment) {
        AsyncTaskExecutor.submitTask(() -> EngineWrapper.getInstance().markAttachmentForDeletion(attachment.getBytesOwnedIdentity(), attachment.getMessageIdentifier(), attachment.getNumber()));
    }

    @Override
    public void markAttachmentForDeletion(OwnedIdentity ownedIdentity, ReceivedAttachmentGenerated<?> attachment) {
        AsyncTaskExecutor.submitTask(() -> EngineWrapper.getInstance().markAttachmentForDeletion(ownedIdentity.getBytesOwnedIdentity(), attachment.getEngineMessageIdentifier(), attachment.getIdx()));
    }
}

