/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.EngineNotificationListener;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.ObvAttachment;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.ObvContactDeviceCount;
import io.olvid.engine.engine.types.ObvDeviceList;
import io.olvid.engine.engine.types.ObvDeviceManagementRequest;
import io.olvid.engine.engine.types.ObvDialog;
import io.olvid.engine.engine.types.ObvOutboundAttachment;
import io.olvid.engine.engine.types.ObvPostMessageOutput;
import io.olvid.engine.engine.types.ObvPushNotificationType;
import io.olvid.engine.engine.types.ObvReturnReceipt;
import io.olvid.engine.engine.types.RegisterApiKeyResult;
import io.olvid.engine.engine.types.identities.ObvGroup;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import io.olvid.engine.engine.types.identities.ObvTrustOrigin;
import io.olvid.engine.engine.types.identities.ObvUrlIdentity;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.secure_io.KeyManagerSingleton;
import io.olvid.engine.secure_io.SeedHandler;
import io.olvid.windows.messenger.engine.helpers.message.ReturnReceiptStatus;
import io.olvid.windows.messenger.engine.notifications.MasterNotificationListener;
import io.olvid.windows.messenger.engine.sync.AppBackupAndSyncDelegate;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.jose4j.jwk.JsonWebKey;

public class EngineWrapper {
    private Engine engineInstance;
    private AppLogger loggerInstance;
    private static EngineWrapper wrapperInstance;
    private static final ObjectMapper jsonObjectMapper;
    private MasterNotificationListener masterNotificationListener;

    private EngineWrapper() {
    }

    private void createEngineInstance(Callable<String> getDataDir) {
        AppLogger engineLogger = new AppLogger(Engine.class);
        boolean toStore = false;
        String appDbKey = AppRuntimeHelper.isDataBaseEncrypted ? KeyManagerSingleton.getInstance().getDbEncryptionKey(SeedHandler.EncryptionSeedType.ENGINE_DATABASE) : null;
        if (AppRuntimeHelper.isDebugMode) {
            this.loggerInstance.info("Engine DB key : " + appDbKey);
        }
        try {
            ObvCapability.currentCapabilities.add(ObvCapability.WEBRTC_CONTINUOUS_ICE);
            this.engineInstance = new Engine(new File(getDataDir.call()), (ObvBackupAndSyncDelegate)new AppBackupAndSyncDelegate(), appDbKey, null, null, (Logger.LogOutputter)engineLogger, 0);
            this.loggerInstance.debug("Engine created");
        }
        catch (Exception e) {
            this.loggerInstance.error("Ooops couldn't start olvid engine", e);
            throw new RuntimeException();
        }
    }

    public static synchronized EngineWrapper getInstance() {
        if (wrapperInstance == null) {
            wrapperInstance = new EngineWrapper();
        }
        return wrapperInstance;
    }

    public void init(Callable<String> getDataDir) {
        if (this.engineInstance != null) {
            this.loggerInstance.error("EngineWrapper::init engine instance already created");
            return;
        }
        this.loggerInstance = new AppLogger(EngineWrapper.class);
        if (getDataDir == null) {
            this.loggerInstance.error("EngineWrapper::createEngineInstance() getDataDir arg is null, you can't have that");
            throw new RuntimeException();
        }
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
        this.createEngineInstance(getDataDir);
        try {
            ObvIdentity ownedObvIdentity;
            ObvIdentity[] obvIdentities = this.engineInstance.getOwnedIdentities();
            if (obvIdentities.length != 0 && (ownedObvIdentity = obvIdentities[0]) != null) {
                ObvUrlIdentity url = new ObvUrlIdentity(ownedObvIdentity.getBytesIdentity(), ownedObvIdentity.getIdentityDetails().formatDisplayName("%f %l (%p @ %c)", false));
                this.loggerInstance.debug(url.getUrlRepresentation(false));
            }
        }
        catch (Exception e) {
            this.loggerInstance.error("Couldn't retrieve obvIdentities from engine : " + e.getMessage());
        }
        this.masterNotificationListener = new MasterNotificationListener(this.engineInstance);
        this.engineInstance.connectWebsocket(true, AppRuntimeHelper.OS_NAME, AppRuntimeHelper.OS_VERSION, AppRuntimeHelper.buildVersion, AppRuntimeHelper.appVersion);
        this.engineInstance.startSendingNotifications();
        try {
            this.engineInstance.resendAllPersistedDialogs();
        }
        catch (Exception e) {
            AppLogger.e("Unable to resend all engine persistent dialogs", e);
        }
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Engine getEngineInstance() {
        this.checkEngine();
        return this.engineInstance;
    }

    public static ObjectMapper getJsonObjectMapper() {
        return jsonObjectMapper;
    }

    public void clearEngine() {
    }

    public void connectWebsocket() {
        this.checkEngine();
        this.engineInstance.connectWebsocket(false, null, null, 0, null);
    }

    public ObvIdentity[] getOwnedIdentities() throws Exception {
        this.checkEngine();
        return this.engineInstance.getOwnedIdentities();
    }

    private ObvPushNotificationType getObvPushNotificationType() {
        if (AppRuntimeHelper.isWindows()) {
            return ObvPushNotificationType.createWindows();
        }
        return ObvPushNotificationType.createLinux();
    }

    public boolean registerToPushNotification(byte[] ownedIdentity, boolean reactivateCurrentDevice, byte[] bytesDeviceUidToReplace) {
        this.checkEngine();
        try {
            if (ownedIdentity != null) {
                this.engineInstance.registerToPushNotification(ownedIdentity, this.getObvPushNotificationType(), reactivateCurrentDevice, bytesDeviceUidToReplace);
            }
            return true;
        }
        catch (Exception e) {
            this.loggerInstance.error("registerToPushNotification");
            this.loggerInstance.error(e.getMessage());
            return false;
        }
    }

    public ObvIdentity generateOwnedIdentity(String serverUrl, JsonIdentityDetails identityDetails, ObvKeycloakState keycloakState, String deviceDisplayName) {
        this.checkEngine();
        return this.engineInstance.generateOwnedIdentity(serverUrl, identityDetails, keycloakState, deviceDisplayName);
    }

    public RegisterApiKeyResult registerOwnedIdentityApiKeyOnServer(byte[] bytesOwnedIdentity, UUID apiKey) {
        this.checkEngine();
        return this.engineInstance.registerOwnedIdentityApiKeyOnServer(bytesOwnedIdentity, apiKey);
    }

    public void deleteOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        this.engineInstance.deleteOwnedIdentity(bytesOwnedIdentity);
    }

    public void deleteOwnedIdentityAndNotifyContacts(byte[] bytesOwnedIdentity) throws Exception {
        this.deleteOwnedIdentityAndNotifyContacts(bytesOwnedIdentity, false);
    }

    public void deleteOwnedIdentityAndNotifyContacts(byte[] bytesOwnedIdentity, boolean deleteEverywhere) throws Exception {
        this.checkEngine();
        this.engineInstance.deleteOwnedIdentityAndNotifyContacts(bytesOwnedIdentity, deleteEverywhere);
    }

    public void updateLatestIdentityDetails(byte[] bytesOwnedIdentity, JsonIdentityDetails jsonIdentityDetails) throws Exception {
        this.checkEngine();
        this.engineInstance.updateLatestIdentityDetails(bytesOwnedIdentity, jsonIdentityDetails);
    }

    public void updateOwnedIdentityPhoto(byte[] bytesOwnedIdentity, String absolutePhotoUrl) throws Exception {
        this.checkEngine();
        this.engineInstance.updateOwnedIdentityPhoto(bytesOwnedIdentity, absolutePhotoUrl);
    }

    public void discardLatestIdentityDetails(byte[] bytesOwnedIdentity) {
        this.checkEngine();
        this.engineInstance.discardLatestIdentityDetails(bytesOwnedIdentity);
    }

    public void publishLatestIdentityDetails(byte[] bytesOwnedIdentity) {
        this.checkEngine();
        this.engineInstance.publishLatestIdentityDetails(bytesOwnedIdentity);
    }

    public JsonIdentityDetailsWithVersionAndPhoto[] getOwnedIdentityPublishedAndLatestDetails(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getOwnedIdentityPublishedAndLatestDetails(bytesOwnedIdentity);
    }

    public boolean downloadUserData() {
        this.checkEngine();
        try {
            this.engineInstance.downloadAllUserData();
            return true;
        }
        catch (Exception e) {
            this.loggerInstance.error("EngineWrapper::downloadUserData couldn't launch download userdat operation");
            return false;
        }
    }

    public void resendAllPersistedDialogs() {
        this.checkEngine();
        try {
            this.engineInstance.resendAllPersistedDialogs();
        }
        catch (Exception e) {
            this.loggerInstance.error("Unable to resend persistent dialogs");
        }
    }

    public void respondToDialog(ObvDialog dialog) {
        this.checkEngine();
        try {
            this.engineInstance.respondToDialog(dialog);
        }
        catch (Exception e) {
            this.loggerInstance.error("respondToDialog");
            this.loggerInstance.error(e.getMessage());
        }
    }

    public void deletePersistedDialog(UUID uuid) {
        this.checkEngine();
        try {
            this.engineInstance.deletePersistedDialog(uuid);
        }
        catch (Exception e) {
            this.loggerInstance.error("deletePersistedDialog");
            this.loggerInstance.error(e.getMessage());
        }
    }

    public void startTrustEstablishmentProtocol(byte[] remoteIdentity, String contactDisplayName, byte[] ownedIdentity) throws Exception {
        this.checkEngine();
        this.engineInstance.startTrustEstablishmentProtocol(remoteIdentity, contactDisplayName, ownedIdentity);
    }

    public void startContactMutualIntroductionProtocol(byte[] bytesOwnedIdentity, byte[] bytesContactIdentityA, byte[][] bytesContactIdentityB) throws Exception {
        this.checkEngine();
        this.engineInstance.startContactMutualIntroductionProtocol(bytesOwnedIdentity, bytesContactIdentityA, bytesContactIdentityB);
    }

    public boolean abortProtocol(ObvDialog obvDialog) {
        this.checkEngine();
        try {
            this.engineInstance.abortProtocol(obvDialog);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("Unable to abort dialog (engine exception): " + String.valueOf(obvDialog.getUuid()), e);
            return false;
        }
    }

    public void recreateAllChannels(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        this.checkEngine();
        this.engineInstance.recreateAllChannels(bytesOwnedIdentity, bytesContactIdentity);
    }

    public ObvIdentity[] getContactsOfOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getContactsOfOwnedIdentity(bytesOwnedIdentity);
    }

    public void downgradeOneToOneContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        this.checkEngine();
        this.engineInstance.downgradeOneToOneContact(bytesOwnedIdentity, bytesContactIdentity);
    }

    public void startOneToOneInvitationProtocol(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        this.checkEngine();
        this.engineInstance.startOneToOneInvitationProtocol(bytesOwnedIdentity, bytesContactIdentity);
    }

    public void deleteContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        this.checkEngine();
        this.engineInstance.deleteContact(bytesOwnedIdentity, bytesContactIdentity);
    }

    public ObvTrustOrigin[] getContactTrustOrigins(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getContactTrustOrigins(bytesOwnedIdentity, bytesContactIdentity);
    }

    public JsonIdentityDetailsWithVersionAndPhoto[] getContactPublishedAndTrustedDetails(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        this.checkEngine();
        try {
            return this.engineInstance.getContactPublishedAndTrustedDetails(bytesOwnedIdentity, bytesContactIdentity);
        }
        catch (Exception e) {
            this.loggerInstance.error("EngineWrapper: getContactPublishedAndTrustedDetails exception", e);
            return null;
        }
    }

    public void trustPublishedContactDetails(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        this.checkEngine();
        this.engineInstance.trustPublishedContactDetails(bytesOwnedIdentity, bytesContactIdentity);
    }

    public ObvContactDeviceCount getContactDeviceCount(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getContactDeviceCounts(bytesOwnedIdentity, bytesContactIdentity);
    }

    public String getContactTrustedDetailsPhotoUrl(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        this.checkEngine();
        try {
            return this.engineInstance.getContactTrustedDetailsPhotoUrl(bytesOwnedIdentity, bytesContactIdentity);
        }
        catch (Exception e) {
            this.loggerInstance.error("EngineWrapper: getContactTrustedDetailsPhotoUrl exception", e);
            return null;
        }
    }

    public ObvGroup[] getGroupsOfOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getGroupsOfOwnedIdentity(bytesOwnedIdentity);
    }

    public void startGroupCreationProtocol(String serializedGroupDetailsWithVersionAndPhoto, String absolutePhotoUrl, byte[] bytesOwnedIdentity, byte[][] bytesRemoteIdentities) throws Exception {
        this.checkEngine();
        this.engineInstance.startGroupCreationProtocol(serializedGroupDetailsWithVersionAndPhoto, absolutePhotoUrl, bytesOwnedIdentity, bytesRemoteIdentities);
    }

    public void inviteContactsToGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, byte[][] bytesNewMemberIdentities) throws Exception {
        this.checkEngine();
        this.engineInstance.inviteContactsToGroup(bytesOwnedIdentity, bytesGroupOwnerAndUid, bytesNewMemberIdentities);
    }

    public void removeContactsFromGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, byte[][] bytesRemovedMemberIdentities) throws Exception {
        this.checkEngine();
        this.engineInstance.removeContactsFromGroup(bytesOwnedIdentity, bytesGroupOwnerAndUid, bytesRemovedMemberIdentities);
    }

    public void leaveGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) throws Exception {
        this.checkEngine();
        this.engineInstance.leaveGroup(bytesOwnedIdentity, bytesGroupOwnerAndUid);
    }

    public void disbandGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) throws Exception {
        this.checkEngine();
        this.engineInstance.disbandGroup(bytesOwnedIdentity, bytesGroupOwnerAndUid);
    }

    public void updateLatestGroupDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnedAndUid, JsonGroupDetails jsonGroupDetails) throws Exception {
        this.checkEngine();
        this.engineInstance.updateLatestGroupDetails(bytesOwnedIdentity, bytesGroupOwnedAndUid, jsonGroupDetails);
    }

    public void publishLatestGroupDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnedAndUid) {
        this.checkEngine();
        this.engineInstance.publishLatestGroupDetails(bytesOwnedIdentity, bytesGroupOwnedAndUid);
    }

    public void trustPublishedGroupDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) {
        this.checkEngine();
        this.engineInstance.trustPublishedGroupDetails(bytesOwnedIdentity, bytesGroupOwnerAndUid);
    }

    public void updateOwnedGroupPhoto(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, String absolutePhotoUrl) throws Exception {
        this.checkEngine();
        this.engineInstance.updateOwnedGroupPhoto(bytesOwnedIdentity, bytesGroupOwnerAndUid, absolutePhotoUrl);
    }

    public JsonGroupDetailsWithVersionAndPhoto[] getGroupPublishedAndLatestOrTrustedDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) throws Exception {
        this.checkEngine();
        return this.engineInstance.getGroupPublishedAndLatestOrTrustedDetails(bytesOwnedIdentity, bytesGroupOwnerAndUid);
    }

    List<ObvGroupV2> getGroupsV2OfOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getGroupsV2OfOwnedIdentity(bytesOwnedIdentity);
    }

    public void startGroupV2CreationProtocol(String serializedGroupDetails, String absolutePhotoUrl, byte[] bytesOwnedIdentity, HashSet<GroupV2.Permission> ownPermissions, HashMap<ObvBytesKey, HashSet<GroupV2.Permission>> otherGroupMembers, String serializedGroupType) throws Exception {
        this.checkEngine();
        this.engineInstance.startGroupV2CreationProtocol(serializedGroupDetails, absolutePhotoUrl, bytesOwnedIdentity, ownPermissions, otherGroupMembers, serializedGroupType);
    }

    public void trustGroupV2PublishedDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        this.checkEngine();
        this.engineInstance.trustGroupV2PublishedDetails(bytesOwnedIdentity, bytesGroupIdentifier);
    }

    public ObvGroupV2.ObvGroupV2DetailsAndPhotos getGroupV2DetailsAndPhotos(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) {
        this.checkEngine();
        return this.engineInstance.getGroupV2DetailsAndPhotos(bytesOwnedIdentity, bytesGroupIdentifier);
    }

    public void initiateGroupV2Update(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier, ObvGroupV2.ObvGroupV2ChangeSet changeSet) throws Exception {
        this.checkEngine();
        this.engineInstance.initiateGroupV2Update(bytesOwnedIdentity, bytesGroupIdentifier, changeSet);
    }

    public void leaveGroupV2(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        this.checkEngine();
        this.engineInstance.leaveGroupV2(bytesOwnedIdentity, bytesGroupIdentifier);
    }

    public void disbandGroupV2(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        this.checkEngine();
        this.engineInstance.disbandGroupV2(bytesOwnedIdentity, bytesGroupIdentifier);
    }

    public void reDownloadGroupV2(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        this.checkEngine();
        this.engineInstance.reDownloadGroupV2(bytesOwnedIdentity, bytesGroupIdentifier);
    }

    public int getGroupV2Version(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        this.checkEngine();
        return this.engineInstance.getGroupV2Version(bytesOwnedIdentity, bytesGroupIdentifier);
    }

    public boolean isGroupV2UpdateInProgress(byte[] bytesOwnedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        this.checkEngine();
        return this.engineInstance.isGroupV2UpdateInProgress(bytesOwnedIdentity, groupIdentifier);
    }

    public ObvPostMessageOutput post(byte[] messagePayload, ObvOutboundAttachment[] outboundAttachments, List<byte[]> bytesContactIdentities, byte[] bytesOwnedIdentity, boolean hasUserContent, boolean isVoipMessage) {
        this.checkEngine();
        return this.engineInstance.post(messagePayload, null, outboundAttachments, bytesContactIdentities, bytesOwnedIdentity, hasUserContent, isVoipMessage);
    }

    public void downloadMessages(byte[] bytesOwnedIdentity) {
        this.checkEngine();
        this.engineInstance.downloadMessages(bytesOwnedIdentity);
    }

    public void markMessageForDeletion(byte[] bytesOwnedIdentity, byte[] messageIdentifier) {
        this.checkEngine();
        this.engineInstance.markMessageForDeletion(bytesOwnedIdentity, messageIdentifier);
    }

    public void deleteMessageAndAttachments(byte[] bytesOwnedIdentity, byte[] messageIdentifier) {
        this.checkEngine();
        this.engineInstance.deleteMessageAndAttachments(bytesOwnedIdentity, messageIdentifier);
    }

    public void downloadSmallAttachment(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        this.checkEngine();
        this.engineInstance.downloadSmallAttachment(bytesOwnedIdentity, messageIdentifier, attachmentNumber);
    }

    public void downloadLargeAttachment(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        this.checkEngine();
        this.engineInstance.downloadLargeAttachment(bytesOwnedIdentity, messageIdentifier, attachmentNumber);
    }

    public void pauseAttachmentDownload(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        this.checkEngine();
        this.engineInstance.pauseAttachmentDownload(bytesOwnedIdentity, messageIdentifier, attachmentNumber);
    }

    public void markAttachmentForDeletion(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        this.checkEngine();
        this.engineInstance.markAttachmentForDeletion(bytesOwnedIdentity, messageIdentifier, attachmentNumber);
    }

    public void markAttachmentForDeletion(ObvAttachment attachment) {
        this.checkEngine();
        this.engineInstance.markAttachmentForDeletion(attachment);
    }

    public void cancelAttachmentUpload(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        this.checkEngine();
        this.engineInstance.cancelAttachmentUpload(bytesOwnedIdentity, messageIdentifier, attachmentNumber);
    }

    public void resendAllAttachmentNotifications() throws Exception {
        this.checkEngine();
        this.engineInstance.resendAllAttachmentNotifications();
    }

    public boolean isOutboxAttachmentSent(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier, int engineNumber) {
        this.checkEngine();
        return this.engineInstance.isOutboxAttachmentSent(bytesOwnedIdentity, engineMessageIdentifier, engineNumber);
    }

    public boolean isOutboxMessageSent(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier) {
        this.checkEngine();
        return this.engineInstance.isOutboxMessageSent(bytesOwnedIdentity, engineMessageIdentifier);
    }

    public boolean isInboxAttachmentReceived(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier, int engineNumber) {
        this.checkEngine();
        return this.engineInstance.isInboxAttachmentReceived(bytesOwnedIdentity, engineMessageIdentifier, engineNumber);
    }

    public void sendReturnReceipt(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity, ReturnReceiptStatus status, byte[] returnReceiptNonce, byte[] returnReceiptKeyBytes, Integer attachmentNumber) {
        this.checkEngine();
        this.engineInstance.sendReturnReceipt(bytesOwnedIdentity, bytesContactIdentity, status.id, returnReceiptNonce, returnReceiptKeyBytes, attachmentNumber);
    }

    public byte[] getReturnReceiptNonce() {
        this.checkEngine();
        return this.engineInstance.getReturnReceiptNonce();
    }

    public byte[] getReturnReceiptKey() {
        this.checkEngine();
        return this.engineInstance.getReturnReceiptKey();
    }

    public void deleteReturnReceipt(byte[] ownedIdentity, byte[] serverUid) {
        this.checkEngine();
        this.engineInstance.deleteReturnReceipt(ownedIdentity, serverUid);
    }

    public ObvReturnReceipt decryptReturnReceipt(byte[] returnReceiptKey, byte[] encryptedPayload) {
        this.checkEngine();
        return this.engineInstance.decryptReturnReceipt(returnReceiptKey, encryptedPayload);
    }

    public void addNotificationListener(String notificationName, EngineNotificationListener engineNotificationListener) {
        this.checkEngine();
        this.engineInstance.addNotificationListener(notificationName, engineNotificationListener);
    }

    public void removeNotificationListener(String notificationName, EngineNotificationListener engineNotificationListener) {
        this.checkEngine();
        this.engineInstance.removeNotificationListener(notificationName, engineNotificationListener);
    }

    public List<ObvOwnedDevice> getOwnedDevices(byte[] bytesOwnedIdentity) {
        this.checkEngine();
        return this.engineInstance.getOwnedDevices(bytesOwnedIdentity);
    }

    public ObvDeviceList queryRegisteredOwnedDevicesFromServer(byte[] bytesOwnedIdentity) {
        this.checkEngine();
        return this.engineInstance.queryRegisteredOwnedDevicesFromServer(bytesOwnedIdentity);
    }

    public void refreshOwnedDeviceList(byte[] bytesOwnedIdentity) {
        this.checkEngine();
        this.engineInstance.refreshOwnedDeviceList(bytesOwnedIdentity);
    }

    public void recreateOwnedDeviceChannel(byte[] bytesOwnedIdentity, byte[] bytesDeviceUid) {
        this.checkEngine();
        this.engineInstance.recreateOwnedDeviceChannel(bytesOwnedIdentity, bytesDeviceUid);
    }

    public void processDeviceManagementRequest(byte[] bytesOwnedIdentity, ObvDeviceManagementRequest deviceManagementRequest) throws Exception {
        this.checkEngine();
        this.engineInstance.processDeviceManagementRequest(bytesOwnedIdentity, deviceManagementRequest);
    }

    public ObvIdentity bindOwnedIdentityToKeycloak(byte[] bytesOwnedIdentity, ObvKeycloakState keycloakState, String keycloakUserId) {
        this.checkEngine();
        return this.engineInstance.bindOwnedIdentityToKeycloak(bytesOwnedIdentity, keycloakState, keycloakUserId);
    }

    public void saveKeycloakApiKey(byte[] bytesOwnedIdentity, String apiKey) throws Exception {
        this.checkEngine();
        this.engineInstance.saveKeycloakApiKey(bytesOwnedIdentity, apiKey);
    }

    public void saveKeycloakAuthState(byte[] bytesOwnedIdentity, String serializedAuthState) throws Exception {
        this.checkEngine();
        this.engineInstance.saveKeycloakAuthState(bytesOwnedIdentity, serializedAuthState);
    }

    public void saveKeycloakJwks(byte[] bytesOwnedIdentity, String serializedJwks) throws Exception {
        this.checkEngine();
        this.engineInstance.saveKeycloakJwks(bytesOwnedIdentity, serializedJwks);
    }

    public ObvKeycloakState getOwnedIdentityKeycloakState(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getOwnedIdentityKeycloakState(bytesOwnedIdentity);
    }

    public String getOwnedIdentityKeycloakUserId(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getOwnedIdentityKeycloakUserId(bytesOwnedIdentity);
    }

    public void setOwnedIdentityKeycloakUserId(byte[] bytesOwnedIdentity, String userId) throws Exception {
        this.checkEngine();
        this.engineInstance.setOwnedIdentityKeycloakUserId(bytesOwnedIdentity, userId);
    }

    public boolean updateKeycloakGroups(byte[] bytesOwnedIdentity, List<String> signedGroupBlobs, List<String> signedGroupDeletions, List<String> signedGroupKicks, long keycloakCurrentTimestamp) {
        this.checkEngine();
        return this.engineInstance.updateKeycloakGroups(bytesOwnedIdentity, signedGroupBlobs, signedGroupDeletions, signedGroupKicks, keycloakCurrentTimestamp);
    }

    public Collection<ObvIdentity> getOwnedIdentitiesWithKeycloakPushTopic(String pushTopic) throws Exception {
        return this.engineInstance.getOwnedIdentitiesWithKeycloakPushTopic(pushTopic);
    }

    public String getOwnedIdentityKeycloakSelfRevocationTestNonce(byte[] bytesOwnedIdentity, String serverUrl) {
        this.checkEngine();
        return this.engineInstance.getOwnedIdentityKeycloakSelfRevocationTestNonce(bytesOwnedIdentity, serverUrl);
    }

    public void unbindOwnedIdentityFromKeycloak(byte[] bytesOwnedIdentity) {
        this.checkEngine();
        this.engineInstance.unbindOwnedIdentityFromKeycloak(bytesOwnedIdentity);
    }

    public void updateKeycloakPushTopicsIfNeeded(byte[] bytesOwnedIdentity, String serverUrl, List<String> pushTopics) {
        this.checkEngine();
        this.engineInstance.updateKeycloakPushTopicsIfNeeded(bytesOwnedIdentity, serverUrl, pushTopics);
    }

    public void setOwnedIdentityKeycloakSelfRevocationTestNonce(byte[] bytesOwnedIdentity, String serverUrl, String nonce) {
        this.checkEngine();
        this.engineInstance.setOwnedIdentityKeycloakSelfRevocationTestNonce(bytesOwnedIdentity, serverUrl, nonce);
    }

    public void updateKeycloakRevocationList(byte[] bytesOwnedIdentity, long latestRevocationListTimestamp, List<String> signedRevocations) {
        this.checkEngine();
        this.engineInstance.updateKeycloakRevocationList(bytesOwnedIdentity, latestRevocationListTimestamp, signedRevocations);
    }

    public void addKeycloakContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity, String signedContactDetails) throws Exception {
        this.checkEngine();
        this.engineInstance.addKeycloakContact(bytesOwnedIdentity, bytesContactIdentity, signedContactDetails);
    }

    public JsonWebKey getOwnedIdentityKeycloakSignatureKey(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getOwnedIdentityKeycloakSignatureKey(bytesOwnedIdentity);
    }

    public void setOwnedIdentityKeycloakSignatureKey(byte[] bytesOwnedIdentity, JsonWebKey signatureKey) throws Exception {
        this.checkEngine();
        this.engineInstance.setOwnedIdentityKeycloakSignatureKey(bytesOwnedIdentity, signatureKey);
    }

    public ObvIdentity getObvIdentity(byte[] bytesOwnedIdentity) throws Exception {
        this.checkEngine();
        return this.engineInstance.getOwnedIdentity(bytesOwnedIdentity);
    }

    private void checkEngine() {
        if (this.engineInstance == null) {
            throw new RuntimeException("Trying to use unborn engine");
        }
    }

    static {
        jsonObjectMapper = new ObjectMapper();
    }
}

