/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.message;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.message.OwnedMessageSequenceIntervalDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OwnedMessageSequenceInterval;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="owned_message_table")
public final class OwnedMessage
extends OwnedMessageGenerated<OwnedMessage>
implements OwnedMessageGenerated.Interface {
    public OwnedMessage() {
    }

    public OwnedMessage(long genId) {
        super(genId);
    }

    @Override
    public Class<OwnedMessage> getClazz() {
        return OwnedMessage.class;
    }

    public OwnedMessage(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRef replyTo, Location location, AbstractUserMessageGenerated.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, PollMessage pollMessage, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, long missedMessageCount, OwnedMessageEphemeralInfo OwnedMessageEphemeralInfo2, OwnedMessageGenerated.Status status) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, pollMessage, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier, missedMessageCount, OwnedMessageEphemeralInfo2, status);
    }

    public static MessageHelper.InsertionInfo computeInsertionInfo(Discussion discussion, UUID senderThreadIdentifier, long senderSequenceNumber, long timestamp) throws SQLException {
        OwnedMessageSequenceIntervalDao dao = DbManager.getInstance().getOwnedMessageSequenceIntervalDao();
        Optional<OwnedMessageSequenceInterval> currentInterval = dao.foundInterval((Id<Discussion>)discussion.getItemId(), senderThreadIdentifier, senderSequenceNumber);
        if (currentInterval.isPresent()) {
            AppLogger.e("OwnedMessage.computeInsertionInfo: interval already exists");
            return new MessageHelper.InsertionInfo(timestamp, timestamp, 0L);
        }
        Optional<OwnedMessageSequenceInterval> previousInterval = dao.getPreviousInterval((Id<Discussion>)discussion.getItemId(), senderThreadIdentifier, senderSequenceNumber);
        Optional<OwnedMessageSequenceInterval> nextInterval = dao.getNextInterval((Id<Discussion>)discussion.getItemId(), senderThreadIdentifier, senderSequenceNumber);
        return MessageHelper.computeInsertionInfo(discussion, previousInterval, timestamp, senderSequenceNumber, nextInterval, dao, DbManager.getInstance().getOwnedMessageDao(), (sortIndex, adjustedTimestamp) -> new OwnedMessageSequenceInterval(discussion, senderThreadIdentifier, senderSequenceNumber, senderSequenceNumber, (double)sortIndex, (double)sortIndex, (long)adjustedTimestamp, (long)adjustedTimestamp));
    }

    public Optional<String> getStringContent() {
        return MessageHelper.getStringContent(this);
    }

    @Override
    public String toString() {
        return String.format("(OwnedMessage[%s]: %s)", this.getItemId(), this.getBody());
    }
}

