/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.message;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.MessageRefGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;

@DatabaseTable(tableName="message_ref_table")
public class MessageRef
extends MessageRefGenerated<MessageRef> {
    public MessageRef() {
    }

    public MessageRef(long genId) {
        super(genId);
    }

    private MessageRef(Discussion fkDiscussion, long senderSequenceNumber, UUID senderThreadIdentifier, byte[] senderIdentifier, OutboundMessage fkOutboundMessage, InboundMessage fkInboundMessage, OwnedMessage fkOwnedMessage, boolean messageHasBeenReceived) {
        super(0L, fkDiscussion, senderSequenceNumber, senderThreadIdentifier, senderIdentifier, messageHasBeenReceived, fkOutboundMessage, fkInboundMessage, fkOwnedMessage);
        long setMessages = Stream.of(fkOutboundMessage, fkInboundMessage, fkOwnedMessage).filter(x$0 -> Objects.nonNull(x$0)).count();
        if (setMessages > 1L) {
            throw new IllegalStateException("Unexpected params: more than one message is set");
        }
    }

    @Override
    protected Class<MessageRef> getClazz() {
        return MessageRef.class;
    }

    public Kind getKind() {
        if (this.getInboundMessageId().isPresent()) {
            return Kind.INBOUND;
        }
        if (this.getOutboundMessageId().isPresent()) {
            return Kind.OUTBOUND;
        }
        if (this.getOwnedMessageId().isPresent()) {
            return Kind.OWNED;
        }
        if (this.messageHasBeenReceived) {
            return Kind.DELETED;
        }
        return Kind.NOT_RECEIVED;
    }

    public JsonMessageReference toJson() {
        return new JsonMessageReference(this.senderSequenceNumber, this.senderThreadIdentifier, this.senderIdentifier);
    }

    public static MessageRef of(AbstractUserMessageGenerated<?> message) {
        Discussion discussionProxy = new Discussion(message.getDiscussionId().getId());
        if (message instanceof OutboundMessage) {
            OutboundMessage outboundMessage = (OutboundMessage)message;
            byte[] senderIdentifier = DbManager.getInstance().getOutboundMessageDao().getSenderIdentifier(outboundMessage);
            return new MessageRef(discussionProxy, outboundMessage.getSenderSequenceNumber(), outboundMessage.getSenderThreadIdentifier(), senderIdentifier, outboundMessage, null, null, true);
        }
        if (message instanceof InboundMessage) {
            InboundMessage inboundMessage = (InboundMessage)message;
            byte[] senderIdentifier = DbManager.getInstance().getInboundMessageDao().getSenderIdentifier(inboundMessage);
            return new MessageRef(discussionProxy, inboundMessage.getSenderSequenceNumber(), inboundMessage.getSenderThreadIdentifier(), senderIdentifier, null, inboundMessage, null, true);
        }
        if (message instanceof OwnedMessage) {
            OwnedMessage ownedMessage = (OwnedMessage)message;
            byte[] senderIdentifier = DbManager.getInstance().getOwnedMessageDao().getSenderIdentifier(ownedMessage);
            return new MessageRef(discussionProxy, ownedMessage.getSenderSequenceNumber(), ownedMessage.getSenderThreadIdentifier(), senderIdentifier, null, null, ownedMessage, true);
        }
        throw new IllegalStateException();
    }

    public static MessageRef of(Discussion discussion, JsonMessageReference jsonMessageReference, OutboundMessage outboundMessage) {
        return new MessageRef(discussion, jsonMessageReference.getSenderSequenceNumber(), jsonMessageReference.getSenderThreadIdentifier(), jsonMessageReference.getSenderIdentifier(), outboundMessage, null, null, true);
    }

    public static MessageRef of(Discussion discussion, JsonMessageReference jsonMessageReference, InboundMessage inboundMessage) {
        return new MessageRef(discussion, jsonMessageReference.getSenderSequenceNumber(), jsonMessageReference.getSenderThreadIdentifier(), jsonMessageReference.getSenderIdentifier(), null, inboundMessage, null, true);
    }

    public static MessageRef of(Discussion discussion, JsonMessageReference jsonMessageReference, OwnedMessage ownedMessage) {
        return new MessageRef(discussion, jsonMessageReference.getSenderSequenceNumber(), jsonMessageReference.getSenderThreadIdentifier(), jsonMessageReference.getSenderIdentifier(), null, null, ownedMessage, true);
    }

    public static MessageRef of(Discussion discussion, JsonMessageReference jsonMessageReference) {
        return new MessageRef(discussion, jsonMessageReference.getSenderSequenceNumber(), jsonMessageReference.getSenderThreadIdentifier(), jsonMessageReference.getSenderIdentifier(), null, null, null, false);
    }

    @Override
    public String toString() {
        return String.format("MessageRef[%s]->%s%s%s", ((Id)this.getItemId()).getId(), this.getInboundMessageId().map(Id::getDescription).orElse(""), this.getOutboundMessageId().map(Id::getDescription).orElse(""), this.getOwnedMessageId().map(Id::getDescription).orElse(""));
    }

    public static enum Kind {
        NOT_RECEIVED,
        INBOUND,
        OUTBOUND,
        OWNED,
        DELETED;

    }
}

