/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.message;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.message.MessageRecipientInfoGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Optional;

@DatabaseTable(tableName="message_recipient_info_table")
public class MessageRecipientInfo
extends MessageRecipientInfoGenerated<MessageRecipientInfo> {
    public MessageRecipientInfo() {
    }

    public MessageRecipientInfo(OutboundMessage outboundMessage, IdentityRef recipientRef, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, Long timestampSent, Long timestampDelivered, Long timestampRead) {
        super(0L, outboundMessage, recipientRef, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier, timestampSent, timestampDelivered, timestampRead);
    }

    public MessageRecipientInfo(OutboundMessage fkMessage, IdentityRef fkRecipientRef, byte[] engineMessageIdentifier, byte[] returnReceiptNonce, byte[] returnReceiptKey) {
        this.fkMessage = fkMessage;
        this.fkRecipientRef = fkRecipientRef;
        this.engineMessageIdentifier = engineMessageIdentifier;
        this.returnReceiptNonce = returnReceiptNonce;
        this.returnReceiptKey = returnReceiptKey;
        this.timestampSent = null;
        this.timestampDelivered = null;
        this.timestampRead = null;
    }

    @Override
    protected Class<MessageRecipientInfo> getClazz() {
        return MessageRecipientInfo.class;
    }

    public Status status() {
        if (this.timestampRead != null) {
            return Status.READ;
        }
        if (this.timestampDelivered != null) {
            return Status.DELIVERED;
        }
        if (this.timestampSent != null) {
            return Status.SENT;
        }
        return Status.PROCESSING;
    }

    public Optional<Long> getTimestamp(Status status) {
        return switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Optional.empty();
            case 1 -> this.getTimestampSent();
            case 2 -> this.getTimestampDelivered();
            case 3 -> this.getTimestampRead();
        };
    }

    @Override
    public String toString() {
        return String.format("(MessageRecipientInfo (%s): %s | %s)", this.getItemId(), this.fkMessage, this.status());
    }

    public static enum Status implements IComparable<Status>
    {
        PROCESSING,
        SENT,
        DELIVERED,
        READ;

    }
}

