/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.message;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.message.InboundMessageSequenceIntervalDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.InboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessageSequenceInterval;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="inbound_message_table")
public final class InboundMessage
extends InboundMessageGenerated<InboundMessage>
implements InboundMessageGenerated.Interface {
    @ForeignCollectionField(eager=false)
    private ForeignCollection<InboundMessageMetadata> fcMetadata;

    public InboundMessage() {
    }

    public InboundMessage(long genId) {
        super(genId);
    }

    public InboundMessage(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRef replyTo, Location location, AbstractUserMessageGenerated.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, PollMessage pollMessage, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, long missedMessageCount, InboundMessageEphemeralInfo inboundMessageEphemeralInfo, ContactRef sender, InboundMessageGenerated.Status status, boolean boxed) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, pollMessage, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier, missedMessageCount, inboundMessageEphemeralInfo, sender, status, boxed);
    }

    @Override
    protected Class<InboundMessage> getClazz() {
        return InboundMessage.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<InboundMessageMetadata> getMetadata(InboundMessageMetadataGenerated.Kind kind) {
        if (this.fcMetadata.isEmpty()) {
            return Optional.empty();
        }
        CloseableIterator iterator = this.fcMetadata.closeableIterator();
        try {
            while (iterator.hasNext()) {
                InboundMessageMetadata metadata = (InboundMessageMetadata)iterator.next();
                if (metadata.getKind() != kind) continue;
                Optional<InboundMessageMetadata> optional = Optional.of(metadata);
                return optional;
            }
            Optional<InboundMessageMetadata> optional = Optional.empty();
            return optional;
        }
        finally {
            iterator.closeQuietly();
        }
    }

    public static MessageHelper.InsertionInfo computeInsertionInfo(Discussion discussion, UUID senderThreadIdentifier, ContactRef sender, long senderSequenceNumber, long timestamp) throws SQLException {
        InboundMessageSequenceIntervalDao dao = DbManager.getInstance().getInboundMessageSequenceIntervalDao();
        Optional<InboundMessageSequenceInterval> currentInterval = dao.foundInterval((Id<Discussion>)discussion.getItemId(), sender, senderThreadIdentifier, senderSequenceNumber);
        if (currentInterval.isPresent()) {
            AppLogger.e("InboundMessage.computeInsertionInfo: interval already exists");
            return new MessageHelper.InsertionInfo(timestamp, timestamp, 0L);
        }
        Optional<InboundMessageSequenceInterval> previousInterval = dao.getPreviousInterval((Id<Discussion>)discussion.getItemId(), sender, senderThreadIdentifier, senderSequenceNumber);
        Optional<InboundMessageSequenceInterval> nextInterval = dao.getNextInterval((Id<Discussion>)discussion.getItemId(), sender, senderThreadIdentifier, senderSequenceNumber);
        return MessageHelper.computeInsertionInfo(discussion, previousInterval, timestamp, senderSequenceNumber, nextInterval, dao, DbManager.getInstance().getInboundMessageDao(), (sortIndex, adjustedTimestamp) -> new InboundMessageSequenceInterval(discussion, senderThreadIdentifier, senderSequenceNumber, senderSequenceNumber, (double)sortIndex, (double)sortIndex, (long)adjustedTimestamp, (long)adjustedTimestamp, sender));
    }

    public Optional<String> getStringContent() {
        return MessageHelper.getStringContent(this);
    }

    @Override
    public String toString() {
        return String.format("(InboundMessage[%s]: %s)", this.getItemId(), this.getStringContent());
    }
}

