/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.pollMessage;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class PollMessageVoteGenerated<T extends PollMessageVoteGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "poll_message_vote_table";
    private static final String FK_POLL_MESSAGE_NAME = "fk_poll_message";
    public static final Column.ForeignColumn<PollMessageVote, PollMessage> FK_POLL_MESSAGE = new Column.ForeignColumn("fk_poll_message", true);
    private static final String FK_POLL_MESSAGE_CHOICE_NAME = "fk_poll_message_choice";
    public static final Column.ForeignColumn<PollMessageVote, PollMessageChoice> FK_POLL_MESSAGE_CHOICE = new Column.ForeignColumn("fk_poll_message_choice", true);
    private static final String FK_IDENTITY_REF_NAME = "fk_identity_ref";
    public static final Column.ForeignColumn<PollMessageVote, IdentityRef> FK_IDENTITY_REF = new Column.ForeignColumn("fk_identity_ref", true);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<PollMessageVote, Group> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.ObjectColumn<PollMessageVote, Long> TIMESTAMP = new Column.ObjectColumn("timestamp", false);
    private static final String VOTED_NAME = "voted";
    public static final Column.booleanColumn<PollMessageVote> VOTED = new Column.booleanColumn("voted");
    private static final String VERSION_NAME = "version";
    public static final Column.intColumn<PollMessageVote> VERSION = new Column.intColumn("version");
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_poll_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_poll_message REFERENCES poll_message_table(gen_id) ON DELETE CASCADE")
    protected PollMessage fkPollMessage;
    @DatabaseField(columnName="fk_poll_message_choice", foreign=true, foreignAutoRefresh=true, index=true, columnDefinition="LONG CONSTRAINT fk_poll_message_choice REFERENCES poll_message_choice_table(gen_id) ON DELETE CASCADE")
    protected PollMessageChoice fkPollMessageChoice;
    @DatabaseField(columnName="fk_identity_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_ref REFERENCES identity_ref_table(gen_id)")
    protected IdentityRef fkIdentityRef;
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group REFERENCES group_table(gen_id) ON DELETE SET NULL")
    protected Group fkGroup;
    @DatabaseField(columnName="timestamp", canBeNull=false, dataType=DataType.LONG_OBJ)
    protected Long timestamp;
    @DatabaseField(columnName="voted", dataType=DataType.BOOLEAN)
    protected boolean voted;
    @DatabaseField(columnName="version", dataType=DataType.INTEGER)
    protected int version;
    @DatabaseField(columnName="virtual_fk_poll_message", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_poll_message, 0)) VIRTUAL")
    private long virtualPollMessage;
    @DatabaseField(columnName="virtual_fk_poll_message_choice", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_poll_message_choice, 0)) VIRTUAL")
    private long virtualPollMessageChoice;
    @DatabaseField(columnName="virtual_fk_identity_ref", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_identity_ref, 0)) VIRTUAL")
    private long virtualIdentityRef;
    public static final List<TableReference<?, PollMessageVote>> references;

    public PollMessageVoteGenerated() {
    }

    public PollMessageVoteGenerated(long genId) {
        super(genId);
    }

    public PollMessageVoteGenerated(long genId, PollMessage pollMessage, PollMessageChoice pollMessageChoice, IdentityRef identityRef, Group group, Long timestamp, boolean voted, int version) {
        super(genId);
        this.fkPollMessage = pollMessage;
        this.fkPollMessageChoice = pollMessageChoice;
        this.fkIdentityRef = identityRef;
        this.fkGroup = group;
        this.timestamp = timestamp;
        this.voted = voted;
        this.version = version;
    }

    public Optional<Id<PollMessage>> getPollMessageId() {
        return Optional.ofNullable(this.fkPollMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<PollMessageChoice> getPollMessageChoice() {
        return Optional.ofNullable(this.fkPollMessageChoice);
    }

    public void setPollMessageChoice(Optional<PollMessageChoice> fkPollMessageChoice) {
        this.fkPollMessageChoice = fkPollMessageChoice.orElse(null);
    }

    public Optional<Id<IdentityRef>> getIdentityRefId() {
        return Optional.ofNullable(this.fkIdentityRef).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<Group>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isVoted() {
        return this.voted;
    }

    public void setVoted(boolean voted) {
        this.voted = voted;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        return String.format("PollMessageVote[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PollMessageVoteGenerated casted = (PollMessageVoteGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkPollMessage, casted.fkPollMessage) && Objects.equals(this.fkPollMessageChoice, casted.fkPollMessageChoice) && Objects.equals(this.fkIdentityRef, casted.fkIdentityRef) && Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.timestamp, casted.timestamp) && this.voted == casted.voted && this.version == casted.version;
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_POLL_MESSAGE_NAME);
        fields.add(FK_POLL_MESSAGE_CHOICE_NAME);
        fields.add(FK_IDENTITY_REF_NAME);
        fields.add(FK_GROUP_NAME);
        fields.add(TIMESTAMP_NAME);
        fields.add(VOTED_NAME);
        fields.add(VERSION_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }
}

