/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.pollMessage;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class PollMessageGenerated<T extends PollMessageGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "poll_message_table";
    private static final String ANSWER_TYPE_NAME = "answer_type";
    public static final Column.ObjectColumn<PollMessage, String> ANSWER_TYPE = new Column.ObjectColumn("answer_type", false);
    private static final String QUESTION_NAME = "question";
    public static final Column.ObjectColumn<PollMessage, String> QUESTION = new Column.ObjectColumn("question", false);
    private static final String MULTIPLE_CHOICE_NAME = "multiple_choice";
    public static final Column.booleanColumn<PollMessage> MULTIPLE_CHOICE = new Column.booleanColumn("multiple_choice");
    private static final String EXPIRATION_NAME = "expiration";
    public static final Column.ObjectColumn<PollMessage, Long> EXPIRATION = new Column.ObjectColumn("expiration", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="answer_type", canBeNull=false, dataType=DataType.STRING)
    protected String answerType;
    @DatabaseField(columnName="question", canBeNull=false, dataType=DataType.STRING)
    protected String question;
    @DatabaseField(columnName="multiple_choice", dataType=DataType.BOOLEAN)
    protected boolean multipleChoice;
    @DatabaseField(columnName="expiration", dataType=DataType.LONG_OBJ)
    protected Long expiration;
    public static final List<TableReference<?, PollMessage>> references;

    public PollMessageGenerated() {
    }

    public PollMessageGenerated(long genId) {
        super(genId);
    }

    public PollMessageGenerated(long genId, String answerType, String question, boolean multipleChoice, Long expiration) {
        super(genId);
        this.answerType = answerType;
        this.question = question;
        this.multipleChoice = multipleChoice;
        this.expiration = expiration;
    }

    public String getAnswerType() {
        return this.answerType;
    }

    public String getQuestion() {
        return this.question;
    }

    public boolean isMultipleChoice() {
        return this.multipleChoice;
    }

    public Optional<Long> getExpiration() {
        return Optional.ofNullable(this.expiration);
    }

    public String toString() {
        return String.format("PollMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PollMessageGenerated casted = (PollMessageGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.answerType, casted.answerType) && Objects.equals(this.question, casted.question) && this.multipleChoice == casted.multipleChoice && Objects.equals(this.expiration, casted.expiration);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(ANSWER_TYPE_NAME);
        fields.add(QUESTION_NAME);
        fields.add(MULTIPLE_CHOICE_NAME);
        fields.add(EXPIRATION_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(InboundMessage.class, InboundMessage.FK_POLL_MESSAGE, x -> x.getPollMessageId()));
        refs.add(new TableReference(OwnedMessage.class, OwnedMessage.FK_POLL_MESSAGE, x -> x.getPollMessageId()));
        refs.add(new TableReference(OutboundMessage.class, OutboundMessage.FK_POLL_MESSAGE, x -> x.getPollMessageId()));
        refs.add(new TableReference(PollMessageChoice.class, PollMessageChoice.FK_POLL_MESSAGE, x -> x.getPollMessageId()));
        refs.add(new TableReference(PollMessageVote.class, PollMessageVote.FK_POLL_MESSAGE, x -> x.getPollMessageId()));
        references = List.copyOf(refs);
    }
}

