/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class SystemMessageGenerated<T extends SystemMessageGenerated<T>>
extends AbstractMessageGenerated<T>
implements Table {
    public static final String TABLE_NAME = "system_message_table";
    private static final String CATEGORY_NAME = "category";
    public static final Column.ObjectColumn<SystemMessage, Category> CATEGORY = new Column.ObjectColumn("category", false);
    private static final String FK_IDENTITY_REF_NAME = "fk_identity_ref";
    public static final Column.ForeignColumn<SystemMessage, IdentityRef> FK_IDENTITY_REF = new Column.ForeignColumn("fk_identity_ref", true);
    private static final String READ_ONCE_NAME = "read_once";
    public static final Column.ObjectColumn<SystemMessage, Boolean> READ_ONCE = new Column.ObjectColumn("read_once", true);
    private static final String VISIBILITY_DURATION_NAME = "visibility_duration";
    public static final Column.ObjectColumn<SystemMessage, Long> VISIBILITY_DURATION = new Column.ObjectColumn("visibility_duration", true);
    private static final String EXISTENCE_DURATION_NAME = "existence_duration";
    public static final Column.ObjectColumn<SystemMessage, Long> EXISTENCE_DURATION = new Column.ObjectColumn("existence_duration", true);
    public static final List<String> ALL_FIELDS;
    public static final List<String> MAP_ROW_FIELDS;
    public static final List<Column<? super SystemMessage>> MAP_ROW_COLUMNS;
    @DatabaseField(columnName="category", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Category category;
    @DatabaseField(columnName="fk_identity_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_ref REFERENCES identity_ref_table(gen_id) ON DELETE SET NULL")
    protected IdentityRef fkIdentityRef;
    @DatabaseField(columnName="read_once", dataType=DataType.BOOLEAN_OBJ)
    protected Boolean readOnce;
    @DatabaseField(columnName="visibility_duration", dataType=DataType.LONG_OBJ)
    protected Long visibilityDuration;
    @DatabaseField(columnName="existence_duration", dataType=DataType.LONG_OBJ)
    protected Long existenceDuration;
    public static final List<TableReference<?, SystemMessage>> references;

    public SystemMessageGenerated() {
    }

    public SystemMessageGenerated(long genId) {
        super(genId);
    }

    public SystemMessageGenerated(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, Category category, IdentityRef identityRef, Boolean readOnce, Long visibilityDuration, Long existenceDuration) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp);
        this.category = category;
        this.fkIdentityRef = identityRef;
        this.readOnce = readOnce;
        this.visibilityDuration = visibilityDuration;
        this.existenceDuration = existenceDuration;
    }

    public Category getCategory() {
        return this.category;
    }

    public Optional<Id<IdentityRef>> getIdentityRefId() {
        return Optional.ofNullable(this.fkIdentityRef).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Boolean> getReadOnce() {
        return Optional.ofNullable(this.readOnce);
    }

    public Optional<Long> getVisibilityDuration() {
        return Optional.ofNullable(this.visibilityDuration);
    }

    public Optional<Long> getExistenceDuration() {
        return Optional.ofNullable(this.existenceDuration);
    }

    @Override
    public String toString() {
        return String.format("SystemMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        SystemMessageGenerated casted = (SystemMessageGenerated)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && this.category == casted.category && Objects.equals(this.fkIdentityRef, casted.fkIdentityRef) && Objects.equals(this.readOnce, casted.readOnce) && Objects.equals(this.visibilityDuration, casted.visibilityDuration) && Objects.equals(this.existenceDuration, casted.existenceDuration);
    }

    public static Interface mapRow(DatabaseResults databaseResults, String prefix) throws SQLException {
        long genId_ = AbstractTableGenerated.getLong(databaseResults, GEN_ID, prefix);
        Id<SystemMessage> genId = new Id<SystemMessage>(SystemMessage.class, genId_);
        long discussionId = AbstractTableGenerated.getLong(databaseResults, FK_DISCUSSION, prefix);
        Id<Discussion> discussion = new Id<Discussion>(Discussion.class, discussionId);
        long senderSequenceNumber = AbstractTableGenerated.getLong(databaseResults, SENDER_SEQUENCE_NUMBER, prefix);
        double sortIndex = AbstractTableGenerated.getDouble(databaseResults, SORT_INDEX, prefix);
        long timestamp = AbstractTableGenerated.getLong(databaseResults, TIMESTAMP, prefix);
        String categoryAsString = AbstractTableGenerated.getEnumName(databaseResults, CATEGORY, prefix);
        Category category = Category.valueOf(categoryAsString);
        Long identityRefId = AbstractTableGenerated.getLongObj(databaseResults, FK_IDENTITY_REF, prefix);
        Optional<Object> identityRef = identityRefId == null ? Optional.empty() : Optional.of(new Id<IdentityRef>(IdentityRef.class, identityRefId));
        Boolean readOnce = AbstractTableGenerated.getBooleanObj(databaseResults, READ_ONCE, prefix);
        Long visibilityDuration = AbstractTableGenerated.getLongObj(databaseResults, VISIBILITY_DURATION, prefix);
        Long existenceDuration = AbstractTableGenerated.getLongObj(databaseResults, EXISTENCE_DURATION, prefix);
        return new Pojo(genId, discussion, senderSequenceNumber, sortIndex, timestamp, category, identityRef, readOnce, visibilityDuration, existenceDuration);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractMessageGenerated.ALL_FIELDS);
        fields.add(CATEGORY_NAME);
        fields.add(FK_IDENTITY_REF_NAME);
        fields.add(READ_ONCE_NAME);
        fields.add(VISIBILITY_DURATION_NAME);
        fields.add(EXISTENCE_DURATION_NAME);
        ALL_FIELDS = List.copyOf(fields);
        fields = new ArrayList<String>(AbstractMessageGenerated.MAP_ROW_FIELDS);
        fields.add(CATEGORY_NAME);
        fields.add(FK_IDENTITY_REF_NAME);
        fields.add(READ_ONCE_NAME);
        fields.add(VISIBILITY_DURATION_NAME);
        fields.add(EXISTENCE_DURATION_NAME);
        MAP_ROW_FIELDS = List.copyOf(fields);
        ArrayList<Column<AbstractMessageGenerated<Object>>> columns = new ArrayList<Column<AbstractMessageGenerated<Object>>>();
        columns.addAll(AbstractMessageGenerated.MAP_ROW_COLUMNS);
        columns.add(CATEGORY);
        columns.add(FK_IDENTITY_REF);
        columns.add(READ_ONCE);
        columns.add(VISIBILITY_DURATION);
        columns.add(EXISTENCE_DURATION);
        MAP_ROW_COLUMNS = List.copyOf(columns);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(Discussion.class, Discussion.FK_LAST_SYSTEM_MESSAGE, x -> x.getLastSystemMessageId()));
        references = List.copyOf(refs);
    }

    public static enum Category implements IComparable<Category>
    {
        GROUP_MEMBER_JOINED,
        GROUP_MEMBER_LEFT,
        LEFT_GROUP,
        CONTACT_DELETED,
        DISCUSSION_SETTINGS_UPDATE,
        DISCUSSION_REMOTELY_DELETED,
        NEW_PUBLISHED_DETAILS,
        CONTACT_REVOKED,
        CONTACT_FORCEFULLY_UNBLOCKED,
        CONTACT_RE_ADDED,
        RE_JOINED_GROUP,
        JOINED_GROUP,
        GAINED_GROUP_ADMIN,
        LOST_GROUP_ADMIN,
        GROUP_MEMBERS_JOINED,
        GROUP_MEMBERS_LEFT;

    }

    private record Pojo(Id<SystemMessage> genId, Id<Discussion> discussion, long senderSequenceNumber, double sortIndex, long timestamp, Category category, Optional<Id<IdentityRef>> identityRef, Boolean readOnce, Long visibilityDuration, Long existenceDuration) implements Interface
    {
        @Override
        public Id<SystemMessage> getItemId() {
            return this.genId;
        }

        @Override
        public Id<Discussion> getDiscussionId() {
            return this.discussion;
        }

        @Override
        public long getSenderSequenceNumber() {
            return this.senderSequenceNumber;
        }

        @Override
        public double getSortIndex() {
            return this.sortIndex;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public Category getCategory() {
            return this.category;
        }

        @Override
        public Optional<Id<IdentityRef>> getIdentityRefId() {
            return this.identityRef;
        }

        @Override
        public Optional<Boolean> getReadOnce() {
            return Optional.ofNullable(this.readOnce);
        }

        @Override
        public Optional<Long> getVisibilityDuration() {
            return Optional.ofNullable(this.visibilityDuration);
        }

        @Override
        public Optional<Long> getExistenceDuration() {
            return Optional.ofNullable(this.existenceDuration);
        }

        @Override
        public boolean areContentTheSame(Object obj) {
            return this.equals(obj);
        }
    }

    public static interface Interface
    extends AbstractMessageGenerated.Interface<SystemMessage> {
        @Override
        public Id<SystemMessage> getItemId();

        @Override
        public Id<Discussion> getDiscussionId();

        @Override
        public long getSenderSequenceNumber();

        @Override
        public double getSortIndex();

        @Override
        public long getTimestamp();

        public Category getCategory();

        public Optional<Id<IdentityRef>> getIdentityRefId();

        public Optional<Boolean> getReadOnce();

        public Optional<Long> getVisibilityDuration();

        public Optional<Long> getExistenceDuration();
    }
}

