/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.annotations.ExtraStatements;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class InboundMessageGenerated<T extends InboundMessageGenerated<T>>
extends ReceivedMessageGenerated<T>
implements Table {
    public static final String TABLE_NAME = "inbound_message_table";
    private static final String CREATE_VIRTUAL_STATEMENT = "CREATE VIRTUAL TABLE IF NOT EXISTS inbound_message_table_fts USING fts5(`body`, tokenize=\"unicode61 remove_diacritics 2\", content='inbound_message_table', content_rowid='gen_id');";
    private static final String AFTER_CREATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS inbound_message_table_ai AFTER INSERT ON inbound_message_table BEGIN  INSERT INTO inbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END;";
    private static final String AFTER_UPDATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS inbound_message_table_au AFTER UPDATE ON inbound_message_table FOR EACH ROW  WHEN  ( new.body IS NOT old.body ) BEGIN  INSERT INTO inbound_message_table_fts (`inbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); INSERT INTO inbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END; ";
    private static final String AFTER_DELETE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS inbound_message_table_ad AFTER DELETE ON inbound_message_table BEGIN  INSERT INTO inbound_message_table_fts (`inbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); END;";
    private static final String FK_INBOUND_MESSAGE_EPHEMERAL_INFO_NAME = "fk_inbound_message_ephemeral_info";
    public static final Column.ForeignColumn<InboundMessage, InboundMessageEphemeralInfo> FK_INBOUND_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_inbound_message_ephemeral_info", true);
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<InboundMessage, ContactRef> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<InboundMessage, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String BOXED_NAME = "boxed";
    public static final Column.booleanColumn<InboundMessage> BOXED = new Column.booleanColumn("boxed");
    @ExtraStatements
    public static final List<String> ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS;
    public static final List<String> ALL_FIELDS;
    public static final List<String> MAP_ROW_FIELDS;
    public static final List<Column<? super InboundMessage>> MAP_ROW_COLUMNS;
    @DatabaseField(columnName="fk_inbound_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message_ephemeral_info REFERENCES inbound_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageEphemeralInfo fkInboundMessageEphemeralInfo;
    @DatabaseField(columnName="fk_sender", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES contact_ref_table(gen_id)")
    protected ContactRef fkSender;
    @DatabaseField(columnName="status", index=true, canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="boxed", dataType=DataType.BOOLEAN)
    protected boolean boxed;
    public static final List<TableReference<?, InboundMessage>> references;

    public InboundMessageGenerated() {
    }

    public InboundMessageGenerated(long genId) {
        super(genId);
    }

    public InboundMessageGenerated(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRef replyTo, Location location, AbstractUserMessageGenerated.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, PollMessage pollMessage, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, long missedMessageCount, InboundMessageEphemeralInfo inboundMessageEphemeralInfo, ContactRef sender, Status status, boolean boxed) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, pollMessage, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier, missedMessageCount);
        this.fkInboundMessageEphemeralInfo = inboundMessageEphemeralInfo;
        this.fkSender = sender;
        this.status = status;
        this.boxed = boxed;
    }

    public Optional<Id<InboundMessageEphemeralInfo>> getInboundMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkInboundMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Id<ContactRef> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public void setBoxed(boolean boxed) {
        this.boxed = boxed;
    }

    @Override
    public String toString() {
        return String.format("InboundMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        InboundMessageGenerated casted = (InboundMessageGenerated)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkInboundMessageEphemeralInfo, casted.fkInboundMessageEphemeralInfo) && Objects.equals(this.fkSender, casted.fkSender) && this.status == casted.status && this.boxed == casted.boxed;
    }

    public static Interface mapRow(DatabaseResults databaseResults, String prefix) throws SQLException {
        long genId_ = AbstractTableGenerated.getLong(databaseResults, GEN_ID, prefix);
        Id<InboundMessage> genId = new Id<InboundMessage>(InboundMessage.class, genId_);
        long discussionId = AbstractTableGenerated.getLong(databaseResults, FK_DISCUSSION, prefix);
        Id<Discussion> discussion = new Id<Discussion>(Discussion.class, discussionId);
        long senderSequenceNumber = AbstractTableGenerated.getLong(databaseResults, SENDER_SEQUENCE_NUMBER, prefix);
        double sortIndex = AbstractTableGenerated.getDouble(databaseResults, SORT_INDEX, prefix);
        long timestamp = AbstractTableGenerated.getLong(databaseResults, TIMESTAMP, prefix);
        String body = AbstractTableGenerated.getStringObj(databaseResults, BODY, prefix);
        Long replyToId = AbstractTableGenerated.getLongObj(databaseResults, FK_REPLY_TO, prefix);
        Optional<Object> replyTo = replyToId == null ? Optional.empty() : Optional.of(new Id<MessageRef>(MessageRef.class, replyToId));
        Long locationId = AbstractTableGenerated.getLongObj(databaseResults, FK_LOCATION, prefix);
        Optional<Object> location = locationId == null ? Optional.empty() : Optional.of(new Id<Location>(Location.class, locationId));
        String wipeStatusAsString = AbstractTableGenerated.getEnumName(databaseResults, WIPE_STATUS, prefix);
        AbstractUserMessageGenerated.WipeStatus wipeStatus = AbstractUserMessageGenerated.WipeStatus.valueOf(wipeStatusAsString);
        int totalAttachmentCount = AbstractTableGenerated.getInt(databaseResults, TOTAL_ATTACHMENT_COUNT, prefix);
        int imageCount = AbstractTableGenerated.getInt(databaseResults, IMAGE_COUNT, prefix);
        String linkPreviewKindAsString = AbstractTableGenerated.getEnumName(databaseResults, LINK_PREVIEW_KIND, prefix);
        AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind = AbstractUserMessageGenerated.LinkPreviewKind.valueOf(linkPreviewKindAsString);
        String linkPreviewDescription = AbstractTableGenerated.getStringObj(databaseResults, LINK_PREVIEW_DESCRIPTION, prefix);
        Double linkPreviewImageWidth = AbstractTableGenerated.getDoubleObj(databaseResults, LINK_PREVIEW_IMAGE_WIDTH, prefix);
        String editionStatusAsString = AbstractTableGenerated.getEnumName(databaseResults, EDITION_STATUS, prefix);
        AbstractUserMessageGenerated.EditionStatus editionStatus = AbstractUserMessageGenerated.EditionStatus.valueOf(editionStatusAsString);
        boolean forwarded = AbstractTableGenerated.getBoolean(databaseResults, FORWARDED, prefix);
        Long pollMessageId = AbstractTableGenerated.getLongObj(databaseResults, FK_POLL_MESSAGE, prefix);
        Optional<Object> pollMessage = pollMessageId == null ? Optional.empty() : Optional.of(new Id<PollMessage>(PollMessage.class, pollMessageId));
        long missedMessageCount = AbstractTableGenerated.getLong(databaseResults, MISSED_MESSAGE_COUNT, prefix);
        Long inboundMessageEphemeralInfoId = AbstractTableGenerated.getLongObj(databaseResults, FK_INBOUND_MESSAGE_EPHEMERAL_INFO, prefix);
        Optional<Object> inboundMessageEphemeralInfo = inboundMessageEphemeralInfoId == null ? Optional.empty() : Optional.of(new Id<InboundMessageEphemeralInfo>(InboundMessageEphemeralInfo.class, inboundMessageEphemeralInfoId));
        long senderId = AbstractTableGenerated.getLong(databaseResults, FK_SENDER, prefix);
        Id<ContactRef> sender = new Id<ContactRef>(ContactRef.class, senderId);
        String statusAsString = AbstractTableGenerated.getEnumName(databaseResults, STATUS, prefix);
        Status status = Status.valueOf(statusAsString);
        boolean boxed = AbstractTableGenerated.getBoolean(databaseResults, BOXED, prefix);
        return new Pojo(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, pollMessage, missedMessageCount, inboundMessageEphemeralInfo, sender, status, boxed);
    }

    static {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(CREATE_VIRTUAL_STATEMENT);
        statements.add(AFTER_CREATE_STATEMENT);
        statements.add(AFTER_UPDATE_STATEMENT);
        statements.add(AFTER_DELETE_STATEMENT);
        ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS = List.copyOf(statements);
        ArrayList<String> fields = new ArrayList<String>(ReceivedMessageGenerated.ALL_FIELDS);
        fields.add(FK_INBOUND_MESSAGE_EPHEMERAL_INFO_NAME);
        fields.add(FK_SENDER_NAME);
        fields.add(STATUS_NAME);
        fields.add(BOXED_NAME);
        ALL_FIELDS = List.copyOf(fields);
        fields = new ArrayList<String>(ReceivedMessageGenerated.MAP_ROW_FIELDS);
        fields.add(FK_INBOUND_MESSAGE_EPHEMERAL_INFO_NAME);
        fields.add(FK_SENDER_NAME);
        fields.add(STATUS_NAME);
        fields.add(BOXED_NAME);
        MAP_ROW_FIELDS = List.copyOf(fields);
        ArrayList<Column<ReceivedMessageGenerated<Object>>> columns = new ArrayList<Column<ReceivedMessageGenerated<Object>>>();
        columns.addAll(ReceivedMessageGenerated.MAP_ROW_COLUMNS);
        columns.add(FK_INBOUND_MESSAGE_EPHEMERAL_INFO);
        columns.add(FK_SENDER);
        columns.add(STATUS);
        columns.add(BOXED);
        MAP_ROW_COLUMNS = List.copyOf(columns);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(InboundAttachment.class, InboundAttachment.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        refs.add(new TableReference(MessageRef.class, MessageRef.FK_INBOUND_MESSAGE, x -> x.getInboundMessageId()));
        refs.add(new TableReference(InboundMessageMetadata.class, InboundMessageMetadata.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        refs.add(new TableReference(InboundMessageReaction.class, InboundMessageReaction.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        references = List.copyOf(refs);
    }

    public static enum Status implements IComparable<Status>
    {
        UNREAD,
        READ;

    }

    private record Pojo(Id<InboundMessage> genId, Id<Discussion> discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, Optional<Id<MessageRef>> replyTo, Optional<Id<Location>> location, AbstractUserMessageGenerated.WipeStatus wipeStatus, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, Optional<Id<PollMessage>> pollMessage, long missedMessageCount, Optional<Id<InboundMessageEphemeralInfo>> inboundMessageEphemeralInfo, Id<ContactRef> sender, Status status, boolean boxed) implements Interface
    {
        @Override
        public Id<InboundMessage> getItemId() {
            return this.genId;
        }

        @Override
        public Id<Discussion> getDiscussionId() {
            return this.discussion;
        }

        @Override
        public long getSenderSequenceNumber() {
            return this.senderSequenceNumber;
        }

        @Override
        public double getSortIndex() {
            return this.sortIndex;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public Optional<String> getBody() {
            return Optional.ofNullable(this.body);
        }

        @Override
        public Optional<Id<MessageRef>> getReplyToId() {
            return this.replyTo;
        }

        @Override
        public Optional<Id<Location>> getLocationId() {
            return this.location;
        }

        @Override
        public AbstractUserMessageGenerated.WipeStatus getWipeStatus() {
            return this.wipeStatus;
        }

        @Override
        public int getTotalAttachmentCount() {
            return this.totalAttachmentCount;
        }

        @Override
        public int getImageCount() {
            return this.imageCount;
        }

        @Override
        public AbstractUserMessageGenerated.LinkPreviewKind getLinkPreviewKind() {
            return this.linkPreviewKind;
        }

        @Override
        public Optional<String> getLinkPreviewDescription() {
            return Optional.ofNullable(this.linkPreviewDescription);
        }

        @Override
        public Optional<Double> getLinkPreviewImageWidth() {
            return Optional.ofNullable(this.linkPreviewImageWidth);
        }

        @Override
        public AbstractUserMessageGenerated.EditionStatus getEditionStatus() {
            return this.editionStatus;
        }

        @Override
        public boolean isForwarded() {
            return this.forwarded;
        }

        @Override
        public Optional<Id<PollMessage>> getPollMessageId() {
            return this.pollMessage;
        }

        @Override
        public long getMissedMessageCount() {
            return this.missedMessageCount;
        }

        @Override
        public Optional<Id<InboundMessageEphemeralInfo>> getInboundMessageEphemeralInfoId() {
            return this.inboundMessageEphemeralInfo;
        }

        @Override
        public Id<ContactRef> getSenderId() {
            return this.sender;
        }

        @Override
        public Status getStatus() {
            return this.status;
        }

        @Override
        public boolean isBoxed() {
            return this.boxed;
        }

        @Override
        public boolean areContentTheSame(Object obj) {
            return this.equals(obj);
        }
    }

    public static interface Interface
    extends ReceivedMessageGenerated.Interface<InboundMessage> {
        @Override
        public Id<InboundMessage> getItemId();

        @Override
        public Id<Discussion> getDiscussionId();

        @Override
        public long getSenderSequenceNumber();

        @Override
        public double getSortIndex();

        @Override
        public long getTimestamp();

        @Override
        public Optional<String> getBody();

        @Override
        public Optional<Id<MessageRef>> getReplyToId();

        @Override
        public Optional<Id<Location>> getLocationId();

        @Override
        public AbstractUserMessageGenerated.WipeStatus getWipeStatus();

        @Override
        public int getTotalAttachmentCount();

        @Override
        public int getImageCount();

        @Override
        public AbstractUserMessageGenerated.LinkPreviewKind getLinkPreviewKind();

        @Override
        public Optional<String> getLinkPreviewDescription();

        @Override
        public Optional<Double> getLinkPreviewImageWidth();

        @Override
        public AbstractUserMessageGenerated.EditionStatus getEditionStatus();

        @Override
        public boolean isForwarded();

        @Override
        public Optional<Id<PollMessage>> getPollMessageId();

        @Override
        public long getMissedMessageCount();

        public Optional<Id<InboundMessageEphemeralInfo>> getInboundMessageEphemeralInfoId();

        public Id<ContactRef> getSenderId();

        public Status getStatus();

        public boolean isBoxed();
    }
}

