/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.attachment;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class OwnedAttachmentGenerated<T extends OwnedAttachmentGenerated<T>>
extends ReceivedAttachmentGenerated<T>
implements Table {
    public static final String TABLE_NAME = "owned_attachment_table";
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<OwnedAttachment, OwnedMessage> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES owned_message_table(gen_id) ON DELETE CASCADE")
    protected OwnedMessage fkMessage;
    public static final List<TableReference<?, OwnedAttachment>> references;

    public OwnedAttachmentGenerated() {
    }

    public OwnedAttachmentGenerated(long genId) {
        super(genId);
    }

    public OwnedAttachmentGenerated(long genId, Fyle fyle, OwnedIdentity ownedIdentity, Discussion discussion, long size, String filename, String mimeType, String thumbnailPath, boolean thumbnailComputationFailed, int idx, ReceivedAttachmentGenerated.Status status, byte[] engineMessageIdentifier, OwnedMessage message) {
        super(genId, fyle, ownedIdentity, discussion, size, filename, mimeType, thumbnailPath, thumbnailComputationFailed, idx, status, engineMessageIdentifier);
        this.fkMessage = message;
    }

    public Id<OwnedMessage> getMessageId() {
        return this.fkMessage.getItemId();
    }

    @Override
    public String toString() {
        return String.format("OwnedAttachment[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OwnedAttachmentGenerated casted = (OwnedAttachmentGenerated)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkMessage, casted.fkMessage);
    }

    public static OwnedAttachment mapRow(DatabaseResults databaseResults, String prefix) throws SQLException {
        long genId = AbstractTableGenerated.getLong(databaseResults, GEN_ID, prefix);
        long fyleId = AbstractTableGenerated.getLong(databaseResults, FK_FYLE, prefix);
        Fyle fyle = new Fyle(fyleId);
        long ownedIdentityId = AbstractTableGenerated.getLong(databaseResults, FK_OWNED_IDENTITY, prefix);
        OwnedIdentity ownedIdentity = new OwnedIdentity(ownedIdentityId);
        long discussionId = AbstractTableGenerated.getLong(databaseResults, FK_DISCUSSION, prefix);
        Discussion discussion = new Discussion(discussionId);
        long size = AbstractTableGenerated.getLong(databaseResults, SIZE, prefix);
        String filename = AbstractTableGenerated.getStringObj(databaseResults, FILENAME, prefix);
        String mimeType = AbstractTableGenerated.getStringObj(databaseResults, MIME_TYPE, prefix);
        String thumbnailPath = AbstractTableGenerated.getStringObj(databaseResults, THUMBNAIL_PATH, prefix);
        boolean thumbnailComputationFailed = AbstractTableGenerated.getBoolean(databaseResults, THUMBNAIL_COMPUTATION_FAILED, prefix);
        int idx = AbstractTableGenerated.getInt(databaseResults, IDX, prefix);
        String statusAsString = AbstractTableGenerated.getEnumName(databaseResults, STATUS, prefix);
        ReceivedAttachmentGenerated.Status status = ReceivedAttachmentGenerated.Status.valueOf(statusAsString);
        byte[] engineMessageIdentifier = AbstractTableGenerated.getBytesObj(databaseResults, ENGINE_MESSAGE_IDENTIFIER, prefix);
        long messageId = AbstractTableGenerated.getLong(databaseResults, FK_MESSAGE, prefix);
        OwnedMessage message = new OwnedMessage(messageId);
        return new OwnedAttachment(genId, fyle, ownedIdentity, discussion, size, filename, mimeType, thumbnailPath, thumbnailComputationFailed, idx, status, engineMessageIdentifier, message);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(ReceivedAttachmentGenerated.ALL_FIELDS);
        fields.add(FK_MESSAGE_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }
}

