/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.attachment;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class OutboundAttachmentGenerated<T extends OutboundAttachmentGenerated<T>>
extends AbstractAttachmentGenerated<T>
implements Table {
    public static final String TABLE_NAME = "outbound_attachment_table";
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<OutboundAttachment, OutboundMessage> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<OutboundAttachment, Status> STATUS = new Column.ObjectColumn("status", false);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES outbound_message_table(gen_id) ON DELETE CASCADE")
    protected OutboundMessage fkMessage;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    public static final List<TableReference<?, OutboundAttachment>> references;

    public OutboundAttachmentGenerated() {
    }

    public OutboundAttachmentGenerated(long genId) {
        super(genId);
    }

    public OutboundAttachmentGenerated(long genId, Fyle fyle, OwnedIdentity ownedIdentity, Discussion discussion, long size, String filename, String mimeType, String thumbnailPath, boolean thumbnailComputationFailed, int idx, OutboundMessage message, Status status) {
        super(genId, fyle, ownedIdentity, discussion, size, filename, mimeType, thumbnailPath, thumbnailComputationFailed, idx);
        this.fkMessage = message;
        this.status = status;
    }

    public Id<OutboundMessage> getMessageId() {
        return this.fkMessage.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return String.format("OutboundAttachment[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OutboundAttachmentGenerated casted = (OutboundAttachmentGenerated)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkMessage, casted.fkMessage) && this.status == casted.status;
    }

    public static OutboundAttachment mapRow(DatabaseResults databaseResults, String prefix) throws SQLException {
        long genId = AbstractTableGenerated.getLong(databaseResults, GEN_ID, prefix);
        long fyleId = AbstractTableGenerated.getLong(databaseResults, FK_FYLE, prefix);
        Fyle fyle = new Fyle(fyleId);
        long ownedIdentityId = AbstractTableGenerated.getLong(databaseResults, FK_OWNED_IDENTITY, prefix);
        OwnedIdentity ownedIdentity = new OwnedIdentity(ownedIdentityId);
        long discussionId = AbstractTableGenerated.getLong(databaseResults, FK_DISCUSSION, prefix);
        Discussion discussion = new Discussion(discussionId);
        long size = AbstractTableGenerated.getLong(databaseResults, SIZE, prefix);
        String filename = AbstractTableGenerated.getStringObj(databaseResults, FILENAME, prefix);
        String mimeType = AbstractTableGenerated.getStringObj(databaseResults, MIME_TYPE, prefix);
        String thumbnailPath = AbstractTableGenerated.getStringObj(databaseResults, THUMBNAIL_PATH, prefix);
        boolean thumbnailComputationFailed = AbstractTableGenerated.getBoolean(databaseResults, THUMBNAIL_COMPUTATION_FAILED, prefix);
        int idx = AbstractTableGenerated.getInt(databaseResults, IDX, prefix);
        long messageId = AbstractTableGenerated.getLong(databaseResults, FK_MESSAGE, prefix);
        OutboundMessage message = new OutboundMessage(messageId);
        String statusAsString = AbstractTableGenerated.getEnumName(databaseResults, STATUS, prefix);
        Status status = Status.valueOf(statusAsString);
        return new OutboundAttachment(genId, fyle, ownedIdentity, discussion, size, filename, mimeType, thumbnailPath, thumbnailComputationFailed, idx, message, status);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractAttachmentGenerated.ALL_FIELDS);
        fields.add(FK_MESSAGE_NAME);
        fields.add(STATUS_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(AttachmentRecipientInfo.class, AttachmentRecipientInfo.FK_ATTACHMENT, x -> Optional.of(x.getAttachmentId())));
        references = List.copyOf(refs);
    }

    public static enum Status implements IComparable<Status>
    {
        CANCELLED,
        FAILED,
        NO_CONTACT_RECIPIENTS,
        COPYING,
        DRAFT_READY,
        UNPROCESSED,
        UPLOADING,
        SENT,
        DELIVERED,
        READ;

    }
}

