/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class PreGroupGenerated<T extends PreGroupGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "pre_group_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<PreGroup, OwnedIdentity> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String BYTES_GROUP_IDENTIFIER_NAME = "bytes_group_identifier";
    public static final Column.ObjectColumn<PreGroup, byte[]> BYTES_GROUP_IDENTIFIER = new Column.ObjectColumn("bytes_group_identifier", false);
    private static final String NAME_NAME = "name";
    public static final Column.ObjectColumn<PreGroup, String> NAME = new Column.ObjectColumn("name", true);
    private static final String DESCRIPTION_NAME = "description";
    public static final Column.ObjectColumn<PreGroup, String> DESCRIPTION = new Column.ObjectColumn("description", true);
    private static final String PRE_GROUP_MEMBERS_NAMES_NAME = "pre_group_members_names";
    public static final Column.ObjectColumn<PreGroup, String> PRE_GROUP_MEMBERS_NAMES = new Column.ObjectColumn("pre_group_members_names", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentity fkOwnedIdentity;
    @DatabaseField(columnName="bytes_group_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesGroupIdentifier;
    @DatabaseField(columnName="name", dataType=DataType.STRING)
    protected String name;
    @DatabaseField(columnName="description", dataType=DataType.STRING)
    protected String description;
    @DatabaseField(columnName="pre_group_members_names", dataType=DataType.STRING)
    protected String preGroupMembersNames;
    public static final List<TableReference<?, PreGroup>> references;

    public PreGroupGenerated() {
    }

    public PreGroupGenerated(long genId) {
        super(genId);
    }

    public PreGroupGenerated(long genId, OwnedIdentity ownedIdentity, byte[] bytesGroupIdentifier, String name, String description, String preGroupMembersNames) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.bytesGroupIdentifier = bytesGroupIdentifier;
        this.name = name;
        this.description = description;
        this.preGroupMembersNames = preGroupMembersNames;
    }

    public Id<OwnedIdentity> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public byte[] getBytesGroupIdentifier() {
        return this.bytesGroupIdentifier;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getPreGroupMembersNames() {
        return Optional.ofNullable(this.preGroupMembersNames);
    }

    public void setPreGroupMembersNames(Optional<String> preGroupMembersNames) {
        this.preGroupMembersNames = preGroupMembersNames.orElse(null);
    }

    public String toString() {
        return String.format("PreGroup[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PreGroupGenerated casted = (PreGroupGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Arrays.equals(this.bytesGroupIdentifier, casted.bytesGroupIdentifier) && Objects.equals(this.name, casted.name) && Objects.equals(this.description, casted.description) && Objects.equals(this.preGroupMembersNames, casted.preGroupMembersNames);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_OWNED_IDENTITY_NAME);
        fields.add(BYTES_GROUP_IDENTIFIER_NAME);
        fields.add(NAME_NAME);
        fields.add(DESCRIPTION_NAME);
        fields.add(PRE_GROUP_MEMBERS_NAMES_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(Discussion.class, Discussion.FK_PRE_GROUP, x -> x.getPreGroupId()));
        refs.add(new TableReference(GroupMemberPermissions.class, GroupMemberPermissions.FK_PRE_GROUP, x -> x.getPreGroupId()));
        refs.add(new TableReference(PendingGroupMember.class, PendingGroupMember.FK_PRE_GROUP, x -> x.getPreGroupId()));
        references = List.copyOf(refs);
    }
}

