/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class PendingGroupMemberGenerated<T extends PendingGroupMemberGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "pending_group_member_table";
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<PendingGroupMember, Group> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String FK_PRE_GROUP_NAME = "fk_pre_group";
    public static final Column.ForeignColumn<PendingGroupMember, PreGroup> FK_PRE_GROUP = new Column.ForeignColumn("fk_pre_group", true);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<PendingGroupMember, ContactRef> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", false);
    private static final String FK_IDENTITY_DETAILS_NAME = "fk_identity_details";
    public static final Column.ForeignColumn<PendingGroupMember, IdentityDetails> FK_IDENTITY_DETAILS = new Column.ForeignColumn("fk_identity_details", false);
    private static final String SORT_DISPLAY_NAME_NAME = "sort_display_name";
    public static final Column.ObjectColumn<PendingGroupMember, byte[]> SORT_DISPLAY_NAME = new Column.ObjectColumn("sort_display_name", false);
    private static final String DECLINED_NAME = "declined";
    public static final Column.booleanColumn<PendingGroupMember> DECLINED = new Column.booleanColumn("declined");
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group REFERENCES group_table(gen_id) ON DELETE CASCADE")
    protected Group fkGroup;
    @DatabaseField(columnName="fk_pre_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_group REFERENCES pre_group_table(gen_id) ON DELETE CASCADE")
    protected PreGroup fkPreGroup;
    @DatabaseField(columnName="fk_contact_ref", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref NOT NULL REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRef fkContactRef;
    @DatabaseField(columnName="fk_identity_details", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_details NOT NULL REFERENCES identity_details_table(gen_id)")
    protected IdentityDetails fkIdentityDetails;
    @DatabaseField(columnName="sort_display_name", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] sortDisplayName;
    @DatabaseField(columnName="declined", dataType=DataType.BOOLEAN)
    protected boolean declined;
    @DatabaseField(columnName="virtual_fk_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_group, 0)) VIRTUAL")
    private long virtualGroup;
    @DatabaseField(columnName="virtual_fk_pre_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_pre_group, 0)) VIRTUAL")
    private long virtualPreGroup;
    public static final List<TableReference<?, PendingGroupMember>> references;

    public PendingGroupMemberGenerated() {
    }

    public PendingGroupMemberGenerated(long genId) {
        super(genId);
    }

    public PendingGroupMemberGenerated(long genId, Group group, PreGroup preGroup, ContactRef contactRef, IdentityDetails identityDetails, byte[] sortDisplayName, boolean declined) {
        super(genId);
        this.fkGroup = group;
        this.fkPreGroup = preGroup;
        this.fkContactRef = contactRef;
        this.fkIdentityDetails = identityDetails;
        this.sortDisplayName = sortDisplayName;
        this.declined = declined;
    }

    public Optional<Id<Group>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<PreGroup>> getPreGroupId() {
        return Optional.ofNullable(this.fkPreGroup).map(AbstractTableGenerated::getItemId);
    }

    public Id<ContactRef> getContactRefId() {
        return this.fkContactRef.getItemId();
    }

    public Id<IdentityDetails> getIdentityDetailsId() {
        return this.fkIdentityDetails.getItemId();
    }

    public byte[] getSortDisplayName() {
        return this.sortDisplayName;
    }

    public boolean isDeclined() {
        return this.declined;
    }

    public void setDeclined(boolean declined) {
        this.declined = declined;
    }

    public String toString() {
        return String.format("PendingGroupMember[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PendingGroupMemberGenerated casted = (PendingGroupMemberGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.fkPreGroup, casted.fkPreGroup) && Objects.equals(this.fkContactRef, casted.fkContactRef) && Objects.equals(this.fkIdentityDetails, casted.fkIdentityDetails) && Arrays.equals(this.sortDisplayName, casted.sortDisplayName) && this.declined == casted.declined;
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_GROUP_NAME);
        fields.add(FK_PRE_GROUP_NAME);
        fields.add(FK_CONTACT_REF_NAME);
        fields.add(FK_IDENTITY_DETAILS_NAME);
        fields.add(SORT_DISPLAY_NAME_NAME);
        fields.add(DECLINED_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(GroupMemberPermissions.class, GroupMemberPermissions.FK_PENDING_GROUP_MEMBER, x -> x.getPendingGroupMemberId()));
        references = List.copyOf(refs);
    }
}

