/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class OwnedIdentityGenerated<T extends OwnedIdentityGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "owned_identity_table";
    private static final String BYTES_OWNED_IDENTITY_NAME = "bytes_owned_identity";
    public static final Column.ObjectColumn<OwnedIdentity, byte[]> BYTES_OWNED_IDENTITY = new Column.ObjectColumn("bytes_owned_identity", false);
    private static final String NICKNAME_NAME = "nickname";
    public static final Column.ObjectColumn<OwnedIdentity, String> NICKNAME = new Column.ObjectColumn("nickname", true);
    private static final String FK_IDENTITY_DETAILS_NAME = "fk_identity_details";
    public static final Column.ForeignColumn<OwnedIdentity, IdentityDetails> FK_IDENTITY_DETAILS = new Column.ForeignColumn("fk_identity_details", false);
    private static final String API_KEY_STATUS_NAME = "api_key_status";
    public static final Column.ObjectColumn<OwnedIdentity, ApiKeyStatus> API_KEY_STATUS = new Column.ObjectColumn("api_key_status", false);
    private static final String UNPUBLISHED_DETAILS_NAME = "unpublished_details";
    public static final Column.ObjectColumn<OwnedIdentity, UnpublishedDetails> UNPUBLISHED_DETAILS = new Column.ObjectColumn("unpublished_details", false);
    private static final String API_KEY_PERMISSIONS_NAME = "api_key_permissions";
    public static final Column.longColumn<OwnedIdentity> API_KEY_PERMISSIONS = new Column.longColumn("api_key_permissions");
    private static final String API_KEY_EXPIRATION_TIMESTAMP_NAME = "api_key_expiration_timestamp";
    public static final Column.ObjectColumn<OwnedIdentity, Long> API_KEY_EXPIRATION_TIMESTAMP = new Column.ObjectColumn("api_key_expiration_timestamp", true);
    private static final String KEYCLOAK_MANAGED_NAME = "keycloak_managed";
    public static final Column.booleanColumn<OwnedIdentity> KEYCLOAK_MANAGED = new Column.booleanColumn("keycloak_managed");
    private static final String ACTIVE_NAME = "active";
    public static final Column.booleanColumn<OwnedIdentity> ACTIVE = new Column.booleanColumn("active");
    private static final String FK_CAPABILITIES_NAME = "fk_capabilities";
    public static final Column.ForeignColumn<OwnedIdentity, Capabilities> FK_CAPABILITIES = new Column.ForeignColumn("fk_capabilities", false);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="bytes_owned_identity", unique=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesOwnedIdentity;
    @DatabaseField(columnName="nickname", dataType=DataType.STRING)
    protected String nickname;
    @DatabaseField(columnName="fk_identity_details", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_details UNIQUE NOT NULL REFERENCES identity_details_table(gen_id)")
    protected IdentityDetails fkIdentityDetails;
    @DatabaseField(columnName="api_key_status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected ApiKeyStatus apiKeyStatus;
    @DatabaseField(columnName="unpublished_details", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected UnpublishedDetails unpublishedDetails;
    @DatabaseField(columnName="api_key_permissions", dataType=DataType.LONG)
    protected long apiKeyPermissions;
    @DatabaseField(columnName="api_key_expiration_timestamp", dataType=DataType.LONG_OBJ)
    protected Long apiKeyExpirationTimestamp;
    @DatabaseField(columnName="keycloak_managed", dataType=DataType.BOOLEAN)
    protected boolean keycloakManaged;
    @DatabaseField(columnName="active", dataType=DataType.BOOLEAN)
    protected boolean active;
    @DatabaseField(columnName="fk_capabilities", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_capabilities UNIQUE NOT NULL REFERENCES capabilities_table(gen_id)")
    protected Capabilities fkCapabilities;
    public static final List<TableReference<?, OwnedIdentity>> references;

    public OwnedIdentityGenerated() {
    }

    public OwnedIdentityGenerated(long genId) {
        super(genId);
    }

    public OwnedIdentityGenerated(long genId, byte[] bytesOwnedIdentity, String nickname, IdentityDetails identityDetails, ApiKeyStatus apiKeyStatus, UnpublishedDetails unpublishedDetails, long apiKeyPermissions, Long apiKeyExpirationTimestamp, boolean keycloakManaged, boolean active, Capabilities capabilities) {
        super(genId);
        this.bytesOwnedIdentity = bytesOwnedIdentity;
        this.nickname = nickname;
        this.fkIdentityDetails = identityDetails;
        this.apiKeyStatus = apiKeyStatus;
        this.unpublishedDetails = unpublishedDetails;
        this.apiKeyPermissions = apiKeyPermissions;
        this.apiKeyExpirationTimestamp = apiKeyExpirationTimestamp;
        this.keycloakManaged = keycloakManaged;
        this.active = active;
        this.fkCapabilities = capabilities;
    }

    public byte[] getBytesOwnedIdentity() {
        return this.bytesOwnedIdentity;
    }

    public Optional<String> getNickname() {
        return Optional.ofNullable(this.nickname);
    }

    public Id<IdentityDetails> getIdentityDetailsId() {
        return this.fkIdentityDetails.getItemId();
    }

    public ApiKeyStatus getApiKeyStatus() {
        return this.apiKeyStatus;
    }

    public void setApiKeyStatus(ApiKeyStatus apiKeyStatus) {
        this.apiKeyStatus = apiKeyStatus;
    }

    public UnpublishedDetails getUnpublishedDetails() {
        return this.unpublishedDetails;
    }

    public void setUnpublishedDetails(UnpublishedDetails unpublishedDetails) {
        this.unpublishedDetails = unpublishedDetails;
    }

    public long getApiKeyPermissions() {
        return this.apiKeyPermissions;
    }

    public Optional<Long> getApiKeyExpirationTimestamp() {
        return Optional.ofNullable(this.apiKeyExpirationTimestamp);
    }

    public void setApiKeyExpirationTimestamp(Optional<Long> apiKeyExpirationTimestamp) {
        this.apiKeyExpirationTimestamp = apiKeyExpirationTimestamp.orElse(null);
    }

    public boolean isKeycloakManaged() {
        return this.keycloakManaged;
    }

    public boolean isActive() {
        return this.active;
    }

    public Id<Capabilities> getCapabilitiesId() {
        return this.fkCapabilities.getItemId();
    }

    public String toString() {
        return String.format("OwnedIdentity[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OwnedIdentityGenerated casted = (OwnedIdentityGenerated)this.getClazz().cast(obj);
        return Arrays.equals(this.bytesOwnedIdentity, casted.bytesOwnedIdentity) && Objects.equals(this.nickname, casted.nickname) && Objects.equals(this.fkIdentityDetails, casted.fkIdentityDetails) && this.apiKeyStatus == casted.apiKeyStatus && this.unpublishedDetails == casted.unpublishedDetails && this.apiKeyPermissions == casted.apiKeyPermissions && Objects.equals(this.apiKeyExpirationTimestamp, casted.apiKeyExpirationTimestamp) && this.keycloakManaged == casted.keycloakManaged && this.active == casted.active && Objects.equals(this.fkCapabilities, casted.fkCapabilities);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(BYTES_OWNED_IDENTITY_NAME);
        fields.add(NICKNAME_NAME);
        fields.add(FK_IDENTITY_DETAILS_NAME);
        fields.add(API_KEY_STATUS_NAME);
        fields.add(UNPUBLISHED_DETAILS_NAME);
        fields.add(API_KEY_PERMISSIONS_NAME);
        fields.add(API_KEY_EXPIRATION_TIMESTAMP_NAME);
        fields.add(KEYCLOAK_MANAGED_NAME);
        fields.add(ACTIVE_NAME);
        fields.add(FK_CAPABILITIES_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(InboundAttachment.class, InboundAttachment.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(OwnedAttachment.class, OwnedAttachment.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(OutboundAttachment.class, OutboundAttachment.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(Contact.class, Contact.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(ContactGroupJoin.class, ContactGroupJoin.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(ContactRef.class, ContactRef.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(Discussion.class, Discussion.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(Group.class, Group.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(GroupMemberPermissions.class, GroupMemberPermissions.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(IdentityRef.class, IdentityRef.FK_OWNED_IDENTITY, x -> x.getOwnedIdentityId()));
        refs.add(new TableReference(Invitation.class, Invitation.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(OwnedDevice.class, OwnedDevice.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        refs.add(new TableReference(PreGroup.class, PreGroup.FK_OWNED_IDENTITY, x -> Optional.of(x.getOwnedIdentityId())));
        references = List.copyOf(refs);
    }

    public static enum ApiKeyStatus implements IComparable<ApiKeyStatus>
    {
        UNKNOWN,
        VALID,
        LICENSES_EXHAUSTED,
        EXPIRED,
        OPEN_BETA_KEY,
        FREE_TRIAL_KEY,
        AWAITING_PAYMENT_GRACE_PERIOD,
        AWAITING_PAYMENT_ON_HOLD,
        FREE_TRIAL_KEY_EXPIRED;

    }

    public static enum UnpublishedDetails implements IComparable<UnpublishedDetails>
    {
        NOTHING_NEW,
        EXIST;

    }
}

