/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class OwnedDeviceGenerated<T extends OwnedDeviceGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "owned_device_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<OwnedDevice, OwnedIdentity> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String BYTES_DEVICE_UID_NAME = "bytes_device_uid";
    public static final Column.ObjectColumn<OwnedDevice, byte[]> BYTES_DEVICE_UID = new Column.ObjectColumn("bytes_device_uid", false);
    private static final String DISPLAY_NAME_NAME = "display_name";
    public static final Column.ObjectColumn<OwnedDevice, String> DISPLAY_NAME = new Column.ObjectColumn("display_name", true);
    private static final String CURRENT_DEVICE_NAME = "current_device";
    public static final Column.booleanColumn<OwnedDevice> CURRENT_DEVICE = new Column.booleanColumn("current_device");
    private static final String CHANNEL_CONFIRMED_NAME = "channel_confirmed";
    public static final Column.booleanColumn<OwnedDevice> CHANNEL_CONFIRMED = new Column.booleanColumn("channel_confirmed");
    private static final String LAST_REGISTRATION_TIMESTAMP_NAME = "last_registration_timestamp";
    public static final Column.ObjectColumn<OwnedDevice, Long> LAST_REGISTRATION_TIMESTAMP = new Column.ObjectColumn("last_registration_timestamp", true);
    private static final String EXPIRATION_TIMESTAMP_NAME = "expiration_timestamp";
    public static final Column.ObjectColumn<OwnedDevice, Long> EXPIRATION_TIMESTAMP = new Column.ObjectColumn("expiration_timestamp", true);
    private static final String HAS_PREKEY_NAME = "has_prekey";
    public static final Column.booleanColumn<OwnedDevice> HAS_PREKEY = new Column.booleanColumn("has_prekey");
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentity fkOwnedIdentity;
    @DatabaseField(columnName="bytes_device_uid", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesDeviceUid;
    @DatabaseField(columnName="display_name", dataType=DataType.STRING)
    protected String displayName;
    @DatabaseField(columnName="current_device", dataType=DataType.BOOLEAN)
    protected boolean currentDevice;
    @DatabaseField(columnName="channel_confirmed", dataType=DataType.BOOLEAN)
    protected boolean channelConfirmed;
    @DatabaseField(columnName="last_registration_timestamp", dataType=DataType.LONG_OBJ)
    protected Long lastRegistrationTimestamp;
    @DatabaseField(columnName="expiration_timestamp", dataType=DataType.LONG_OBJ)
    protected Long expirationTimestamp;
    @DatabaseField(columnName="has_prekey", dataType=DataType.BOOLEAN)
    protected boolean hasPrekey;
    public static final List<TableReference<?, OwnedDevice>> references;

    public OwnedDeviceGenerated() {
    }

    public OwnedDeviceGenerated(long genId) {
        super(genId);
    }

    public OwnedDeviceGenerated(long genId, OwnedIdentity ownedIdentity, byte[] bytesDeviceUid, String displayName, boolean currentDevice, boolean channelConfirmed, Long lastRegistrationTimestamp, Long expirationTimestamp, boolean hasPrekey) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.bytesDeviceUid = bytesDeviceUid;
        this.displayName = displayName;
        this.currentDevice = currentDevice;
        this.channelConfirmed = channelConfirmed;
        this.lastRegistrationTimestamp = lastRegistrationTimestamp;
        this.expirationTimestamp = expirationTimestamp;
        this.hasPrekey = hasPrekey;
    }

    public Id<OwnedIdentity> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public byte[] getBytesDeviceUid() {
        return this.bytesDeviceUid;
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public void setDisplayName(Optional<String> displayName) {
        this.displayName = displayName.orElse(null);
    }

    public boolean isCurrentDevice() {
        return this.currentDevice;
    }

    public void setCurrentDevice(boolean currentDevice) {
        this.currentDevice = currentDevice;
    }

    public boolean isChannelConfirmed() {
        return this.channelConfirmed;
    }

    public void setChannelConfirmed(boolean channelConfirmed) {
        this.channelConfirmed = channelConfirmed;
    }

    public Optional<Long> getLastRegistrationTimestamp() {
        return Optional.ofNullable(this.lastRegistrationTimestamp);
    }

    public void setLastRegistrationTimestamp(Optional<Long> lastRegistrationTimestamp) {
        this.lastRegistrationTimestamp = lastRegistrationTimestamp.orElse(null);
    }

    public Optional<Long> getExpirationTimestamp() {
        return Optional.ofNullable(this.expirationTimestamp);
    }

    public void setExpirationTimestamp(Optional<Long> expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp.orElse(null);
    }

    public boolean isHasPrekey() {
        return this.hasPrekey;
    }

    public void setHasPrekey(boolean hasPrekey) {
        this.hasPrekey = hasPrekey;
    }

    public String toString() {
        return String.format("OwnedDevice[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OwnedDeviceGenerated casted = (OwnedDeviceGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Arrays.equals(this.bytesDeviceUid, casted.bytesDeviceUid) && Objects.equals(this.displayName, casted.displayName) && this.currentDevice == casted.currentDevice && this.channelConfirmed == casted.channelConfirmed && Objects.equals(this.lastRegistrationTimestamp, casted.lastRegistrationTimestamp) && Objects.equals(this.expirationTimestamp, casted.expirationTimestamp) && this.hasPrekey == casted.hasPrekey;
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_OWNED_IDENTITY_NAME);
        fields.add(BYTES_DEVICE_UID_NAME);
        fields.add(DISPLAY_NAME_NAME);
        fields.add(CURRENT_DEVICE_NAME);
        fields.add(CHANNEL_CONFIRMED_NAME);
        fields.add(LAST_REGISTRATION_TIMESTAMP_NAME);
        fields.add(EXPIRATION_TIMESTAMP_NAME);
        fields.add(HAS_PREKEY_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }
}

