/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class InvitationGenerated<T extends InvitationGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "invitation_table";
    private static final String STATE_NAME = "state";
    public static final Column.ObjectColumn<Invitation, State> STATE = new Column.ObjectColumn("state", false);
    private static final String DIALOG_UUID_NAME = "dialog_uuid";
    public static final Column.ObjectColumn<Invitation, UUID> DIALOG_UUID = new Column.ObjectColumn("dialog_uuid", false);
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<Invitation, OwnedIdentity> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<Invitation, Discussion> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<Invitation> TIMESTAMP = new Column.longColumn("timestamp");
    private static final String ENCODED_DATA_NAME = "encoded_data";
    public static final Column.ObjectColumn<Invitation, byte[]> ENCODED_DATA = new Column.ObjectColumn("encoded_data", false);
    private static final String SAS_TO_DISPLAY_NAME = "sas_to_display";
    public static final Column.ObjectColumn<Invitation, byte[]> SAS_TO_DISPLAY = new Column.ObjectColumn("sas_to_display", true);
    private static final String FK_MEDIATOR_REF_NAME = "fk_mediator_ref";
    public static final Column.ForeignColumn<Invitation, ContactRef> FK_MEDIATOR_REF = new Column.ForeignColumn("fk_mediator_ref", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="state", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected State state;
    @DatabaseField(columnName="dialog_uuid", unique=true, canBeNull=false, dataType=DataType.UUID)
    protected UUID dialogUuid;
    @DatabaseField(columnName="fk_owned_identity", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentity fkOwnedIdentity;
    @DatabaseField(columnName="fk_discussion", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected Discussion fkDiscussion;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;
    @DatabaseField(columnName="encoded_data", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] encodedData;
    @DatabaseField(columnName="sas_to_display", dataType=DataType.BYTE_ARRAY)
    protected byte[] sasToDisplay;
    @DatabaseField(columnName="fk_mediator_ref", foreign=true, foreignAutoRefresh=true, index=true, columnDefinition="LONG CONSTRAINT fk_mediator_ref REFERENCES contact_ref_table(gen_id) ON DELETE SET NULL")
    protected ContactRef fkMediatorRef;
    public static final List<TableReference<?, Invitation>> references;

    public InvitationGenerated() {
    }

    public InvitationGenerated(long genId) {
        super(genId);
    }

    public InvitationGenerated(long genId, State state, UUID dialogUuid, OwnedIdentity ownedIdentity, Discussion discussion, long timestamp, byte[] encodedData, byte[] sasToDisplay, ContactRef mediatorRef) {
        super(genId);
        this.state = state;
        this.dialogUuid = dialogUuid;
        this.fkOwnedIdentity = ownedIdentity;
        this.fkDiscussion = discussion;
        this.timestamp = timestamp;
        this.encodedData = encodedData;
        this.sasToDisplay = sasToDisplay;
        this.fkMediatorRef = mediatorRef;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public UUID getDialogUuid() {
        return this.dialogUuid;
    }

    public Id<OwnedIdentity> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Discussion getDiscussion() {
        return this.fkDiscussion;
    }

    public void setDiscussion(Discussion fkDiscussion) {
        this.fkDiscussion = fkDiscussion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getEncodedData() {
        return this.encodedData;
    }

    public Optional<byte[]> getSasToDisplay() {
        return Optional.ofNullable(this.sasToDisplay);
    }

    public Optional<ContactRef> getMediatorRef() {
        return Optional.ofNullable(this.fkMediatorRef);
    }

    public void setMediatorRef(Optional<ContactRef> fkMediatorRef) {
        this.fkMediatorRef = fkMediatorRef.orElse(null);
    }

    public String toString() {
        return String.format("Invitation[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        InvitationGenerated casted = (InvitationGenerated)this.getClazz().cast(obj);
        return this.state == casted.state && Objects.equals(this.dialogUuid, casted.dialogUuid) && Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkDiscussion, casted.fkDiscussion) && this.timestamp == casted.timestamp && Arrays.equals(this.encodedData, casted.encodedData) && Arrays.equals(this.sasToDisplay, casted.sasToDisplay) && Objects.equals(this.fkMediatorRef, casted.fkMediatorRef);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(STATE_NAME);
        fields.add(DIALOG_UUID_NAME);
        fields.add(FK_OWNED_IDENTITY_NAME);
        fields.add(FK_DISCUSSION_NAME);
        fields.add(TIMESTAMP_NAME);
        fields.add(ENCODED_DATA_NAME);
        fields.add(SAS_TO_DISPLAY_NAME);
        fields.add(FK_MEDIATOR_REF_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }

    public static enum State implements IComparable<State>
    {
        INVITATION_WAIT_YOU_TO_ACCEPT,
        INVITATION_WAIT_IT_TO_ACCEPT,
        INVITATION_STATUS_IN_PROGRESS,
        INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE,
        INVITATION_WAIT_IT_FOR_SAS_EXCHANGE,
        INTRODUCTION_WAIT_IT_TO_ACCEPT,
        INTRODUCTION_WAIT_YOU_TO_ACCEPT,
        GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT,
        ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT,
        ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT,
        GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT,
        GROUP_V2_INVITATION_ACCEPTED,
        GROUP_V2_INVITATION_FROZEN;

    }
}

