/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class IdentityDetailsGenerated<T extends IdentityDetailsGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "identity_details_table";
    private static final String FIRST_NAME_NAME = "first_name";
    public static final Column.ObjectColumn<IdentityDetails, String> FIRST_NAME = new Column.ObjectColumn("first_name", true);
    private static final String LAST_NAME_NAME = "last_name";
    public static final Column.ObjectColumn<IdentityDetails, String> LAST_NAME = new Column.ObjectColumn("last_name", true);
    private static final String COMPANY_NAME = "company";
    public static final Column.ObjectColumn<IdentityDetails, String> COMPANY = new Column.ObjectColumn("company", true);
    private static final String POSITION_NAME = "position";
    public static final Column.ObjectColumn<IdentityDetails, String> POSITION = new Column.ObjectColumn("position", true);
    private static final String PHOTO_URL_NAME = "photo_url";
    public static final Column.ObjectColumn<IdentityDetails, String> PHOTO_URL = new Column.ObjectColumn("photo_url", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="first_name", dataType=DataType.STRING)
    protected String firstName;
    @DatabaseField(columnName="last_name", dataType=DataType.STRING)
    protected String lastName;
    @DatabaseField(columnName="company", dataType=DataType.STRING)
    protected String company;
    @DatabaseField(columnName="position", dataType=DataType.STRING)
    protected String position;
    @DatabaseField(columnName="photo_url", dataType=DataType.STRING)
    protected String photoUrl;
    public static final List<TableReference<?, IdentityDetails>> references;

    public IdentityDetailsGenerated() {
    }

    public IdentityDetailsGenerated(long genId) {
        super(genId);
    }

    public IdentityDetailsGenerated(long genId, String firstName, String lastName, String company, String position, String photoUrl) {
        super(genId);
        this.firstName = firstName;
        this.lastName = lastName;
        this.company = company;
        this.position = position;
        this.photoUrl = photoUrl;
    }

    public Optional<String> getFirstName() {
        return Optional.ofNullable(this.firstName);
    }

    public Optional<String> getLastName() {
        return Optional.ofNullable(this.lastName);
    }

    public Optional<String> getCompany() {
        return Optional.ofNullable(this.company);
    }

    public Optional<String> getPosition() {
        return Optional.ofNullable(this.position);
    }

    public Optional<String> getPhotoUrl() {
        return Optional.ofNullable(this.photoUrl);
    }

    public void setPhotoUrl(Optional<String> photoUrl) {
        this.photoUrl = photoUrl.orElse(null);
    }

    public String toString() {
        return String.format("IdentityDetails[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        IdentityDetailsGenerated casted = (IdentityDetailsGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.firstName, casted.firstName) && Objects.equals(this.lastName, casted.lastName) && Objects.equals(this.company, casted.company) && Objects.equals(this.position, casted.position) && Objects.equals(this.photoUrl, casted.photoUrl);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FIRST_NAME_NAME);
        fields.add(LAST_NAME_NAME);
        fields.add(COMPANY_NAME);
        fields.add(POSITION_NAME);
        fields.add(PHOTO_URL_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(Contact.class, Contact.FK_IDENTITY_DETAILS, x -> Optional.of(x.getIdentityDetailsId())));
        refs.add(new TableReference(OwnedIdentity.class, OwnedIdentity.FK_IDENTITY_DETAILS, x -> Optional.of(x.getIdentityDetailsId())));
        refs.add(new TableReference(PendingGroupMember.class, PendingGroupMember.FK_IDENTITY_DETAILS, x -> Optional.of(x.getIdentityDetailsId())));
        refs.add(new TableReference(PreContact.class, PreContact.FK_IDENTITY_DETAILS, x -> Optional.of(x.getIdentityDetailsId())));
        references = List.copyOf(refs);
    }
}

