/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class GroupMemberPermissionsGenerated<T extends GroupMemberPermissionsGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "group_member_permissions_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<GroupMemberPermissions, OwnedIdentity> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<GroupMemberPermissions, Group> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String FK_PRE_GROUP_NAME = "fk_pre_group";
    public static final Column.ForeignColumn<GroupMemberPermissions, PreGroup> FK_PRE_GROUP = new Column.ForeignColumn("fk_pre_group", true);
    private static final String FK_CONTACT_GROUP_JOIN_NAME = "fk_contact_group_join";
    public static final Column.ForeignColumn<GroupMemberPermissions, ContactGroupJoin> FK_CONTACT_GROUP_JOIN = new Column.ForeignColumn("fk_contact_group_join", true);
    private static final String FK_PENDING_GROUP_MEMBER_NAME = "fk_pending_group_member";
    public static final Column.ForeignColumn<GroupMemberPermissions, PendingGroupMember> FK_PENDING_GROUP_MEMBER = new Column.ForeignColumn("fk_pending_group_member", true);
    private static final String ADMIN_NAME = "admin";
    public static final Column.booleanColumn<GroupMemberPermissions> ADMIN = new Column.booleanColumn("admin");
    private static final String REMOTE_DELETE_ANYTHING_NAME = "remote_delete_anything";
    public static final Column.booleanColumn<GroupMemberPermissions> REMOTE_DELETE_ANYTHING = new Column.booleanColumn("remote_delete_anything");
    private static final String EDIT_OR_REMOTE_DELETE_OWN_MESSAGES_NAME = "edit_or_remote_delete_own_messages";
    public static final Column.booleanColumn<GroupMemberPermissions> EDIT_OR_REMOTE_DELETE_OWN_MESSAGES = new Column.booleanColumn("edit_or_remote_delete_own_messages");
    private static final String CHANGE_SETTINGS_NAME = "change_settings";
    public static final Column.booleanColumn<GroupMemberPermissions> CHANGE_SETTINGS = new Column.booleanColumn("change_settings");
    private static final String SEND_MESSAGE_NAME = "send_message";
    public static final Column.booleanColumn<GroupMemberPermissions> SEND_MESSAGE = new Column.booleanColumn("send_message");
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentity fkOwnedIdentity;
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group REFERENCES group_table(gen_id) ON DELETE CASCADE")
    protected Group fkGroup;
    @DatabaseField(columnName="fk_pre_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_group REFERENCES pre_group_table(gen_id) ON DELETE CASCADE")
    protected PreGroup fkPreGroup;
    @DatabaseField(columnName="fk_contact_group_join", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_group_join REFERENCES contact_group_join_table(gen_id) ON DELETE CASCADE")
    protected ContactGroupJoin fkContactGroupJoin;
    @DatabaseField(columnName="fk_pending_group_member", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pending_group_member REFERENCES pending_group_member_table(gen_id) ON DELETE CASCADE")
    protected PendingGroupMember fkPendingGroupMember;
    @DatabaseField(columnName="admin", dataType=DataType.BOOLEAN)
    protected boolean admin;
    @DatabaseField(columnName="remote_delete_anything", dataType=DataType.BOOLEAN)
    protected boolean remoteDeleteAnything;
    @DatabaseField(columnName="edit_or_remote_delete_own_messages", dataType=DataType.BOOLEAN)
    protected boolean editOrRemoteDeleteOwnMessages;
    @DatabaseField(columnName="change_settings", dataType=DataType.BOOLEAN)
    protected boolean changeSettings;
    @DatabaseField(columnName="send_message", dataType=DataType.BOOLEAN)
    protected boolean sendMessage;
    @DatabaseField(columnName="virtual_fk_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_group, 0)) VIRTUAL")
    private long virtualGroup;
    @DatabaseField(columnName="virtual_fk_pre_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_pre_group, 0)) VIRTUAL")
    private long virtualPreGroup;
    @DatabaseField(columnName="virtual_fk_contact_group_join", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_contact_group_join, 0)) VIRTUAL")
    private long virtualContactGroupJoin;
    @DatabaseField(columnName="virtual_fk_pending_group_member", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_pending_group_member, 0)) VIRTUAL")
    private long virtualPendingGroupMember;
    public static final List<TableReference<?, GroupMemberPermissions>> references;

    public GroupMemberPermissionsGenerated() {
    }

    public GroupMemberPermissionsGenerated(long genId) {
        super(genId);
    }

    public GroupMemberPermissionsGenerated(long genId, OwnedIdentity ownedIdentity, Group group, PreGroup preGroup, ContactGroupJoin contactGroupJoin, PendingGroupMember pendingGroupMember, boolean admin, boolean remoteDeleteAnything, boolean editOrRemoteDeleteOwnMessages, boolean changeSettings, boolean sendMessage) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkGroup = group;
        this.fkPreGroup = preGroup;
        this.fkContactGroupJoin = contactGroupJoin;
        this.fkPendingGroupMember = pendingGroupMember;
        this.admin = admin;
        this.remoteDeleteAnything = remoteDeleteAnything;
        this.editOrRemoteDeleteOwnMessages = editOrRemoteDeleteOwnMessages;
        this.changeSettings = changeSettings;
        this.sendMessage = sendMessage;
    }

    public Id<OwnedIdentity> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Optional<Id<Group>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<PreGroup>> getPreGroupId() {
        return Optional.ofNullable(this.fkPreGroup).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<ContactGroupJoin>> getContactGroupJoinId() {
        return Optional.ofNullable(this.fkContactGroupJoin).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<PendingGroupMember>> getPendingGroupMemberId() {
        return Optional.ofNullable(this.fkPendingGroupMember).map(AbstractTableGenerated::getItemId);
    }

    public boolean hasPermissionAdmin() {
        return this.admin;
    }

    public boolean hasPermissionRemoteDeleteAnything() {
        return this.remoteDeleteAnything;
    }

    public boolean hasPermissionEditOrRemoteDeleteOwnMessages() {
        return this.editOrRemoteDeleteOwnMessages;
    }

    public boolean hasPermissionChangeSettings() {
        return this.changeSettings;
    }

    public boolean hasPermissionSendMessage() {
        return this.sendMessage;
    }

    public String toString() {
        return String.format("GroupMemberPermissions[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        GroupMemberPermissionsGenerated casted = (GroupMemberPermissionsGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.fkPreGroup, casted.fkPreGroup) && Objects.equals(this.fkContactGroupJoin, casted.fkContactGroupJoin) && Objects.equals(this.fkPendingGroupMember, casted.fkPendingGroupMember) && this.admin == casted.admin && this.remoteDeleteAnything == casted.remoteDeleteAnything && this.editOrRemoteDeleteOwnMessages == casted.editOrRemoteDeleteOwnMessages && this.changeSettings == casted.changeSettings && this.sendMessage == casted.sendMessage;
    }

    public static GroupMemberPermissions mapRow(DatabaseResults databaseResults, String prefix) throws SQLException {
        long genId = AbstractTableGenerated.getLong(databaseResults, GEN_ID, prefix);
        long ownedIdentityId = AbstractTableGenerated.getLong(databaseResults, FK_OWNED_IDENTITY, prefix);
        OwnedIdentity ownedIdentity = new OwnedIdentity(ownedIdentityId);
        Long groupId = AbstractTableGenerated.getLongObj(databaseResults, FK_GROUP, prefix);
        Group group = groupId == null ? null : new Group(groupId);
        Long preGroupId = AbstractTableGenerated.getLongObj(databaseResults, FK_PRE_GROUP, prefix);
        PreGroup preGroup = preGroupId == null ? null : new PreGroup(preGroupId);
        Long contactGroupJoinId = AbstractTableGenerated.getLongObj(databaseResults, FK_CONTACT_GROUP_JOIN, prefix);
        ContactGroupJoin contactGroupJoin = contactGroupJoinId == null ? null : new ContactGroupJoin(contactGroupJoinId);
        Long pendingGroupMemberId = AbstractTableGenerated.getLongObj(databaseResults, FK_PENDING_GROUP_MEMBER, prefix);
        PendingGroupMember pendingGroupMember = pendingGroupMemberId == null ? null : new PendingGroupMember(pendingGroupMemberId);
        boolean admin = AbstractTableGenerated.getBoolean(databaseResults, ADMIN, prefix);
        boolean remoteDeleteAnything = AbstractTableGenerated.getBoolean(databaseResults, REMOTE_DELETE_ANYTHING, prefix);
        boolean editOrRemoteDeleteOwnMessages = AbstractTableGenerated.getBoolean(databaseResults, EDIT_OR_REMOTE_DELETE_OWN_MESSAGES, prefix);
        boolean changeSettings = AbstractTableGenerated.getBoolean(databaseResults, CHANGE_SETTINGS, prefix);
        boolean sendMessage = AbstractTableGenerated.getBoolean(databaseResults, SEND_MESSAGE, prefix);
        return new GroupMemberPermissions(genId, ownedIdentity, group, preGroup, contactGroupJoin, pendingGroupMember, admin, remoteDeleteAnything, editOrRemoteDeleteOwnMessages, changeSettings, sendMessage);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_OWNED_IDENTITY_NAME);
        fields.add(FK_GROUP_NAME);
        fields.add(FK_PRE_GROUP_NAME);
        fields.add(FK_CONTACT_GROUP_JOIN_NAME);
        fields.add(FK_PENDING_GROUP_MEMBER_NAME);
        fields.add(ADMIN_NAME);
        fields.add(REMOTE_DELETE_ANYTHING_NAME);
        fields.add(EDIT_OR_REMOTE_DELETE_OWN_MESSAGES_NAME);
        fields.add(CHANGE_SETTINGS_NAME);
        fields.add(SEND_MESSAGE_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }
}

