/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.InboundMessageSequenceInterval;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class ContactRefGenerated<T extends ContactRefGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "contact_ref_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<ContactRef, OwnedIdentity> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String BYTES_CONTACT_IDENTITY_NAME = "bytes_contact_identity";
    public static final Column.ObjectColumn<ContactRef, byte[]> BYTES_CONTACT_IDENTITY = new Column.ObjectColumn("bytes_contact_identity", false);
    private static final String FK_CONTACT_NAME = "fk_contact";
    public static final Column.ForeignColumn<ContactRef, Contact> FK_CONTACT = new Column.ForeignColumn("fk_contact", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentity fkOwnedIdentity;
    @DatabaseField(columnName="bytes_contact_identity", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesContactIdentity;
    @DatabaseField(columnName="fk_contact", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact UNIQUE REFERENCES contact_table(gen_id) ON DELETE SET NULL")
    protected Contact fkContact;
    public static final List<TableReference<?, ContactRef>> references;

    public ContactRefGenerated() {
    }

    public ContactRefGenerated(long genId) {
        super(genId);
    }

    public ContactRefGenerated(long genId, OwnedIdentity ownedIdentity, byte[] bytesContactIdentity, Contact contact) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.bytesContactIdentity = bytesContactIdentity;
        this.fkContact = contact;
    }

    public Id<OwnedIdentity> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public byte[] getBytesContactIdentity() {
        return this.bytesContactIdentity;
    }

    public Optional<Id<Contact>> getContactId() {
        return Optional.ofNullable(this.fkContact).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("ContactRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ContactRefGenerated casted = (ContactRefGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Arrays.equals(this.bytesContactIdentity, casted.bytesContactIdentity) && Objects.equals(this.fkContact, casted.fkContact);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_OWNED_IDENTITY_NAME);
        fields.add(BYTES_CONTACT_IDENTITY_NAME);
        fields.add(FK_CONTACT_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(InboundMessage.class, InboundMessage.FK_SENDER, x -> Optional.of(x.getSenderId())));
        refs.add(new TableReference(InboundMessageSequenceInterval.class, InboundMessageSequenceInterval.FK_SENDER, x -> Optional.of(x.getSenderId())));
        refs.add(new TableReference(PendingMessage.class, PendingMessage.FK_CONTACT_REF, x -> Optional.of(x.getContactRefId())));
        refs.add(new TableReference(IdentityRef.class, IdentityRef.FK_CONTACT_REF, x -> x.getContactRefId()));
        refs.add(new TableReference(Invitation.class, Invitation.FK_MEDIATOR_REF, x -> x.getMediatorRef().map(AbstractTableGenerated::getItemId)));
        refs.add(new TableReference(PendingGroupMember.class, PendingGroupMember.FK_CONTACT_REF, x -> Optional.of(x.getContactRefId())));
        refs.add(new TableReference(PreContact.class, PreContact.FK_CONTACT_REF, x -> Optional.of(x.getContactRefId())));
        references = List.copyOf(refs);
    }
}

