/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v9.reaction;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v9.IdentityRefV9;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractReactionV9<T extends AbstractReactionV9<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<AbstractReactionV9<?>, IdentityRefV9> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String EMOJI_NAME = "emoji";
    public static final Column.ObjectColumn<AbstractReactionV9<?>, String> EMOJI = new Column.ObjectColumn("emoji", true);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<AbstractReactionV9<?>> TIMESTAMP = new Column.longColumn("timestamp");
    @DatabaseField(columnName="fk_sender", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES identity_ref_table(gen_id)")
    protected IdentityRefV9 fkSender;
    @DatabaseField(columnName="emoji", dataType=DataType.STRING)
    protected String emoji;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;

    public AbstractReactionV9() {
    }

    protected AbstractReactionV9(long genId) {
        super(genId);
    }

    protected AbstractReactionV9(long genId, IdentityRefV9 sender, String emoji, long timestamp) {
        super(genId);
        this.fkSender = sender;
        this.emoji = emoji;
        this.timestamp = timestamp;
    }

    public Id<IdentityRefV9> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Optional<String> getEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("AbstractReaction[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractReactionV9 casted = (AbstractReactionV9)this.getClazz().cast(obj);
        return Objects.equals(this.fkSender, casted.fkSender) && Objects.equals(this.emoji, casted.emoji) && this.timestamp == casted.timestamp;
    }
}

