/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v9.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v9.DiscussionV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.IdentityRefV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.message.AbstractMessageV9;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="system_message_table")
public class SystemMessageV9
extends AbstractMessageV9<SystemMessageV9>
implements Table {
    public static final String TABLE_NAME = "system_message_table";
    private static final String CATEGORY_NAME = "category";
    public static final Column.ObjectColumn<SystemMessageV9, Category> CATEGORY = new Column.ObjectColumn("category", false);
    private static final String FK_IDENTITY_REF_NAME = "fk_identity_ref";
    public static final Column.ForeignColumn<SystemMessageV9, IdentityRefV9> FK_IDENTITY_REF = new Column.ForeignColumn("fk_identity_ref", true);
    private static final String READ_ONCE_NAME = "read_once";
    public static final Column.ObjectColumn<SystemMessageV9, Boolean> READ_ONCE = new Column.ObjectColumn("read_once", true);
    private static final String VISIBILITY_DURATION_NAME = "visibility_duration";
    public static final Column.ObjectColumn<SystemMessageV9, Long> VISIBILITY_DURATION = new Column.ObjectColumn("visibility_duration", true);
    private static final String EXISTENCE_DURATION_NAME = "existence_duration";
    public static final Column.ObjectColumn<SystemMessageV9, Long> EXISTENCE_DURATION = new Column.ObjectColumn("existence_duration", true);
    @DatabaseField(columnName="category", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Category category;
    @DatabaseField(columnName="fk_identity_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_ref REFERENCES identity_ref_table(gen_id) ON DELETE SET NULL")
    protected IdentityRefV9 fkIdentityRef;
    @DatabaseField(columnName="read_once", dataType=DataType.BOOLEAN_OBJ)
    protected Boolean readOnce;
    @DatabaseField(columnName="visibility_duration", dataType=DataType.LONG_OBJ)
    protected Long visibilityDuration;
    @DatabaseField(columnName="existence_duration", dataType=DataType.LONG_OBJ)
    protected Long existenceDuration;

    public SystemMessageV9() {
    }

    public SystemMessageV9(long genId) {
        super(genId);
    }

    public SystemMessageV9(long genId, DiscussionV9 discussion, long senderSequenceNumber, double sortIndex, long timestamp, Category category, IdentityRefV9 identityRef, Boolean readOnce, Long visibilityDuration, Long existenceDuration) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp);
        this.category = category;
        this.fkIdentityRef = identityRef;
        this.readOnce = readOnce;
        this.visibilityDuration = visibilityDuration;
        this.existenceDuration = existenceDuration;
    }

    public Category getCategory() {
        return this.category;
    }

    public Optional<Id<IdentityRefV9>> getIdentityRefId() {
        return Optional.ofNullable(this.fkIdentityRef).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Boolean> getReadOnce() {
        return Optional.ofNullable(this.readOnce);
    }

    public Optional<Long> getVisibilityDuration() {
        return Optional.ofNullable(this.visibilityDuration);
    }

    public Optional<Long> getExistenceDuration() {
        return Optional.ofNullable(this.existenceDuration);
    }

    @Override
    public String toString() {
        return String.format("SystemMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        SystemMessageV9 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && this.category == casted.category && Objects.equals(this.fkIdentityRef, casted.fkIdentityRef) && Objects.equals(this.readOnce, casted.readOnce) && Objects.equals(this.visibilityDuration, casted.visibilityDuration) && Objects.equals(this.existenceDuration, casted.existenceDuration);
    }

    @Override
    protected Class<SystemMessageV9> getClazz() {
        return SystemMessageV9.class;
    }

    public static enum Category implements IComparable<Category>
    {
        GROUP_MEMBER_JOINED,
        GROUP_MEMBER_LEFT,
        LEFT_GROUP,
        CONTACT_DELETED,
        DISCUSSION_SETTINGS_UPDATE,
        DISCUSSION_REMOTELY_DELETED,
        NEW_PUBLISHED_DETAILS,
        CONTACT_REVOKED,
        CONTACT_FORCEFULLY_UNBLOCKED,
        CONTACT_RE_ADDED,
        RE_JOINED_GROUP,
        JOINED_GROUP,
        GAINED_GROUP_ADMIN,
        LOST_GROUP_ADMIN,
        GROUP_MEMBERS_JOINED,
        GROUP_MEMBERS_LEFT;

    }
}

