/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v9.message;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v9.ContactRefV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.DiscussionV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.message.OutboundMessageV9;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;

@DatabaseTable(tableName="pending_message_table")
public class PendingMessageV9
extends AbstractTableGenerated<PendingMessageV9>
implements Table {
    public static final String TABLE_NAME = "pending_message_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<PendingMessageV9, DiscussionV9> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<PendingMessageV9, OutboundMessageV9> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<PendingMessageV9, ContactRefV9> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", false);
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV9 fkDiscussion;
    @DatabaseField(columnName="fk_message", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES outbound_message_table(gen_id) ON DELETE CASCADE")
    protected OutboundMessageV9 fkMessage;
    @DatabaseField(columnName="fk_contact_ref", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref NOT NULL REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV9 fkContactRef;

    public PendingMessageV9() {
    }

    public PendingMessageV9(long genId) {
        super(genId);
    }

    public PendingMessageV9(long genId, DiscussionV9 discussion, OutboundMessageV9 message, ContactRefV9 contactRef) {
        super(genId);
        this.fkDiscussion = discussion;
        this.fkMessage = message;
        this.fkContactRef = contactRef;
    }

    public Id<DiscussionV9> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public Id<OutboundMessageV9> getMessageId() {
        return this.fkMessage.getItemId();
    }

    public Id<ContactRefV9> getContactRefId() {
        return this.fkContactRef.getItemId();
    }

    public String toString() {
        return String.format("PendingMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PendingMessageV9 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && Objects.equals(this.fkMessage, casted.fkMessage) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    @Override
    protected Class<PendingMessageV9> getClazz() {
        return PendingMessageV9.class;
    }
}

