/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v9.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.annotations.ExtraStatements;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v9.DiscussionV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.LocationV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.ephemerality.OwnedMessageEphemeralInfoV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.message.AbstractUserMessageV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.message.MessageRefV9;
import io.olvid.windows.messenger.database.migrations.gen.v9.message.ReceivedMessageV9;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="owned_message_table")
public class OwnedMessageV9
extends ReceivedMessageV9<OwnedMessageV9>
implements Table {
    public static final String TABLE_NAME = "owned_message_table";
    private static final String CREATE_VIRTUAL_STATEMENT = "CREATE VIRTUAL TABLE IF NOT EXISTS owned_message_table_fts USING fts5(`body`, tokenize=\"unicode61 remove_diacritics 2\", content='owned_message_table', content_rowid='gen_id');";
    private static final String AFTER_CREATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS owned_message_table_ai AFTER INSERT ON owned_message_table BEGIN  INSERT INTO owned_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END;";
    private static final String AFTER_UPDATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS owned_message_table_au AFTER UPDATE ON owned_message_table FOR EACH ROW  WHEN  ( new.body IS NOT old.body ) BEGIN  INSERT INTO owned_message_table_fts (`owned_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); INSERT INTO owned_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END; ";
    private static final String AFTER_DELETE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS owned_message_table_ad AFTER DELETE ON owned_message_table BEGIN  INSERT INTO owned_message_table_fts (`owned_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); END;";
    private static final String FK_OWNED_MESSAGE_EPHEMERAL_INFO_NAME = "fk_owned_message_ephemeral_info";
    public static final Column.ForeignColumn<OwnedMessageV9, OwnedMessageEphemeralInfoV9> FK_OWNED_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_owned_message_ephemeral_info", true);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<OwnedMessageV9, Status> STATUS = new Column.ObjectColumn("status", false);
    @ExtraStatements
    public static final List<String> ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS;
    @DatabaseField(columnName="fk_owned_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_message_ephemeral_info REFERENCES owned_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected OwnedMessageEphemeralInfoV9 fkOwnedMessageEphemeralInfo;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;

    public OwnedMessageV9() {
    }

    public OwnedMessageV9(long genId) {
        super(genId);
    }

    public OwnedMessageV9(long genId, DiscussionV9 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV9 replyTo, LocationV9 location, AbstractUserMessageV9.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageV9.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageV9.EditionStatus editionStatus, boolean forwarded, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, long missedMessageCount, OwnedMessageEphemeralInfoV9 OwnedMessageEphemeralInfo2, Status status) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier, missedMessageCount);
        this.fkOwnedMessageEphemeralInfo = OwnedMessageEphemeralInfo2;
        this.status = status;
    }

    public Optional<Id<OwnedMessageEphemeralInfoV9>> getOwnedMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkOwnedMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return String.format("OwnedMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OwnedMessageV9 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkOwnedMessageEphemeralInfo, casted.fkOwnedMessageEphemeralInfo) && this.status == casted.status;
    }

    @Override
    protected Class<OwnedMessageV9> getClazz() {
        return OwnedMessageV9.class;
    }

    static {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(CREATE_VIRTUAL_STATEMENT);
        statements.add(AFTER_CREATE_STATEMENT);
        statements.add(AFTER_UPDATE_STATEMENT);
        statements.add(AFTER_DELETE_STATEMENT);
        ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS = List.copyOf(statements);
    }

    public static enum Status implements IComparable<Status>
    {
        SENT;

    }
}

