/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v9;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="fyle_table")
public class FyleV9
extends AbstractTableGenerated<FyleV9>
implements Table {
    public static final String TABLE_NAME = "fyle_table";
    private static final String FILE_PATH_NAME = "file_path";
    public static final Column.ObjectColumn<FyleV9, String> FILE_PATH = new Column.ObjectColumn("file_path", false);
    private static final String SHA256_NAME = "sha256";
    public static final Column.ObjectColumn<FyleV9, byte[]> SHA256 = new Column.ObjectColumn("sha256", true);
    @DatabaseField(columnName="file_path", canBeNull=false, dataType=DataType.STRING)
    protected String filePath;
    @DatabaseField(columnName="sha256", unique=true, dataType=DataType.BYTE_ARRAY)
    protected byte[] sha256;

    public FyleV9() {
    }

    public FyleV9(long genId) {
        super(genId);
    }

    public FyleV9(long genId, String filePath, byte[] sha256) {
        super(genId);
        this.filePath = filePath;
        this.sha256 = sha256;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Optional<byte[]> getSha256() {
        return Optional.ofNullable(this.sha256);
    }

    public void setSha256(Optional<byte[]> sha256) {
        this.sha256 = sha256.orElse(null);
    }

    public String toString() {
        return String.format("Fyle[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        FyleV9 casted = this.getClazz().cast(obj);
        return Objects.equals(this.filePath, casted.filePath) && Arrays.equals(this.sha256, casted.sha256);
    }

    @Override
    protected Class<FyleV9> getClazz() {
        return FyleV9.class;
    }
}

