/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v8.message;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v8.ContactRefV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.DiscussionV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.message.OutboundMessageV8;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;

@DatabaseTable(tableName="pending_message_table")
public class PendingMessageV8
extends AbstractTableGenerated<PendingMessageV8>
implements Table {
    public static final String TABLE_NAME = "pending_message_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<PendingMessageV8, DiscussionV8> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<PendingMessageV8, OutboundMessageV8> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<PendingMessageV8, ContactRefV8> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", false);
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV8 fkDiscussion;
    @DatabaseField(columnName="fk_message", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES outbound_message_table(gen_id) ON DELETE CASCADE")
    protected OutboundMessageV8 fkMessage;
    @DatabaseField(columnName="fk_contact_ref", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref NOT NULL REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV8 fkContactRef;

    public PendingMessageV8() {
    }

    public PendingMessageV8(long genId) {
        super(genId);
    }

    public PendingMessageV8(long genId, DiscussionV8 discussion, OutboundMessageV8 message, ContactRefV8 contactRef) {
        super(genId);
        this.fkDiscussion = discussion;
        this.fkMessage = message;
        this.fkContactRef = contactRef;
    }

    public Id<DiscussionV8> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public Id<OutboundMessageV8> getMessageId() {
        return this.fkMessage.getItemId();
    }

    public Id<ContactRefV8> getContactRefId() {
        return this.fkContactRef.getItemId();
    }

    public String toString() {
        return String.format("PendingMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PendingMessageV8 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && Objects.equals(this.fkMessage, casted.fkMessage) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    @Override
    protected Class<PendingMessageV8> getClazz() {
        return PendingMessageV8.class;
    }
}

