/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v8;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v8.CapabilitiesV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.IdentityDetailsV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.OwnedIdentityV8;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="contact_table")
public class ContactV8
extends AbstractTableGenerated<ContactV8>
implements Table {
    public static final String TABLE_NAME = "contact_table";
    private static final String ONE_TO_ONE_NAME = "one_to_one";
    public static final Column.booleanColumn<ContactV8> ONE_TO_ONE = new Column.booleanColumn("one_to_one");
    private static final String BYTES_CONTACT_IDENTITY_NAME = "bytes_contact_identity";
    public static final Column.ObjectColumn<ContactV8, byte[]> BYTES_CONTACT_IDENTITY = new Column.ObjectColumn("bytes_contact_identity", false);
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<ContactV8, OwnedIdentityV8> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String CUSTOM_DISPLAY_NAME_NAME = "custom_display_name";
    public static final Column.ObjectColumn<ContactV8, String> CUSTOM_DISPLAY_NAME = new Column.ObjectColumn("custom_display_name", true);
    private static final String SORT_DISPLAY_NAME_NAME = "sort_display_name";
    public static final Column.ObjectColumn<ContactV8, byte[]> SORT_DISPLAY_NAME = new Column.ObjectColumn("sort_display_name", false);
    private static final String FK_IDENTITY_DETAILS_NAME = "fk_identity_details";
    public static final Column.ForeignColumn<ContactV8, IdentityDetailsV8> FK_IDENTITY_DETAILS = new Column.ForeignColumn("fk_identity_details", false);
    private static final String NEW_PUBLISHED_DETAILS_NAME = "new_published_details";
    public static final Column.ObjectColumn<ContactV8, UnpublishedDetails> NEW_PUBLISHED_DETAILS = new Column.ObjectColumn("new_published_details", false);
    private static final String TRUST_LEVEL_NAME = "trust_level";
    public static final Column.intColumn<ContactV8> TRUST_LEVEL = new Column.intColumn("trust_level");
    private static final String DEVICE_COUNT_NAME = "device_count";
    public static final Column.intColumn<ContactV8> DEVICE_COUNT = new Column.intColumn("device_count");
    private static final String ESTABLISHED_CHANNEL_COUNT_NAME = "established_channel_count";
    public static final Column.intColumn<ContactV8> ESTABLISHED_CHANNEL_COUNT = new Column.intColumn("established_channel_count");
    private static final String PRE_KEY_COUNT_NAME = "pre_key_count";
    public static final Column.intColumn<ContactV8> PRE_KEY_COUNT = new Column.intColumn("pre_key_count");
    private static final String CUSTOM_PHOTO_URL_NAME = "custom_photo_url";
    public static final Column.ObjectColumn<ContactV8, String> CUSTOM_PHOTO_URL = new Column.ObjectColumn("custom_photo_url", true);
    private static final String KEYCLOAK_MANAGED_NAME = "keycloak_managed";
    public static final Column.booleanColumn<ContactV8> KEYCLOAK_MANAGED = new Column.booleanColumn("keycloak_managed");
    private static final String ACTIVE_NAME = "active";
    public static final Column.booleanColumn<ContactV8> ACTIVE = new Column.booleanColumn("active");
    private static final String RECENTLY_ONLINE_NAME = "recently_online";
    public static final Column.booleanColumn<ContactV8> RECENTLY_ONLINE = new Column.booleanColumn("recently_online");
    private static final String FK_CAPABILITIES_NAME = "fk_capabilities";
    public static final Column.ForeignColumn<ContactV8, CapabilitiesV8> FK_CAPABILITIES = new Column.ForeignColumn("fk_capabilities", false);
    @DatabaseField(columnName="one_to_one", dataType=DataType.BOOLEAN)
    protected boolean oneToOne;
    @DatabaseField(columnName="bytes_contact_identity", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesContactIdentity;
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV8 fkOwnedIdentity;
    @DatabaseField(columnName="custom_display_name", dataType=DataType.STRING)
    protected String customDisplayName;
    @DatabaseField(columnName="sort_display_name", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] sortDisplayName;
    @DatabaseField(columnName="fk_identity_details", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_details UNIQUE NOT NULL REFERENCES identity_details_table(gen_id)")
    protected IdentityDetailsV8 fkIdentityDetails;
    @DatabaseField(columnName="new_published_details", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected UnpublishedDetails newPublishedDetails;
    @DatabaseField(columnName="trust_level", dataType=DataType.INTEGER)
    protected int trustLevel;
    @DatabaseField(columnName="device_count", dataType=DataType.INTEGER)
    protected int deviceCount;
    @DatabaseField(columnName="established_channel_count", dataType=DataType.INTEGER)
    protected int establishedChannelCount;
    @DatabaseField(columnName="pre_key_count", dataType=DataType.INTEGER)
    protected int preKeyCount;
    @DatabaseField(columnName="custom_photo_url", dataType=DataType.STRING)
    protected String customPhotoUrl;
    @DatabaseField(columnName="keycloak_managed", dataType=DataType.BOOLEAN)
    protected boolean keycloakManaged;
    @DatabaseField(columnName="active", dataType=DataType.BOOLEAN)
    protected boolean active;
    @DatabaseField(columnName="recently_online", dataType=DataType.BOOLEAN)
    protected boolean recentlyOnline;
    @DatabaseField(columnName="fk_capabilities", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_capabilities UNIQUE NOT NULL REFERENCES capabilities_table(gen_id)")
    protected CapabilitiesV8 fkCapabilities;

    public ContactV8() {
    }

    public ContactV8(long genId) {
        super(genId);
    }

    public ContactV8(long genId, boolean oneToOne, byte[] bytesContactIdentity, OwnedIdentityV8 ownedIdentity, String customDisplayName, byte[] sortDisplayName, IdentityDetailsV8 identityDetails, UnpublishedDetails newPublishedDetails, int trustLevel, int deviceCount, int establishedChannelCount, int preKeyCount, String customPhotoUrl, boolean keycloakManaged, boolean active, boolean recentlyOnline, CapabilitiesV8 capabilities) {
        super(genId);
        this.oneToOne = oneToOne;
        this.bytesContactIdentity = bytesContactIdentity;
        this.fkOwnedIdentity = ownedIdentity;
        this.customDisplayName = customDisplayName;
        this.sortDisplayName = sortDisplayName;
        this.fkIdentityDetails = identityDetails;
        this.newPublishedDetails = newPublishedDetails;
        this.trustLevel = trustLevel;
        this.deviceCount = deviceCount;
        this.establishedChannelCount = establishedChannelCount;
        this.preKeyCount = preKeyCount;
        this.customPhotoUrl = customPhotoUrl;
        this.keycloakManaged = keycloakManaged;
        this.active = active;
        this.recentlyOnline = recentlyOnline;
        this.fkCapabilities = capabilities;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public byte[] getBytesContactIdentity() {
        return this.bytesContactIdentity;
    }

    public Id<OwnedIdentityV8> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Optional<String> getCustomDisplayName() {
        return Optional.ofNullable(this.customDisplayName);
    }

    public byte[] getSortDisplayName() {
        return this.sortDisplayName;
    }

    public Id<IdentityDetailsV8> getIdentityDetailsId() {
        return this.fkIdentityDetails.getItemId();
    }

    public UnpublishedDetails getNewPublishedDetails() {
        return this.newPublishedDetails;
    }

    public int getTrustLevel() {
        return this.trustLevel;
    }

    public int getDeviceCount() {
        return this.deviceCount;
    }

    public int getEstablishedChannelCount() {
        return this.establishedChannelCount;
    }

    public int getPreKeyCount() {
        return this.preKeyCount;
    }

    public void setPreKeyCount(int preKeyCount) {
        this.preKeyCount = preKeyCount;
    }

    public Optional<String> getCustomPhotoUrl() {
        return Optional.ofNullable(this.customPhotoUrl);
    }

    public boolean isKeycloakManaged() {
        return this.keycloakManaged;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isRecentlyOnline() {
        return this.recentlyOnline;
    }

    public void setRecentlyOnline(boolean recentlyOnline) {
        this.recentlyOnline = recentlyOnline;
    }

    public Id<CapabilitiesV8> getCapabilitiesId() {
        return this.fkCapabilities.getItemId();
    }

    public String toString() {
        return String.format("Contact[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ContactV8 casted = this.getClazz().cast(obj);
        return this.oneToOne == casted.oneToOne && Arrays.equals(this.bytesContactIdentity, casted.bytesContactIdentity) && Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.customDisplayName, casted.customDisplayName) && Arrays.equals(this.sortDisplayName, casted.sortDisplayName) && Objects.equals(this.fkIdentityDetails, casted.fkIdentityDetails) && this.newPublishedDetails == casted.newPublishedDetails && this.trustLevel == casted.trustLevel && this.deviceCount == casted.deviceCount && this.establishedChannelCount == casted.establishedChannelCount && this.preKeyCount == casted.preKeyCount && Objects.equals(this.customPhotoUrl, casted.customPhotoUrl) && this.keycloakManaged == casted.keycloakManaged && this.active == casted.active && this.recentlyOnline == casted.recentlyOnline && Objects.equals(this.fkCapabilities, casted.fkCapabilities);
    }

    @Override
    protected Class<ContactV8> getClazz() {
        return ContactV8.class;
    }

    public static enum UnpublishedDetails implements IComparable<UnpublishedDetails>
    {
        NOTHING_NEW,
        NEW_UNSEEN,
        NEW_SEEN;

    }
}

